/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.entity.misc;

import ic2.core.IC2;
import ic2.core.entity.misc.EntityMiningLaser;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityTrackingMiningLaser
extends EntityMiningLaser {
    Entity target;

    public EntityTrackingMiningLaser(World worldIn) {
        super(worldIn);
    }

    public EntityTrackingMiningLaser(World world, EntityLivingBase entityliving, float range, float power, int blockBreaks, Entity toReach) {
        super(world, entityliving, range, power, blockBreaks, false);
        this.target = toReach;
    }

    @Override
    public void func_70071_h_() {
        if (this.target == null || this.target.field_70128_L) {
            if (IC2.platform.isSimulating()) {
                this.func_70106_y();
            }
            return;
        }
        Vec3d targetPosition = this.getTargetVector();
        double d0 = targetPosition.field_72450_a - this.field_70165_t;
        double d1 = targetPosition.field_72448_b - this.field_70163_u;
        double d2 = targetPosition.field_72449_c - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
        float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
        this.field_70125_A = this.updateRotation(this.field_70125_A, f1, 360.0f);
        this.field_70177_z = this.updateRotation(this.field_70177_z, f, 360.0f);
        double yaw = Math.toRadians(this.field_70177_z);
        double pitch = Math.toRadians(this.field_70125_A);
        double startMotionX = -Math.sin(yaw) * Math.cos(pitch);
        double startMotionY = -Math.sin(pitch);
        double startMotionZ = Math.cos(yaw) * Math.cos(pitch);
        this.setLaserHeading(startMotionX, startMotionY, startMotionZ, 1.0);
        super.func_70071_h_();
    }

    private float updateRotation(float p_75652_1_, float p_75652_2_, float p_75652_3_) {
        float f = MathHelper.func_76142_g((float)(p_75652_2_ - p_75652_1_));
        if (f > p_75652_3_) {
            f = p_75652_3_;
        }
        if (f < -p_75652_3_) {
            f = -p_75652_3_;
        }
        return p_75652_1_ + f;
    }

    public Vec3d getTargetVector() {
        AxisAlignedBB box = this.target.func_174813_aQ();
        if (box != null) {
            return new Vec3d((box.field_72336_d - box.field_72340_a) / 2.0, (box.field_72337_e - box.field_72338_b) / 2.0, (box.field_72334_f - box.field_72339_c) / 2.0).func_178787_e(this.target.func_174791_d());
        }
        return this.target.func_174791_d();
    }
}

