/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor.electric;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.item.armor.base.ItemIC2AdvArmorBase;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemArmorStaticBoots
extends ItemIC2AdvArmorBase {
    public ItemArmorStaticBoots(int index, EntityEquipmentSlot equipmentSlotIn) {
        super(index, equipmentSlotIn);
    }

    @Override
    public String getTexture() {
        return "ic2:textures/models/armor/rubber";
    }

    @Override
    public ItemStack getRepairItem() {
        return Ic2Items.refinedIronIngot.func_77946_l();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        sortedTooltip.get((Object)ToolTipType.Shift).add(Ic2InfoLang.staticBootsProduceEU.getLocalized());
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        int charge = this.getCharge(stack);
        if (world.func_82737_E() % 10L == 0L && charge > 0) {
            this.chargeItems(player, stack);
        }
        if (charge < 20) {
            double distance;
            boolean isNotWalking;
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
            boolean bl = isNotWalking = player.func_184187_bx() != null || player.func_70090_H();
            if (!nbt.func_74764_b("x") || isNotWalking) {
                nbt.func_74768_a("x", (int)player.field_70165_t);
            }
            if (!nbt.func_74764_b("z") || isNotWalking) {
                nbt.func_74768_a("z", (int)player.field_70161_v);
            }
            if ((distance = Math.sqrt((nbt.func_74762_e("x") - (int)player.field_70165_t) * (nbt.func_74762_e("x") - (int)player.field_70165_t) + (nbt.func_74762_e("z") - (int)player.field_70161_v) * (nbt.func_74762_e("z") - (int)player.field_70161_v))) >= 5.0) {
                nbt.func_74768_a("x", (int)player.field_70165_t);
                nbt.func_74768_a("z", (int)player.field_70161_v);
                this.setCharge(stack, charge + Math.min(3, (int)distance / 5));
            }
        }
    }

    public void chargeItems(EntityPlayer player, ItemStack stack) {
        ItemStack other;
        EntityEquipmentSlot slot;
        int charge = this.getCharge(stack);
        EntityEquipmentSlot[] entityEquipmentSlotArray = EntityEquipmentSlot.values();
        int n = entityEquipmentSlotArray.length;
        for (int i = 0; !(i >= n || (slot = entityEquipmentSlotArray[i]) != EntityEquipmentSlot.FEET && slot.func_188453_a() == EntityEquipmentSlot.Type.ARMOR && (other = player.func_184582_a(slot)) != null && other.func_77973_b() instanceof IElectricItem && (charge = (int)((double)charge - ElectricItem.manager.charge(other, charge, Integer.MAX_VALUE, false, false))) <= 0); ++i) {
        }
        this.setCharge(stack, charge);
    }

    public int getCharge(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74762_e("Charge");
    }

    public void setCharge(ItemStack stack, int charge) {
        StackUtil.getOrCreateNbtData(stack).func_74768_a("Charge", charge);
    }
}

