/*
 * Decompiled with CFR 0.152.
 */
package nc.fluid;

import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class FluidBase
extends Fluid {
    public FluidBase(String fluidName, boolean canBeStill) {
        super(fluidName, new ResourceLocation("nuclearcraft:blocks/fluids/" + fluidName + (canBeStill ? "_still" : "")), new ResourceLocation("nuclearcraft:blocks/fluids/" + fluidName + (canBeStill ? "_flow" : "")));
        boolean defaultFluid = FluidRegistry.registerFluid((Fluid)this);
        if (defaultFluid) {
            FluidRegistry.addBucketForFluid((Fluid)this);
        }
    }

    public FluidBase(String fluidName, boolean canBeStill, String textureName, Integer colour) {
        super(fluidName, new ResourceLocation("nuclearcraft:blocks/fluids/" + textureName + (canBeStill ? "_still" : "")), new ResourceLocation("nuclearcraft:blocks/fluids/" + textureName + (canBeStill ? "_flow" : "")));
        int fixedColour = colour;
        if ((fixedColour >> 24 & 0xFF) == 0) {
            fixedColour |= 0xFF000000;
        }
        this.setColor(fixedColour);
        boolean defaultFluid = FluidRegistry.registerFluid((Fluid)this);
        if (defaultFluid) {
            FluidRegistry.addBucketForFluid((Fluid)this);
        }
    }

    public FluidBase(String fluidName, Integer colour) {
        this(fluidName, true, "liquid", colour);
    }
}

