/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import java.util.ArrayList;
import java.util.List;
import nc.integration.crafttweaker.CTHelper;
import nc.recipe.ProcessorRecipe;
import nc.recipe.ProcessorRecipeHandler;
import nc.recipe.RecipeHelper;
import nc.recipe.ingredient.ChanceFluidIngredient;
import nc.recipe.ingredient.ChanceItemIngredient;
import nc.recipe.ingredient.EmptyFluidIngredient;
import nc.recipe.ingredient.EmptyItemIngredient;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IIngredient;
import nc.recipe.ingredient.IItemIngredient;
import net.minecraft.item.ItemStack;

public class AddProcessorRecipe
implements IAction {
    public static boolean hasErrored = false;
    public List<IItemIngredient> itemIngredients;
    public List<IFluidIngredient> fluidIngredients;
    public List<IItemIngredient> itemProducts;
    public List<IFluidIngredient> fluidProducts;
    public List extras;
    public ProcessorRecipe recipe;
    public boolean inputsAllNull = true;
    public boolean ingredientError;
    public boolean wasNull;
    public boolean wrongSize;
    public final ProcessorRecipeHandler recipeHandler;

    public AddProcessorRecipe(ProcessorRecipeHandler recipeHandler, List<Object> objects) {
        this.recipeHandler = recipeHandler;
        int listCount = 0;
        int ingredientCount = 0;
        ArrayList<IItemIngredient> itemIngredients = new ArrayList<IItemIngredient>();
        ArrayList<IFluidIngredient> fluidIngredients = new ArrayList<IFluidIngredient>();
        ArrayList<IItemIngredient> itemProducts = new ArrayList<IItemIngredient>();
        ArrayList<IFluidIngredient> fluidProducts = new ArrayList<IFluidIngredient>();
        ArrayList<Object> extras = new ArrayList<Object>();
        while (listCount < objects.size()) {
            int chancePercent;
            IIngredient<ItemStack> ingredient;
            Object nextNextNextObject;
            Object object = objects.get(listCount);
            Object nextObject = listCount + 1 < objects.size() ? objects.get(listCount + 1) : null;
            Object nextNextObject = listCount + 2 < objects.size() ? objects.get(listCount + 2) : null;
            Object object2 = nextNextNextObject = listCount + 3 < objects.size() ? objects.get(listCount + 3) : null;
            if (ingredientCount < recipeHandler.itemInputSize) {
                if (object != null) {
                    if (!(object instanceof crafttweaker.api.item.IIngredient)) {
                        this.ingredientError = true;
                        return;
                    }
                    this.inputsAllNull = false;
                }
                if ((ingredient = CTHelper.buildAdditionItemIngredient(object, recipeHandler)) == null) {
                    this.ingredientError = true;
                    return;
                }
                itemIngredients.add((IItemIngredient)ingredient);
            } else if (ingredientCount < recipeHandler.itemInputSize + recipeHandler.fluidInputSize) {
                if (object != null) {
                    if (!(object instanceof crafttweaker.api.item.IIngredient)) {
                        this.ingredientError = true;
                        return;
                    }
                    this.inputsAllNull = false;
                }
                if ((ingredient = CTHelper.buildAdditionFluidIngredient(object, recipeHandler)) == null) {
                    this.ingredientError = true;
                    return;
                }
                fluidIngredients.add((IFluidIngredient)ingredient);
            } else if (ingredientCount < recipeHandler.itemInputSize + recipeHandler.fluidInputSize + recipeHandler.itemOutputSize) {
                if (object != null && !(object instanceof crafttweaker.api.item.IIngredient)) {
                    this.ingredientError = true;
                    return;
                }
                ingredient = CTHelper.buildAdditionItemIngredient(object, recipeHandler);
                if (ingredient == null) {
                    this.ingredientError = true;
                    return;
                }
                if (nextObject instanceof Integer && nextNextObject instanceof Integer) {
                    chancePercent = (Integer)nextObject;
                    int minStackSize = (Integer)nextNextObject;
                    if (chancePercent <= 0) {
                        ingredient = new EmptyItemIngredient();
                    } else if (chancePercent < 100) {
                        ingredient = new ChanceItemIngredient((IItemIngredient)ingredient, chancePercent, minStackSize);
                    }
                    listCount += 2;
                } else if (nextObject instanceof Integer) {
                    chancePercent = (Integer)nextObject;
                    if (chancePercent <= 0) {
                        ingredient = new EmptyItemIngredient();
                    } else if (chancePercent < 100) {
                        ingredient = new ChanceItemIngredient((IItemIngredient)ingredient, chancePercent);
                    }
                    ++listCount;
                }
                itemProducts.add((IItemIngredient)ingredient);
            } else if (ingredientCount < recipeHandler.itemInputSize + recipeHandler.fluidInputSize + recipeHandler.itemOutputSize + recipeHandler.fluidOutputSize) {
                int stackDiff;
                if (object != null && !(object instanceof crafttweaker.api.item.IIngredient)) {
                    this.ingredientError = true;
                    return;
                }
                ingredient = CTHelper.buildAdditionFluidIngredient(object, recipeHandler);
                if (ingredient == null) {
                    this.ingredientError = true;
                    return;
                }
                if (nextObject instanceof Integer && nextNextObject instanceof Integer && nextNextNextObject instanceof Integer) {
                    chancePercent = (Integer)nextObject;
                    stackDiff = (Integer)nextNextObject;
                    int minStackSize = (Integer)nextNextNextObject;
                    if (chancePercent <= 0) {
                        ingredient = new EmptyFluidIngredient();
                    } else if (chancePercent < 100) {
                        ingredient = new ChanceFluidIngredient((IFluidIngredient)ingredient, chancePercent, stackDiff, minStackSize);
                    }
                    listCount += 3;
                } else if (nextObject instanceof Integer && nextNextObject instanceof Integer) {
                    chancePercent = (Integer)nextObject;
                    stackDiff = (Integer)nextNextObject;
                    if (chancePercent <= 0) {
                        ingredient = new EmptyFluidIngredient();
                    } else if (chancePercent < 100) {
                        ingredient = new ChanceFluidIngredient((IFluidIngredient)ingredient, chancePercent, stackDiff);
                    }
                    listCount += 2;
                }
                fluidProducts.add((IFluidIngredient)ingredient);
            } else {
                extras.add(object);
            }
            ++listCount;
            ++ingredientCount;
        }
        if (itemIngredients.size() != recipeHandler.itemInputSize || fluidIngredients.size() != recipeHandler.fluidInputSize || itemProducts.size() != recipeHandler.itemOutputSize || fluidProducts.size() != recipeHandler.fluidOutputSize) {
            CraftTweakerAPI.logError((String)("A " + recipeHandler.getRecipeName() + " recipe was the wrong size"));
            this.wrongSize = true;
            return;
        }
        this.itemIngredients = itemIngredients;
        this.fluidIngredients = fluidIngredients;
        this.itemProducts = itemProducts;
        this.fluidProducts = fluidProducts;
        this.extras = extras;
        this.recipe = recipeHandler.buildRecipe(itemIngredients, fluidIngredients, itemProducts, fluidProducts, extras, recipeHandler.isShapeless);
        if (this.recipe == null) {
            this.wasNull = true;
        }
    }

    public void apply() {
        if (!(this.inputsAllNull || this.ingredientError || this.wasNull || this.wrongSize)) {
            this.recipeHandler.addRecipe(this.recipe);
        }
    }

    public String describe() {
        if (this.inputsAllNull || this.ingredientError || this.wasNull || this.wrongSize) {
            if (this.ingredientError || this.wrongSize) {
                AddProcessorRecipe.callError();
            }
            return String.format("Error: Failed to add %s recipe: %s", this.recipeHandler.getRecipeName(), RecipeHelper.getRecipeString(this.itemIngredients, this.fluidIngredients, this.itemProducts, this.fluidProducts));
        }
        return String.format("Adding %s recipe: %s", this.recipeHandler.getRecipeName(), RecipeHelper.getRecipeString(this.itemIngredients, this.fluidIngredients, this.itemProducts, this.fluidProducts));
    }

    public static void callError() {
        if (!hasErrored) {
            CraftTweakerAPI.logError((String)"At least one NuclearCraft CraftTweaker recipe addition method has errored - check the CraftTweaker log for more details");
        }
        hasErrored = true;
    }
}

