/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.energyFluid;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.tile.energy.TileEnergy;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.FluidTileWrapper;
import nc.tile.internal.fluid.GasTileWrapper;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankOutputSetting;
import nc.util.GasHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public abstract class TileEnergyFluid
extends TileEnergy
implements ITileFluid {
    @Nonnull
    private final List<Tank> tanks = new ArrayList<Tank>();
    @Nonnull
    private FluidConnection[] fluidConnections;
    @Nonnull
    private final FluidTileWrapper[] fluidSides;
    @Nonnull
    private final GasTileWrapper gasWrapper;
    private boolean inputTanksSeparated = false;
    private final List<Boolean> voidUnusableFluidInputs = new ArrayList<Boolean>();
    private final List<TankOutputSetting> tankOutputSettings = new ArrayList<TankOutputSetting>();

    public TileEnergyFluid(int capacity, @Nonnull EnergyConnection[] energyConnections, int fluidCapacity, List<String> allowedFluidsList, @Nonnull FluidConnection[] fluidConnections) {
        this(capacity, capacity, energyConnections, Lists.newArrayList((Object[])new Integer[]{fluidCapacity}), Lists.newArrayList((Object[])new Integer[]{fluidCapacity}), Lists.newArrayList((Object[])new List[]{allowedFluidsList}), fluidConnections);
    }

    public TileEnergyFluid(int capacity, @Nonnull EnergyConnection[] energyConnections, @Nonnull List<Integer> fluidCapacity, List<List<String>> allowedFluidsLists, @Nonnull FluidConnection[] fluidConnections) {
        this(capacity, capacity, energyConnections, fluidCapacity, fluidCapacity, allowedFluidsLists, fluidConnections);
    }

    public TileEnergyFluid(int capacity, @Nonnull EnergyConnection[] energyConnections, int fluidCapacity, int maxFluidTransfer, List<String> allowedFluidsList, @Nonnull FluidConnection[] fluidConnections) {
        this(capacity, capacity, energyConnections, Lists.newArrayList((Object[])new Integer[]{fluidCapacity}), Lists.newArrayList((Object[])new Integer[]{maxFluidTransfer}), Lists.newArrayList((Object[])new List[]{allowedFluidsList}), fluidConnections);
    }

    public TileEnergyFluid(int capacity, @Nonnull EnergyConnection[] energyConnections, @Nonnull List<Integer> fluidCapacity, @Nonnull List<Integer> maxFluidTransfer, List<List<String>> allowedFluidsLists, @Nonnull FluidConnection[] fluidConnections) {
        this(capacity, capacity, energyConnections, fluidCapacity, maxFluidTransfer, allowedFluidsLists, fluidConnections);
    }

    public TileEnergyFluid(int capacity, int maxTransfer, @Nonnull EnergyConnection[] energyConnections, int fluidCapacity, List<String> allowedFluidsList, @Nonnull FluidConnection[] fluidConnections) {
        this(capacity, maxTransfer, energyConnections, Lists.newArrayList((Object[])new Integer[]{fluidCapacity}), Lists.newArrayList((Object[])new Integer[]{fluidCapacity}), Lists.newArrayList((Object[])new List[]{allowedFluidsList}), fluidConnections);
    }

    public TileEnergyFluid(int capacity, int maxTransfer, @Nonnull EnergyConnection[] energyConnections, @Nonnull List<Integer> fluidCapacity, List<List<String>> allowedFluidsLists, @Nonnull FluidConnection[] fluidConnections) {
        this(capacity, maxTransfer, energyConnections, fluidCapacity, fluidCapacity, allowedFluidsLists, fluidConnections);
    }

    public TileEnergyFluid(int capacity, int maxTransfer, @Nonnull EnergyConnection[] energyConnections, int fluidCapacity, int maxFluidTransfer, List<String> allowedFluidsList, @Nonnull FluidConnection[] fluidConnections) {
        this(capacity, maxTransfer, energyConnections, Lists.newArrayList((Object[])new Integer[]{fluidCapacity}), Lists.newArrayList((Object[])new Integer[]{maxFluidTransfer}), Lists.newArrayList((Object[])new List[]{allowedFluidsList}), fluidConnections);
    }

    public TileEnergyFluid(int capacity, int maxTransfer, @Nonnull EnergyConnection[] energyConnections, @Nonnull List<Integer> fluidCapacity, @Nonnull List<Integer> maxFluidTransfer, List<List<String>> allowedFluidsLists, @Nonnull FluidConnection[] fluidConnections) {
        super(capacity, maxTransfer, energyConnections);
        if (!fluidCapacity.isEmpty()) {
            for (int i = 0; i < fluidCapacity.size(); ++i) {
                this.tanks.add(new Tank(fluidCapacity.get(i), maxFluidTransfer.get(i), allowedFluidsLists == null || allowedFluidsLists.size() <= i ? null : allowedFluidsLists.get(i)));
                this.voidUnusableFluidInputs.add(false);
                this.tankOutputSettings.add(TankOutputSetting.DEFAULT);
            }
        }
        this.fluidConnections = fluidConnections;
        this.fluidSides = ITileFluid.getDefaultFluidSides(this);
        this.gasWrapper = new GasTileWrapper(this);
    }

    @Override
    @Nonnull
    public List<Tank> getTanks() {
        return this.tanks;
    }

    @Override
    @Nonnull
    public FluidConnection[] getFluidConnections() {
        return this.fluidConnections;
    }

    @Override
    public void setFluidConnections(@Nonnull FluidConnection[] connections) {
        this.fluidConnections = connections;
    }

    @Override
    @Nonnull
    public FluidTileWrapper[] getFluidSides() {
        return this.fluidSides;
    }

    @Override
    @Nonnull
    public GasTileWrapper getGasWrapper() {
        return this.gasWrapper;
    }

    @Override
    public boolean getInputTanksSeparated() {
        return this.inputTanksSeparated;
    }

    @Override
    public void setInputTanksSeparated(boolean shared) {
        this.inputTanksSeparated = shared;
    }

    @Override
    public boolean getVoidUnusableFluidInput(int tankNumber) {
        return this.voidUnusableFluidInputs.get(tankNumber);
    }

    @Override
    public void setVoidUnusableFluidInput(int tankNumber, boolean voidUnusableFluidInput) {
        this.voidUnusableFluidInputs.set(tankNumber, voidUnusableFluidInput);
    }

    @Override
    public TankOutputSetting getTankOutputSetting(int tankNumber) {
        return this.tankOutputSettings.get(tankNumber);
    }

    @Override
    public void setTankOutputSetting(int tankNumber, TankOutputSetting setting) {
        this.tankOutputSettings.set(tankNumber, setting);
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeTanks(nbt);
        this.writeFluidConnections(nbt);
        this.writeTankSettings(nbt);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readTanks(nbt);
        this.readFluidConnections(nbt);
        this.readTankSettings(nbt);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || ModCheck.mekanismLoaded() && NCConfig.enable_mek_gas && capability == GasHelper.GAS_HANDLER_CAPABILITY) {
            return !this.getTanks().isEmpty() && this.hasFluidSideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (!this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
                return (T)this.getFluidSide(this.nonNullSide(side));
            }
            return null;
        }
        if (ModCheck.mekanismLoaded() && capability == GasHelper.GAS_HANDLER_CAPABILITY) {
            if (NCConfig.enable_mek_gas && !this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
                return (T)this.getGasWrapper();
            }
            return null;
        }
        return super.getCapability(capability, side);
    }
}

