/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.relic.ItemRelicBauble;

@Mod.EventBusSubscriber(modid="botania")
public class ItemOdinRing
extends ItemRelicBauble {
    private static final List<String> damageNegations = new ArrayList<String>();

    public ItemOdinRing() {
        super("odinRing");
        damageNegations.add(DamageSource.field_76369_e.field_76373_n);
        damageNegations.add(DamageSource.field_76379_h.field_76373_n);
        damageNegations.add(DamageSource.field_76371_c.field_76373_n);
        if (ConfigHandler.ringOfOdinFireResist) {
            damageNegations.add(DamageSource.field_76372_a.field_76373_n);
            damageNegations.add(DamageSource.field_76370_b.field_76373_n);
        }
        damageNegations.add(DamageSource.field_76368_d.field_76373_n);
        damageNegations.add(DamageSource.field_76366_f.field_76373_n);
    }

    @Override
    public void onValidPlayerWornTick(ItemStack stack, EntityPlayer player) {
        if (player.func_70027_ad() && ConfigHandler.ringOfOdinFireResist) {
            player.func_70066_B();
        }
    }

    @SubscribeEvent
    public static void onPlayerAttacked(LivingAttackEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && !ItemOdinRing.getOdinRing(player = (EntityPlayer)event.getEntityLiving()).func_190926_b() && damageNegations.contains(event.getSource().field_76373_n)) {
            event.setCanceled(true);
        }
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.RING;
    }

    public static ItemStack getOdinRing(EntityPlayer player) {
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        int slot = BaublesApi.isBaubleEquipped((EntityPlayer)player, (Item)ModItems.odinRing);
        if (slot < 0) {
            return ItemStack.field_190927_a;
        }
        return baubles.getStackInSlot(slot);
    }

    @Override
    public void onEquippedOrLoadedIntoWorld(ItemStack stack, EntityLivingBase player) {
        if (!player.field_70170_p.field_72995_K) {
            HashMultimap attributes = HashMultimap.create();
            this.fillModifiers((Multimap<String, AttributeModifier>)attributes, stack);
            player.func_110140_aT().func_111147_b((Multimap)attributes);
        }
    }

    @Override
    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
        if (!player.field_70170_p.field_72995_K) {
            HashMultimap attributes = HashMultimap.create();
            this.fillModifiers((Multimap<String, AttributeModifier>)attributes, stack);
            player.func_110140_aT().func_111148_a((Multimap)attributes);
        }
    }

    private void fillModifiers(Multimap<String, AttributeModifier> attributes, ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        attributes.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(ItemOdinRing.getBaubleUUID(stack), "Odin Ring", 20.0, 0).func_111168_a(false));
    }

    @Override
    public ResourceLocation getAdvancement() {
        return new ResourceLocation("botania", "challenge/odin_ring");
    }
}

