/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.patch.client;

import com.therandomlabs.randompatches.config.RPConfig;
import com.therandomlabs.randompatches.core.Patch;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.randomlib.TRLUtils;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class EntityRendererPatch
extends Patch {
    public static final String SET_RENDER_VIEW_ENTITY = EntityRendererPatch.getName("setRenderViewEntity", "func_175607_a");
    public static final String ORIENT_CAMERA = EntityRendererPatch.getName("orientCamera", "func_78467_g");
    public static final String EYE_HEIGHT_HANDLER = EntityRendererPatch.getName(EntityRendererPatch.class) + "$EyeHeightHandler";

    @Override
    public boolean apply(ClassNode node) {
        node.fields.add(new FieldNode(1, "eyeHeightHandler", "L" + EYE_HEIGHT_HANDLER + ";", null, null));
        EntityRendererPatch.patchUpdateRenderer(EntityRendererPatch.findInstructions(node, "updateRenderer", "func_78464_a"));
        EntityRendererPatch.patchSetupCameraTransform(EntityRendererPatch.findInstructions(node, "setupCameraTransform", "func_78479_a"));
        return true;
    }

    private static void patchUpdateRenderer(InsnList instructions) {
        AbstractInsnNode label = null;
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractInsnNode instruction = instructions.get(i);
            if (instruction.getOpcode() != 182) continue;
            MethodInsnNode method = (MethodInsnNode)instruction;
            if (!SET_RENDER_VIEW_ENTITY.equals(method.name)) continue;
            label = method.getNext();
            break;
        }
        InsnList newInstructions = new InsnList();
        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/renderer/EntityRenderer", "eyeHeightHandler", "L" + EYE_HEIGHT_HANDLER + ";"));
        newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, EYE_HEIGHT_HANDLER, "updateRenderer", "(Lnet/minecraft/client/renderer/EntityRenderer;L" + EYE_HEIGHT_HANDLER + ";)V", false));
        instructions.insert(label, newInstructions);
    }

    private static void patchSetupCameraTransform(InsnList instructions) {
        AbstractInsnNode orientCamera = null;
        for (int i = instructions.size() - 1; i >= 0; --i) {
            orientCamera = instructions.get(i);
            if (orientCamera.getOpcode() == 183 || orientCamera.getOpcode() == 182) {
                MethodInsnNode method = (MethodInsnNode)orientCamera;
                if (ORIENT_CAMERA.equals(method.name)) break;
            }
            orientCamera = null;
        }
        InsnList newInstructions = new InsnList();
        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstructions.add((AbstractInsnNode)new VarInsnNode(23, 1));
        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/renderer/EntityRenderer", "eyeHeightHandler", "L" + EYE_HEIGHT_HANDLER + ";"));
        newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, EYE_HEIGHT_HANDLER, "orientCamera", "(FLnet/minecraft/client/renderer/EntityRenderer;L" + EYE_HEIGHT_HANDLER + ";)V", false));
        instructions.insert(orientCamera, newInstructions);
    }

    public static final class EyeHeightHandler {
        private static final Minecraft mc = Minecraft.func_71410_x();
        private static final Field EYE_HEIGHT_HANDLER = TRLUtils.findField(EntityRenderer.class, "eyeHeightHandler");
        private float lastEyeHeight;
        private float eyeHeight;

        public static void updateRenderer(EntityRenderer renderer, EyeHeightHandler handler) {
            handler = EyeHeightHandler.get(renderer, handler);
            handler.lastEyeHeight = handler.eyeHeight;
            handler.eyeHeight += (mc.func_175606_aa().func_70047_e() - handler.eyeHeight) * 0.5f;
        }

        public static float getEyeHeight(Entity entity, float partialTicks, EntityRenderer renderer, EyeHeightHandler handler) {
            handler = EyeHeightHandler.get(renderer, handler);
            return handler.lastEyeHeight + (handler.eyeHeight - handler.lastEyeHeight) * partialTicks;
        }

        public static void orientCamera(float partialTicks, EntityRenderer renderer, EyeHeightHandler handler) {
            if (!RPConfig.Client.smoothEyeLevelChanges) {
                return;
            }
            Entity entity = mc.func_175606_aa();
            GlStateManager.func_179109_b((float)0.0f, (float)(entity.func_70047_e() - EyeHeightHandler.getEyeHeight(entity, partialTicks, renderer, handler)), (float)0.0f);
        }

        public static EyeHeightHandler get(EntityRenderer renderer, EyeHeightHandler handler) {
            if (handler == null) {
                handler = new EyeHeightHandler();
                try {
                    EYE_HEIGHT_HANDLER.set(renderer, handler);
                }
                catch (IllegalAccessException ex) {
                    TRLUtils.crashReport("Failed to set EntityRenderer#eyeHeightHandler", ex);
                }
            }
            return handler;
        }
    }
}

