/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.utils;

import erogenousbeef.bigreactors.common.multiblock.IPowerProvider;
import erogenousbeef.bigreactors.common.multiblock.PowerSystem;
import erogenousbeef.bigreactors.init.BrItems;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import it.zerono.mods.zerocore.util.ItemHelper;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class StaticUtils {

    public static class PowerGenerators {
        public static long distributePower(long energyAmount, @Nonnull Set<? extends IPowerProvider> providers) {
            block1: {
                if (energyAmount <= 0L || providers.size() <= 0) break block1;
                long energyPerProvider = energyAmount / (long)providers.size();
                for (IPowerProvider iPowerProvider : providers) {
                    if (iPowerProvider.isProviderConnected() && (energyAmount -= energyPerProvider - iPowerProvider.onProvidePower(energyPerProvider)) <= 0L) break;
                }
            }
            return energyAmount;
        }
    }

    public static class Strings {
        public static String[] sizePrefixes = new String[]{"", "Ki", "Me", "Gi", "Te", "Pe", "Ex", "Ze", "Yo", "Ho"};

        public static String formatEnergy(float number, PowerSystem powerSystem) {
            String prefix = "";
            if (number < 0.0f) {
                prefix = "-";
                number *= -1.0f;
            }
            if (number <= 1.0E-5f) {
                return "0.00 " + powerSystem.unitOfMeasure;
            }
            int power = (int)Math.floor(Math.log10(number));
            int decimalPoints = 2 - power % 3;
            int letterIdx = Math.max(0, Math.min(sizePrefixes.length, power / 3));
            double divisor = Math.pow(1000.0, letterIdx);
            if (divisor > 0.0) {
                return String.format("%s%." + Integer.toString(decimalPoints) + "f %s%s", prefix, (double)number / divisor, sizePrefixes[letterIdx], powerSystem.unitOfMeasure);
            }
            return String.format("%s%." + Integer.toString(decimalPoints) + "f %s", prefix, Float.valueOf(number), powerSystem.unitOfMeasure);
        }

        public static String formatMillibuckets(float number) {
            String prefix = "";
            if (number < 0.0f) {
                prefix = "-";
                number *= -1.0f;
            }
            if (number <= 1.0E-5f) {
                return "0.000 mB";
            }
            int power = (int)Math.floor(Math.log10(number));
            if (power < 1) {
                return String.format("%.3f mB", Float.valueOf(number));
            }
            if (power < 2) {
                return String.format("%.2f mB", Float.valueOf(number));
            }
            if (power < 3) {
                return String.format("%.1f mB", Float.valueOf(number));
            }
            if (power < 4) {
                return String.format("%.0f mB", Float.valueOf(number));
            }
            number /= 1000.0f;
            if (power < 5) {
                return String.format("%.2f B", Float.valueOf(number));
            }
            if (power < 6) {
                return String.format("%.1f B", Float.valueOf(number));
            }
            return String.format("%.0f B", Float.valueOf(number));
        }
    }

    public static class ExtraMath {
        public static float Lerp(float from, float to, float modifier) {
            modifier = Math.min(1.0f, Math.max(0.0f, modifier));
            return from + modifier * (to - from);
        }

        public static int Volume(BlockPos minimum, BlockPos maximum) {
            if (minimum == null || maximum == null) {
                return 0;
            }
            int xsize = Math.abs(maximum.func_177958_n() - minimum.func_177958_n()) + 1;
            int ysize = Math.abs(maximum.func_177956_o() - minimum.func_177956_o()) + 1;
            int zsize = Math.abs(maximum.func_177952_p() - minimum.func_177952_p()) + 1;
            return xsize * ysize * zsize;
        }
    }

    public static class Inventory {
        private static final EnumFacing[] chestDirections = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST};

        public static void dropItems(ItemStackHandler handler, World world, BlockPos position) {
            if (null == handler) {
                return;
            }
            double x = position.func_177958_n();
            double y = position.func_177956_o();
            double z = position.func_177952_p();
            int slotsCount = handler.getSlots();
            for (int slot = 0; slot < slotsCount; ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                if (!ItemHelper.stackIsValid((ItemStack)stack)) continue;
                handler.setStackInSlot(slot, ItemHelper.stackEmpty());
                WorldHelper.spawnItemStack((ItemStack)stack, (World)world, (double)x, (double)y, (double)z, (boolean)false);
            }
        }

        public static ItemStack consumeItem(ItemStack stack) {
            return Inventory.consumeItem(stack, 1);
        }

        public static ItemStack consumeItem(ItemStack stack, int amount) {
            if (ItemHelper.stackIsEmpty((ItemStack)stack)) {
                return ItemHelper.stackEmpty();
            }
            if (ItemHelper.stackGetSize((ItemStack)stack) <= amount) {
                if (stack.func_77973_b().hasContainerItem(stack)) {
                    return stack.func_77973_b().getContainerItem(stack);
                }
                return null;
            }
            stack.func_77979_a(amount);
            return stack;
        }

        public static boolean isPlayerHoldingWrench(ItemStack heldItemStack) {
            if (ItemHelper.stackIsEmpty((ItemStack)heldItemStack)) {
                return false;
            }
            Item heldItem = heldItemStack.func_77973_b();
            return null != heldItem && heldItem == BrItems.wrench;
        }

        public static boolean areStacksEqual(ItemStack s1, ItemStack s2) {
            return Inventory.areStacksEqual(s1, s2, true);
        }

        public static boolean areStacksEqual(ItemStack s1, ItemStack s2, boolean nbtSensitive) {
            if (ItemHelper.stackIsEmpty((ItemStack)s1) || ItemHelper.stackIsEmpty((ItemStack)s2)) {
                return false;
            }
            if (!s1.func_77969_a(s2)) {
                return false;
            }
            if (nbtSensitive) {
                if (s1.func_77978_p() == null && s2.func_77978_p() == null) {
                    return true;
                }
                if (s1.func_77978_p() == null || s2.func_77978_p() == null) {
                    return false;
                }
                return s1.func_77978_p().equals((Object)s2.func_77978_p());
            }
            return true;
        }

        public static IInventory checkForDoubleChest(World worldObj, IInventory te, int x, int y, int z) {
            BlockPos originalPosition = new BlockPos(x, y, z);
            for (EnumFacing dir : chestDirections) {
                TileEntity otherTe;
                BlockPos position = originalPosition.func_177972_a(dir);
                IBlockState state = worldObj.func_180495_p(position);
                if (state.func_177230_c() != Blocks.field_150486_ae || !((otherTe = worldObj.func_175625_s(position)) instanceof IInventory)) continue;
                return te;
            }
            return te;
        }
    }
}

