/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.entitys;

import io.netty.buffer.ByteBuf;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import lumien.randomthings.client.ModSounds;
import lumien.randomthings.item.ItemTimeInABottle;
import lumien.randomthings.item.ModItems;
import lumien.randomthings.network.MessageUtil;
import lumien.randomthings.network.messages.MessageEclipsedClock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityEclipsedClock
extends EntityHanging
implements IEntityAdditionalSpawnData {
    ItemStack clock;
    private static DataParameter<Integer> targetTime = EntityDataManager.func_187226_a(EntityEclipsedClock.class, (DataSerializer)DataSerializers.field_187192_b);
    private int timeDisplayCounter;
    private int animationCounter;
    private int cooldownCounter;

    public EntityEclipsedClock(World worldIn) {
        super(worldIn);
    }

    public EntityEclipsedClock(World worldIn, BlockPos hangingPositionIn, EnumFacing facing) {
        super(worldIn, hangingPositionIn);
        this.func_174859_a(facing);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(targetTime, (Object)0);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("targetTime", this.getTargetTime());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setTargetTime(compound.func_74762_e("targetTime"));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.timeDisplayCounter > 0) {
                --this.timeDisplayCounter;
            }
            if (this.animationCounter > 0) {
                --this.animationCounter;
            }
        } else if (this.cooldownCounter > 0) {
            --this.cooldownCounter;
        }
    }

    public void triggerAnimation() {
        if (this.animationCounter == 0) {
            this.animationCounter = 100;
        }
    }

    public boolean shouldDisplayTime() {
        return this.timeDisplayCounter > 0;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        ItemStack bottle = player.func_184586_b(hand);
        if (bottle.func_77973_b() instanceof ItemTimeInABottle) {
            if (!this.field_70170_p.field_72995_K && this.cooldownCounter == 0) {
                int timeStored = ItemTimeInABottle.getStoredTime(bottle);
                int dif = (this.getTargetTime() - (int)this.field_70170_p.func_72820_D()) % 24000;
                if (dif < 0) {
                    dif += 24000;
                }
                if (timeStored >= dif || player.field_71075_bZ.field_75098_d) {
                    this.field_70170_p.func_72877_b(this.field_70170_p.func_72820_D() + (long)dif);
                    if (!player.field_71075_bZ.field_75098_d) {
                        ItemTimeInABottle.setStoredTime(bottle, timeStored - dif);
                    }
                    this.cooldownCounter = 110;
                    MessageEclipsedClock msg = new MessageEclipsedClock(this.func_145782_y());
                    MessageUtil.sendToAllWatchingPos(this.field_70170_p, this.func_180425_c(), msg);
                    this.field_70170_p.func_184133_a(null, this.func_180425_c(), ModSounds.TIME, SoundCategory.BLOCKS, 0.3f, 1.2f);
                }
            }
        } else if (!this.field_70170_p.field_72995_K) {
            int targetTime = this.getTargetTime();
            targetTime = player.func_70093_af() ? (targetTime -= 600) : (targetTime += 600);
            this.setTargetTime(targetTime %= 24000);
        } else {
            this.timeDisplayCounter = 60;
        }
        return true;
    }

    public int getTargetTime() {
        return (Integer)this.field_70180_af.func_187225_a(targetTime);
    }

    public void setTargetTime(int newTime) {
        this.field_70180_af.func_187227_b(targetTime, (Object)newTime);
    }

    public boolean func_70067_L() {
        return true;
    }

    public String getStringTargetTime() {
        String myTime = "06:00";
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        try {
            Date d = df.parse(myTime);
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);
            cal.add(12, (int)(0.06 * (double)this.getTargetTime()));
            return df.format(cal.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "XX:XX";
        }
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    public int func_82329_d() {
        return 12;
    }

    public int func_82330_g() {
        return 12;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = 16.0;
        return distance < (d0 = d0 * 64.0 * EntityEclipsedClock.func_184183_bd()) * d0;
    }

    public void func_110128_b(Entity brokenEntity) {
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            this.func_184185_a(SoundEvents.field_187691_dJ, 1.0f, 1.0f);
            if (brokenEntity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)brokenEntity;
                if (entityplayer.field_71075_bZ.field_75098_d) {
                    return;
                }
            }
            this.func_70099_a(new ItemStack((Item)ModItems.eclipsedClock), 0.0f);
        }
    }

    public void func_184523_o() {
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeLong(this.func_174857_n().func_177986_g());
        buffer.writeShort(this.field_174860_b.ordinal());
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.field_174861_a = BlockPos.func_177969_a((long)additionalData.readLong());
        this.field_174860_b = EnumFacing.field_82609_l[additionalData.readShort()];
        this.func_174859_a(this.field_174860_b);
    }

    public int getAnimationCounter() {
        return this.animationCounter;
    }
}

