/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.gui.component;

import com.buuz135.industrial.api.conveyor.gui.PositionedGuiComponent;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.conveyor.GuiConveyor;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;

public abstract class TexturedStateButtonGuiComponent
extends PositionedGuiComponent {
    private final int id;
    private StateButtonInfo[] buttonInfos;

    public TexturedStateButtonGuiComponent(int id, int x, int y, int xSize, int ySize, StateButtonInfo ... buttonInfos) {
        super(x, y, xSize, ySize);
        this.id = id;
        this.buttonInfos = new StateButtonInfo[0];
        if (buttonInfos != null) {
            this.buttonInfos = buttonInfos;
        }
    }

    @Override
    public void handleClick(GuiConveyor conveyor, int guiX, int guiY, int mouseX, int mouseY) {
        conveyor.sendMessage(this.id, new NBTTagCompound());
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    @Override
    public void drawGuiBackgroundLayer(int guiX, int guiY, int mouseX, int mouseY) {
        StateButtonInfo buttonInfo = this.getStateInfo();
        if (buttonInfo != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(buttonInfo.getTexture());
            Minecraft.func_71410_x().field_71462_r.func_73729_b(guiX + this.getXPos(), guiY + this.getYPos(), buttonInfo.getTextureX(), buttonInfo.getTextureY(), this.getXSize(), this.getYSize());
        }
    }

    @Override
    public void drawGuiForegroundLayer(int guiX, int guiY, int mouseX, int mouseY) {
        StateButtonInfo buttonInfo = this.getStateInfo();
        if (buttonInfo != null && this.isInside(mouseX, mouseY)) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GuiScreen cfr_ignored_0 = Minecraft.func_71410_x().field_71462_r;
            GuiScreen.func_73734_a((int)(this.getXPos() - guiX), (int)(this.getYPos() - guiY), (int)(this.getXPos() + this.getXSize() - guiX), (int)(this.getYPos() + this.getYSize() - guiY), (int)-2130706433);
            GlStateManager.func_179145_e();
            GlStateManager.func_179097_i();
        }
    }

    @Override
    @Nullable
    public List<String> getTooltip(int guiX, int guiY, int mouseX, int mouseY) {
        StateButtonInfo buttonInfo = this.getStateInfo();
        if (buttonInfo != null) {
            return Arrays.asList(buttonInfo.getTooltip());
        }
        return null;
    }

    public abstract int getState();

    private StateButtonInfo getStateInfo() {
        for (StateButtonInfo buttonInfo : this.buttonInfos) {
            if (buttonInfo.getState() != this.getState()) continue;
            return buttonInfo;
        }
        return null;
    }
}

