/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.moons.titan.dimension.sky;

import java.lang.reflect.Field;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;

public class WeatherProviderTitan
extends IRenderHandler {
    private final Random random = new Random();
    private final float[] rainXCoords = new float[1024];
    private final float[] rainYCoords = new float[1024];
    private static final ResourceLocation RAIN_TEXTURES = new ResourceLocation("galacticraftplanets", "textures/misc/rain_venus.png");

    public WeatherProviderTitan() {
        for (int i = 0; i < 32; ++i) {
            float f1 = i - 16;
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f2 = MathHelper.func_76129_c((float)(f * f + f1 * f1));
                this.rainXCoords[i << 5 | j] = -f1 / f2;
                this.rainYCoords[i << 5 | j] = f / f2;
            }
        }
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        float strength = world.func_72867_j(partialTicks);
        if (strength > 0.0f) {
            int rendererUpdateCount = 0;
            try {
                Field fieldRUC = mc.field_71460_t.getClass().getDeclaredField(GCCoreUtil.isDeobfuscated() ? "rendererUpdateCount" : "field_78529_t");
                fieldRUC.setAccessible(true);
                rendererUpdateCount = fieldRUC.getInt(mc.field_71460_t);
            }
            catch (Exception fieldRUC) {
                // empty catch block
            }
            mc.field_71460_t.func_180436_i();
            Entity entity = mc.func_175606_aa();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder worldrenderer = tessellator.func_178180_c();
            GlStateManager.func_179129_p();
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            double d0 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            double d1 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            double d2 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            int l = MathHelper.func_76128_c((double)d1);
            int r = 4;
            if (mc.field_71474_y.field_74347_j) {
                r = 8;
            }
            int drawFlag = -1;
            worldrenderer.func_178969_c(-d0, -d1, -d2);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            int px = MathHelper.func_76128_c((double)entity.field_70165_t);
            int py = MathHelper.func_76128_c((double)entity.field_70163_u);
            int pz = MathHelper.func_76128_c((double)entity.field_70161_v);
            for (int z = pz - r; z <= pz + r; ++z) {
                int indexZ = (z - pz + 16) * 32;
                for (int x = px - r; x <= px + r; ++x) {
                    mutablePos.func_181079_c(x, 0, z);
                    int yHeight = world.func_175725_q((BlockPos)mutablePos).func_177956_o() + 4 - (int)(4.8f * strength);
                    int y = py - r;
                    int ymax = py + r;
                    if (y < yHeight) {
                        y = yHeight;
                    }
                    if (ymax < yHeight) {
                        ymax = yHeight;
                    }
                    int yBase = yHeight;
                    if (yHeight < l) {
                        yBase = l;
                    }
                    if (y == ymax) continue;
                    this.random.setSeed(x * x * 3121 + x * 45238971 ^ z * z * 418711 + z * 13761);
                    if (drawFlag != 0) {
                        if (drawFlag >= 0) {
                            tessellator.func_78381_a();
                        }
                        drawFlag = 0;
                        mc.func_110434_K().func_110577_a(RAIN_TEXTURES);
                        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    int index = indexZ + x - px + 16;
                    double dx = (double)this.rainXCoords[index] * 0.5;
                    double dz = (double)this.rainYCoords[index] * 0.5;
                    double dy = -((double)(rendererUpdateCount + x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0x1F) + (double)partialTicks) / 80.0 * (6.0 + this.random.nextDouble());
                    double yo = this.random.nextDouble() / 1.8;
                    double xx = (double)x + 0.5 - entity.field_70165_t;
                    double zz = (double)z + 0.5 - entity.field_70161_v;
                    float rr = MathHelper.func_76133_a((double)(xx * xx + zz * zz)) / (float)r;
                    float alpha = ((1.0f - rr * rr) * 0.5f + 0.5f) * strength / 0.6f;
                    mutablePos.func_181079_c(x, yBase, z);
                    int light = world.func_175626_b((BlockPos)mutablePos, 0);
                    int lx = light >> 16 & 0xFFFF;
                    int ly = light & 0xFFFF;
                    double xc = (double)x + 0.5;
                    double zc = (double)z + 0.5;
                    worldrenderer.func_181662_b(xc - dx, (double)ymax - yo, zc - dz).func_187315_a(0.0, (double)y * 0.25 + dy).func_181666_a(0.8f, 0.4f, 0.6f, alpha).func_187314_a(lx, ly).func_181675_d();
                    worldrenderer.func_181662_b(xc + dx, (double)ymax - yo, zc + dz).func_187315_a(1.0, (double)y * 0.25 + dy).func_181666_a(0.8f, 0.4f, 0.6f, alpha).func_187314_a(lx, ly).func_181675_d();
                    worldrenderer.func_181662_b(xc + dx, (double)y - yo, zc + dz).func_187315_a(1.0, (double)ymax * 0.25 + dy).func_181666_a(0.8f, 0.4f, 0.6f, alpha).func_187314_a(lx, ly).func_181675_d();
                    worldrenderer.func_181662_b(xc - dx, (double)y - yo, zc - dz).func_187315_a(0.0, (double)ymax * 0.25 + dy).func_181666_a(0.8f, 0.4f, 0.6f, alpha).func_187314_a(lx, ly).func_181675_d();
                }
            }
            if (drawFlag >= 0) {
                tessellator.func_78381_a();
            }
            worldrenderer.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            mc.field_71460_t.func_175072_h();
        }
    }
}

