/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.tileentity;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.core.util.Timer;
import net.malisis.core.util.syncer.Sync;
import net.malisis.core.util.syncer.Syncable;
import net.malisis.core.util.syncer.Syncer;
import net.malisis.doors.DoorDescriptor;
import net.malisis.doors.DoorState;
import net.malisis.doors.block.Door;
import net.malisis.doors.movement.IDoorMovement;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

@Syncable(value="TileEntity")
public class DoorTileEntity
extends TileEntity
implements ITickable {
    private static final AxisAlignedBB BASE = new AxisAlignedBB(0.0, 0.0, -1.0, 1.0, 2.0, 3.0);
    private static final Map<EnumFacing, AxisAlignedBB> DETECT = ImmutableMap.of((Object)EnumFacing.SOUTH, (Object)AABBUtils.rotate((AxisAlignedBB)BASE, (EnumFacing)EnumFacing.NORTH), (Object)EnumFacing.EAST, (Object)AABBUtils.rotate((AxisAlignedBB)BASE, (EnumFacing)EnumFacing.WEST), (Object)EnumFacing.NORTH, (Object)AABBUtils.rotate((AxisAlignedBB)BASE, (EnumFacing)EnumFacing.SOUTH), (Object)EnumFacing.WEST, (Object)AABBUtils.rotate((AxisAlignedBB)BASE, (EnumFacing)EnumFacing.EAST));
    protected DoorDescriptor descriptor;
    protected int lastMetadata = -1;
    protected Timer timer = new Timer(0L);
    protected DoorState state = DoorState.CLOSED;
    protected boolean moving;
    protected boolean centered = false;
    protected PropertyBool openProperty = BlockDoor.field_176519_b;
    protected boolean powered = false;

    public DoorDescriptor getDescriptor() {
        if (this.descriptor == null || this.descriptor.getMovement() == null) {
            if (this.func_145838_q() == null) {
                return new DoorDescriptor();
            }
            if (this.func_145838_q() instanceof Door) {
                this.descriptor = ((Door)this.func_145838_q()).getDescriptor();
            }
        }
        return this.descriptor != null ? this.descriptor : new DoorDescriptor();
    }

    public void setDescriptor(DoorDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public Timer getTimer() {
        return this.timer;
    }

    @Sync(value="state")
    public DoorState getState() {
        return this.state;
    }

    public void setState(DoorState state) {
        this.state = state;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public void setMoving(boolean moving) {
        this.moving = moving;
    }

    public IDoorMovement getMovement() {
        return this.getDescriptor() != null ? this.getDescriptor().getMovement() : null;
    }

    public int getOpeningTime() {
        return this.getDescriptor() != null ? this.getDescriptor().getOpeningTime() : 6;
    }

    public IBlockState getBlockState() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() != this.func_145838_q() || this.func_145838_q() == null) {
            return null;
        }
        return state.func_185899_b((IBlockAccess)this.field_145850_b, this.field_174879_c);
    }

    public EnumFacing getDirection() {
        return BlockDoor.func_176517_h((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c);
    }

    public boolean isTopBlock(BlockPos pos) {
        return this.field_174879_c.func_177984_a().equals((Object)pos);
    }

    public boolean isOpened() {
        return this.isOpened(this.getBlockState());
    }

    public boolean isOpened(IBlockState state) {
        return state != null && (Boolean)state.func_177229_b((IProperty)this.openProperty) != false;
    }

    public boolean isHingeLeft() {
        IBlockState state = this.getBlockState();
        if (state == null) {
            return false;
        }
        return state.func_177230_c() instanceof Door && state.func_177229_b((IProperty)BlockDoor.field_176521_M) == BlockDoor.EnumHingePosition.LEFT;
    }

    public void updatePowered() {
        this.setPowered(this.func_145831_w().func_175687_A(this.field_174879_c) + this.func_145831_w().func_175687_A(this.field_174879_c.func_177984_a()) != 0);
        Syncer.sync((Object)((Object)this), (String[])new String[]{"power"});
    }

    @Sync(value="power")
    public boolean isPowered() {
        return this.powered;
    }

    @Sync(value="power")
    public void setPowered(boolean powered) {
        boolean wasPowered = this.powered;
        this.powered = powered;
        if (wasPowered && !powered && !this.isDoubleDoorPowered()) {
            this.close();
        } else if (!wasPowered && powered) {
            this.open();
        }
    }

    public boolean isDoubleDoorPowered() {
        DoorTileEntity te = this.getDoubleDoor();
        return te != null && te.isPowered();
    }

    public boolean isCentered() {
        return this.centered;
    }

    public boolean shouldCenter() {
        if (this.getMovement() == null) {
            return false;
        }
        EnumFacing offset = this.getDirection().func_176746_e();
        Block b1 = this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(offset, 1)).func_177230_c();
        Block b2 = this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(offset, -1)).func_177230_c();
        return ArrayUtils.contains((Object[])Door.centerBlocks, (Object)b1) || ArrayUtils.contains((Object[])Door.centerBlocks, (Object)b2);
    }

    public boolean setCentered(boolean centered) {
        this.centered = centered;
        TileEntityUtils.notifyUpdate((TileEntity)this);
        return centered;
    }

    public ItemStack getItemStack() {
        ItemStack itemStack = new ItemStack(this.getDescriptor().getItem());
        if (this.getDescriptor() != ((Door)this.func_145838_q()).getDescriptor()) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.getDescriptor().writeNBT(nbt);
            itemStack.func_77982_d(nbt);
        }
        return itemStack;
    }

    public void onBlockPlaced(Door door, ItemStack itemStack) {
        DoorDescriptor desc = itemStack.func_77978_p() != null ? new DoorDescriptor(itemStack.func_77978_p()) : door.getDescriptor();
        this.setDescriptor(desc);
    }

    public void openOrCloseDoor() {
        if (this.state == DoorState.OPENED) {
            this.close();
        } else {
            this.open();
        }
    }

    public boolean open() {
        if (this.state == DoorState.OPENING || this.state == DoorState.OPENED) {
            return false;
        }
        this.setDoorState(DoorState.OPENING);
        DoorTileEntity te = this.getDoubleDoor();
        if (te != null) {
            te.setDoorState(DoorState.OPENING);
        }
        return true;
    }

    public boolean close() {
        if (this.state == DoorState.CLOSING || this.state == DoorState.CLOSED) {
            return false;
        }
        this.setDoorState(DoorState.CLOSING);
        DoorTileEntity te = this.getDoubleDoor();
        if (te != null) {
            te.setDoorState(DoorState.CLOSING);
        }
        return true;
    }

    @Sync(value="state")
    public void setDoorState(DoorState newState) {
        if (this.state == newState) {
            return;
        }
        this.state = newState;
        if (this.func_145831_w() == null) {
            return;
        }
        if (this.state == DoorState.CLOSING || this.state == DoorState.OPENING) {
            if (this.moving) {
                long s = this.timer.elapsedTime() - Timer.tickToTime((long)this.getOpeningTime());
                this.timer.setRelativeStart(s);
            } else {
                this.timer.start();
                this.moving = true;
            }
            if (!this.field_145850_b.field_72995_K) {
                Syncer.sync((Object)((Object)this), (String[])new String[]{"state"});
            }
        } else {
            IBlockState state = this.getBlockState();
            if (state != null) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)this.openProperty, (Comparable)Boolean.valueOf(newState == DoorState.OPENED)));
            }
            this.moving = false;
        }
        this.playSound();
    }

    public void playSound() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        SoundEvent sound = null;
        if (this.getDescriptor().getSound() != null) {
            sound = this.getDescriptor().getSound().getSound(this.state);
        }
        if (sound != null) {
            this.func_145831_w().func_184133_a(null, this.field_174879_c, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public DoorTileEntity getDoubleDoor() {
        DoorTileEntity te;
        if (!this.getDescriptor().isDoubleDoor()) {
            return null;
        }
        EnumFacing offset = this.getDirection().func_176735_f();
        if (this.isHingeLeft()) {
            offset = offset.func_176734_d();
        }
        if (this.isMatchingDoubleDoor(te = Door.getDoor((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177972_a(offset)))) {
            return te;
        }
        return null;
    }

    public boolean isMatchingDoubleDoor(DoorTileEntity te) {
        if (te == null) {
            return false;
        }
        if (this.func_145838_q() != te.func_145838_q()) {
            return false;
        }
        if (this.getDirection() != te.getDirection()) {
            return false;
        }
        if (this.getMovement() != te.getMovement()) {
            return false;
        }
        if (this.isOpened() != te.isOpened()) {
            return false;
        }
        return this.isHingeLeft() != te.isHingeLeft();
    }

    protected boolean hasPlayer() {
        List list = this.field_145850_b.func_72872_a(EntityPlayer.class, DETECT.get(this.getDirection()).func_186670_a(this.func_174877_v()));
        return list != null && !list.isEmpty();
    }

    protected boolean doubleDoorHasPlayer() {
        DoorTileEntity te = this.getDoubleDoor();
        return te != null && te.hasPlayer();
    }

    public void func_73660_a() {
        if (this.moving && this.timer.elapsedTick() > (long)this.getOpeningTime()) {
            this.setDoorState(this.getState() == DoorState.CLOSING ? DoorState.CLOSED : DoorState.OPENED);
        }
        if (this.getDescriptor().hasProximityDetection() && (this.hasPlayer() || this.doubleDoorHasPlayer())) {
            this.open();
            return;
        }
        if (this.getDescriptor().getAutoCloseTime() > 0 && this.timer.elapsedTick() > (long)this.getDescriptor().getAutoCloseTime()) {
            this.close();
            return;
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.descriptor = new DoorDescriptor(nbt);
        this.setDoorState(DoorState.values()[nbt.func_74762_e("state")]);
        this.setCentered(nbt.func_74767_n("centered"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.descriptor != null) {
            this.descriptor.writeNBT(nbt);
        }
        nbt.func_74768_a("state", this.state.ordinal());
        nbt.func_74757_a("centered", this.centered);
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 2, 1));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }
}

