/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.api.gui;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.opengl.GL11;

public class StringListBox
extends GuiButton {
    private static final int BASIC_X_OFFSET = 2;
    private static final int BASIC_Y_OFFSET = 2;
    private static final int SCROLL_WIDTH = 8;
    private static final int SCROLL_BUTTON_HEIGHT = 8;
    public int lineHeight;
    public boolean dragging;
    public int selectedItem;
    private int fontColor = -12566464;
    private int selectedColor = -12566464;
    private int selectedFontColor = -6250336;
    private int scrollTop;
    private List<String> items;
    private int sliderHeight;
    private int sliderY;
    private int dragDelta;

    public StringListBox(int id, int left, int top, int width, int height, List<String> items) {
        super(id, left, top, width, height, "");
        this.items = items;
        this.scrollTop = 0;
        this.lineHeight = 0;
        this.sliderHeight = 0;
        this.dragging = false;
        this.dragDelta = 0;
        this.selectedItem = 0;
    }

    public void updateList(List<String> items) {
        this.items = items;
    }

    private void scrollTo(int pos) {
        int max;
        this.scrollTop = pos;
        if (this.scrollTop < 0) {
            this.scrollTop = 0;
        }
        if ((max = this.lineHeight * this.items.size() + 2 - this.field_146121_g) < 0) {
            max = 0;
        }
        if (this.scrollTop > max) {
            this.scrollTop = max;
        }
    }

    public void scrollUp() {
        this.scrollTop -= 8;
        if (this.scrollTop < 0) {
            this.scrollTop = 0;
        }
    }

    public void scrollDown() {
        this.scrollTop += 8;
        int max = this.lineHeight * this.items.size() + 2 - this.field_146121_g;
        if (max < 0) {
            max = 0;
        }
        if (this.scrollTop > max) {
            this.scrollTop = max;
        }
    }

    public void func_191745_a(Minecraft minecraft, int cursorX, int cursorY, float i) {
        if (this.dragging) {
            int pos = (cursorY - this.field_146129_i - 8 - this.dragDelta) * (this.lineHeight * this.items.size() + 2 - this.field_146121_g) / Math.max(this.field_146121_g - 16 - this.sliderHeight, 1);
            this.scrollTo(pos);
        }
        FontRenderer fontRenderer = minecraft.field_71466_p;
        if (this.lineHeight == 0) {
            float scale;
            int rowsPerHeight;
            this.lineHeight = fontRenderer.field_78288_b + 2;
            if (this.scrollTop == 0 && this.selectedItem >= (rowsPerHeight = this.field_146121_g / this.lineHeight)) {
                this.scrollTop = (this.selectedItem + 1) * this.lineHeight + 2 - this.field_146121_g;
            }
            if ((scale = (float)this.field_146121_g / ((float)this.lineHeight * (float)this.items.size() + 2.0f)) > 1.0f) {
                scale = 1.0f;
            }
            this.sliderHeight = Math.round(scale * (float)(this.field_146121_g - 16));
            if (this.sliderHeight < 4) {
                this.sliderHeight = 4;
            }
        }
        int sliderX = this.field_146128_h + this.field_146120_f - 8 + 1;
        this.sliderY = this.field_146129_i + 8 + (this.field_146121_g - 16 - this.sliderHeight) * this.scrollTop / (this.lineHeight * this.items.size() + 2 - this.field_146121_g);
        int rowTop = 2;
        GL11.glPushMatrix();
        StringListBox.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g), (int)-15724528);
        StringListBox.func_73734_a((int)(this.field_146128_h + this.field_146120_f - 8), (int)this.field_146129_i, (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + 8), (int)-8355712);
        StringListBox.func_73734_a((int)(this.field_146128_h + this.field_146120_f - 8), (int)(this.field_146129_i + this.field_146121_g - 8), (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g), (int)-8355712);
        StringListBox.func_73734_a((int)(sliderX - 1), (int)this.sliderY, (int)(sliderX + 8 - 1), (int)(this.sliderY + this.sliderHeight), (int)-14342875);
        GL11.glEnable((int)3089);
        Minecraft mc = FMLClientHandler.instance().getClient();
        ScaledResolution scaler = new ScaledResolution(mc);
        GL11.glScissor((int)(this.field_146128_h * scaler.func_78325_e()), (int)(mc.field_71440_d - (this.field_146129_i + this.field_146121_g) * scaler.func_78325_e()), (int)((this.field_146120_f - 8) * scaler.func_78325_e()), (int)(this.field_146121_g * scaler.func_78325_e()));
        if (this.items.size() > 0) {
            this.selectedItem = Math.max(0, this.selectedItem);
            for (String row : this.items) {
                if (row.equals(this.items.get(this.selectedItem))) {
                    StringListBox.func_73734_a((int)this.field_146128_h, (int)(this.field_146129_i + rowTop - this.scrollTop - 1), (int)(this.field_146128_h + this.field_146120_f - 8), (int)(this.field_146129_i + rowTop - this.scrollTop + this.lineHeight - 1), (int)this.selectedColor);
                    fontRenderer.func_78276_b(row, this.field_146128_h + 2, this.field_146129_i + rowTop - this.scrollTop, this.selectedFontColor);
                } else {
                    fontRenderer.func_78276_b(row, this.field_146128_h + 2, this.field_146129_i + rowTop - this.scrollTop, this.fontColor);
                }
                rowTop += this.lineHeight;
            }
        }
        GL11.glDisable((int)3089);
        GL11.glPopMatrix();
    }

    private void setCurrent(int targetY) {
        if (this.lineHeight == 0) {
            return;
        }
        int itemIndex = (targetY - 2 - this.field_146129_i + this.scrollTop) / this.lineHeight;
        if (itemIndex >= this.items.size()) {
            itemIndex = this.items.size() - 1;
        }
        this.selectedItem = itemIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ParametersAreNonnullByDefault
    public boolean func_146116_c(Minecraft minecraft, int targetX, int targetY) {
        if (!super.func_146116_c(minecraft, targetX, targetY)) return false;
        if (targetX > this.field_146128_h + this.field_146120_f - 8) {
            if (targetY - this.field_146129_i < 8) {
                this.scrollUp();
                return false;
            } else if (this.field_146121_g + this.field_146129_i - targetY < 8) {
                this.scrollDown();
                return false;
            } else {
                if (targetY < this.sliderY || targetY > this.sliderY + this.sliderHeight) return false;
                this.dragging = true;
                this.dragDelta = targetY - this.sliderY;
            }
            return false;
        } else {
            this.setCurrent(targetY);
            return true;
        }
    }

    public void func_146118_a(int i, int j) {
        super.func_146118_a(i, j);
        this.dragging = false;
    }
}

