/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.api.permission;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import omtteam.omlib.OMLib;
import omtteam.omlib.api.permission.EnumAccessLevel;
import omtteam.omlib.api.permission.IGlobalTrustRegister;
import omtteam.omlib.api.permission.TrustedPlayer;
import omtteam.omlib.api.permission.TrustedPlayersManagerGlobal;
import omtteam.omlib.network.OMLibNetworkingHandler;
import omtteam.omlib.network.messages.MessageSetGlobalTrustList;
import omtteam.omlib.util.player.Player;

@Mod.EventBusSubscriber(modid="omlib")
public class GlobalTrustRegister
implements ICapabilityProvider,
IGlobalTrustRegister {
    @Nonnull
    public static final GlobalTrustRegister instance = new GlobalTrustRegister();
    @Nonnull
    private static final ResourceLocation CAP_KEY = new ResourceLocation("omlib", "owner_global_trust");
    @CapabilityInject(value=IGlobalTrustRegister.class)
    public static Capability<IGlobalTrustRegister> GLOBAL_TRUST_REGISTER = null;
    private HashMap<Player, TrustedPlayersManagerGlobal> globalTrustList = new HashMap();

    private GlobalTrustRegister() {
    }

    @SubscribeEvent
    public static void onWorldCaps(AttachCapabilitiesEvent<World> event) {
        if (GLOBAL_TRUST_REGISTER != null && !((World)event.getObject()).field_72995_K && ((World)event.getObject()).field_73011_w.getDimension() == 1) {
            event.addCapability(CAP_KEY, (ICapabilityProvider)instance);
        }
    }

    public static void preInit() {
        CapabilityManager.INSTANCE.register(IGlobalTrustRegister.class, (Capability.IStorage)new Capability.IStorage<IGlobalTrustRegister>(){

            public NBTBase writeNBT(Capability<IGlobalTrustRegister> capability, IGlobalTrustRegister instanceIn, EnumFacing side) {
                return instanceIn.serializeNBT();
            }

            public void readNBT(Capability<IGlobalTrustRegister> capability, IGlobalTrustRegister instanceIn, EnumFacing side, NBTBase nbt) {
                instanceIn.deserializeNBT(nbt);
            }
        }, () -> instance);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == GLOBAL_TRUST_REGISTER;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == GLOBAL_TRUST_REGISTER ? this : null);
    }

    public NBTBase serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (Map.Entry<Player, TrustedPlayersManagerGlobal> entry : this.globalTrustList.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            entry.getKey().writeToNBT(tag);
            entry.getValue().writeToNBT(tag);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("list", (NBTBase)list);
        return nbt;
    }

    public void deserializeNBT(NBTBase nbtIn) {
        if (nbtIn instanceof NBTTagCompound) {
            NBTTagCompound nbt = (NBTTagCompound)nbtIn;
            NBTTagList list = nbt.func_150295_c("list", (int)nbt.func_74732_a());
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                Player owner = Player.readFromNBT(tag);
                TrustedPlayersManagerGlobal tpm = new TrustedPlayersManagerGlobal(owner);
                tpm.readFromNBT(tag);
                this.globalTrustList.put(owner, tpm);
            }
        } else {
            OMLib.getLogger().debug("failed to deserialize NBT");
        }
    }

    public HashMap<Player, TrustedPlayersManagerGlobal> getGlobalTrustList() {
        return this.globalTrustList;
    }

    public void setGlobalTrustList(@Nullable HashMap<Player, TrustedPlayersManagerGlobal> ownerShareMap) {
        if (ownerShareMap != null) {
            this.globalTrustList = ownerShareMap;
        }
    }

    @Nullable
    public Map.Entry<Player, TrustedPlayersManagerGlobal> getEntryFromName(String name) {
        for (Map.Entry<Player, TrustedPlayersManagerGlobal> entry : this.globalTrustList.entrySet()) {
            if (!entry.getKey().getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    @Nullable
    private Map.Entry<Player, TrustedPlayersManagerGlobal> getEntry(Player player) {
        for (Map.Entry<Player, TrustedPlayersManagerGlobal> entry : this.globalTrustList.entrySet()) {
            if (!entry.getKey().equals(player)) continue;
            return entry;
        }
        return null;
    }

    public void addTrustedPlayer(Player owner, Player sharePlayer, EnumAccessLevel accessMode, @Nullable ICommandSender sender) {
        Map.Entry<Player, TrustedPlayersManagerGlobal> entry = this.getEntry(owner);
        if (owner.equals(sharePlayer)) {
            return;
        }
        if (entry == null) {
            TrustedPlayersManagerGlobal tpm = new TrustedPlayersManagerGlobal(owner);
            if (tpm.addTrustedPlayer(sharePlayer.getName())) {
                tpm.getTrustedPlayer(sharePlayer.getName()).setAccessLevel(accessMode);
                if (sender != null) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Added player " + sharePlayer.getName() + " to your global trust List!"));
                }
            } else if (sender != null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Could not add " + sharePlayer.getName() + " to your global trust List!"));
            }
            this.globalTrustList.put(owner, tpm);
        } else if (entry.getValue().addTrustedPlayer(sharePlayer.getName())) {
            entry.getValue().getTrustedPlayer(sharePlayer.getName()).setAccessLevel(accessMode);
            if (sender != null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Added player " + sharePlayer.getName() + " to your global trust List!"));
            }
        } else if (sender != null) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Could not add " + sharePlayer.getName() + " to your global trust List!"));
        }
        OMLibNetworkingHandler.sendMessageToAllPlayers(new MessageSetGlobalTrustList(this));
    }

    public void removeTrustedPlayer(Player owner, Player trustedPlayer, @Nullable ICommandSender sender) {
        Map.Entry<Player, TrustedPlayersManagerGlobal> entry = this.getEntry(owner);
        if (owner.equals(trustedPlayer)) {
            if (sender != null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("You cannot add/remove yourself to/from your Share List!"));
            }
            return;
        }
        if (entry != null) {
            boolean result = entry.getValue().removeTrustedPlayer(trustedPlayer.getName());
            if (sender != null) {
                if (result) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Removed player " + trustedPlayer.getName() + " from your Share List!"));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Could not remove player " + trustedPlayer.getName() + " from your Share List!"));
                }
            }
        } else if (sender != null) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Could not remove player " + trustedPlayer.getName() + " from your Share List!"));
        }
        OMLibNetworkingHandler.sendMessageToAllPlayers(new MessageSetGlobalTrustList(this));
    }

    public void printTrustedPlayers(Player owner, ICommandSender sender) {
        StringBuilder playerList = new StringBuilder();
        Map.Entry<Player, TrustedPlayersManagerGlobal> entry = this.getEntry(owner);
        if (entry != null) {
            TrustedPlayersManagerGlobal tpm = entry.getValue();
            for (TrustedPlayer trustedPlayer : tpm.getTrustedPlayers()) {
                playerList.append(trustedPlayer.getName()).append(" ");
            }
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("Players on your share list: " + playerList.toString()));
    }

    @Nullable
    public TrustedPlayer getTrustedPlayer(Player owner, Player toCheck) {
        Map.Entry<Player, TrustedPlayersManagerGlobal> entry = this.getEntry(owner);
        if (entry != null) {
            return entry.getValue().getTrustedPlayer(toCheck);
        }
        return null;
    }

    @Nullable
    public TrustedPlayer getTrustedPlayer(Player owner, String toCheck) {
        Map.Entry<Player, TrustedPlayersManagerGlobal> entry = this.getEntry(owner);
        if (entry != null) {
            return entry.getValue().getTrustedPlayer(toCheck);
        }
        return null;
    }

    @Nullable
    public TrustedPlayer getTrustedPlayer(Player owner, UUID uuid) {
        Map.Entry<Player, TrustedPlayersManagerGlobal> entry = this.getEntry(owner);
        if (entry != null) {
            return entry.getValue().getTrustedPlayer(uuid);
        }
        return null;
    }

    public boolean changePermission(Player owner, String player, EnumAccessLevel level) {
        Map.Entry<Player, TrustedPlayersManagerGlobal> entry = this.getEntry(owner);
        if (entry != null) {
            for (TrustedPlayer trustedPlayer : entry.getValue().getTrustedPlayers()) {
                if (!trustedPlayer.getName().equalsIgnoreCase(player)) continue;
                trustedPlayer.setAccessLevel(level);
                return true;
            }
        }
        return false;
    }
}

