/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.util.player;

import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.ParametersAreNullableByDefault;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.UsernameCache;
import omtteam.omlib.api.permission.EnumAccessLevel;
import omtteam.omlib.api.permission.EnumPlayerAccessType;
import omtteam.omlib.api.permission.IHasOwner;
import omtteam.omlib.api.permission.OwnerShareRegister;
import omtteam.omlib.api.permission.TrustedPlayer;
import omtteam.omlib.api.tile.IHasTrustManager;
import omtteam.omlib.handler.OMConfig;
import omtteam.omlib.tileentity.TileEntityOwnedBlock;
import omtteam.omlib.util.player.Player;

public class PlayerUtil {
    @Nullable
    public static IHasTrustManager getTrustMachine(IHasOwner tile) {
        if (tile instanceof IHasTrustManager) {
            return (IHasTrustManager)tile;
        }
        return null;
    }

    @Nullable
    public static TrustedPlayer getTrustedPlayer(EntityPlayer player, IHasOwner tile) {
        return PlayerUtil.getTrustedPlayer(new Player(player), tile);
    }

    @Nullable
    public static TrustedPlayer getTrustedPlayer(Player player, IHasOwner tile) {
        if (tile instanceof IHasTrustManager) {
            return ((IHasTrustManager)tile).getTrustManager().getTrustedPlayer(player);
        }
        return null;
    }

    @ParametersAreNullableByDefault
    public static boolean isPlayerOP(EntityPlayer player) {
        if (player != null) {
            return player.func_70003_b(4, "");
        }
        return false;
    }

    @ParametersAreNullableByDefault
    public static boolean isPlayerOP(Player player) {
        if (player != null) {
            EntityPlayer entityPlayer = player.getEntityPlayer();
            return PlayerUtil.isPlayerOP(entityPlayer);
        }
        return false;
    }

    @Nullable
    public static UUID getPlayerUUID(String username) {
        for (Map.Entry entry : UsernameCache.getMap().entrySet()) {
            if (!((String)entry.getValue()).equalsIgnoreCase(username)) continue;
            return (UUID)entry.getKey();
        }
        return null;
    }

    @Nullable
    @ParametersAreNullableByDefault
    public static UUID getPlayerUIDUnstable(String possibleUUID) {
        UUID uuid;
        if (possibleUUID == null || possibleUUID.isEmpty()) {
            return null;
        }
        try {
            uuid = UUID.fromString(possibleUUID);
        }
        catch (IllegalArgumentException e) {
            uuid = PlayerUtil.getPlayerUUID(possibleUUID);
        }
        return uuid;
    }

    @Nullable
    @ParametersAreNullableByDefault
    public static String getPlayerNameFromUUID(String possibleUUID) {
        if (possibleUUID == null || possibleUUID.isEmpty()) {
            return null;
        }
        return UsernameCache.getLastKnownUsername((UUID)UUID.fromString(possibleUUID));
    }

    @ParametersAreNonnullByDefault
    public static EnumPlayerAccessType getPlayerAccessType(EntityPlayer entityPlayer, TileEntityOwnedBlock ownedBlock) {
        Player player = new Player(entityPlayer);
        return PlayerUtil.getPlayerAccessType(player, (Object)ownedBlock);
    }

    @ParametersAreNonnullByDefault
    public static EnumPlayerAccessType getPlayerAccessType(Player player, Object block) {
        Player owner;
        IHasOwner ownedBlock = null;
        if (block instanceof IHasOwner) {
            ownedBlock = (IHasOwner)block;
        }
        if (ownedBlock != null && (player.equals(owner = ownedBlock.getOwner()) || OwnerShareRegister.instance.isPlayerSharedOwner(owner, player))) {
            return EnumPlayerAccessType.OWNER;
        }
        if (PlayerUtil.getTrustedPlayer(player, ownedBlock) != null) {
            return EnumPlayerAccessType.TRUSTED;
        }
        if (OMConfig.GENERAL.canOPAccessOwnedBlocks && PlayerUtil.isPlayerOP(player)) {
            return EnumPlayerAccessType.OP;
        }
        return EnumPlayerAccessType.NONE;
    }

    @ParametersAreNonnullByDefault
    public static boolean isPlayerTrusted(EntityPlayer entityPlayer, IHasOwner ownedBlock) {
        Player player = new Player(entityPlayer);
        return PlayerUtil.isPlayerTrusted(player, ownedBlock);
    }

    @ParametersAreNonnullByDefault
    public static boolean isPlayerTrusted(Player player, IHasOwner ownedBlock) {
        return PlayerUtil.getTrustedPlayer(player, ownedBlock) != null;
    }

    @ParametersAreNonnullByDefault
    public static boolean isPlayerOwner(EntityPlayer checkPlayer, IHasOwner ownedBlock) {
        Player player = new Player(checkPlayer);
        return PlayerUtil.isPlayerOwner(player, ownedBlock);
    }

    @ParametersAreNonnullByDefault
    public static boolean isPlayerOwner(Player player, IHasOwner ownedBlock) {
        return player.equals(ownedBlock.getOwner()) || OwnerShareRegister.instance.isPlayerSharedOwner(ownedBlock.getOwner(), player);
    }

    @ParametersAreNonnullByDefault
    public static boolean isPlayerAdmin(EntityPlayer checkPlayer, IHasOwner machine) {
        Player player = new Player(checkPlayer);
        return PlayerUtil.isPlayerAdmin(player, machine);
    }

    @ParametersAreNonnullByDefault
    public static boolean isPlayerAdmin(Player player, IHasOwner ownedBlock) {
        TrustedPlayer trustedPlayer = PlayerUtil.getTrustedPlayer(player, ownedBlock);
        return PlayerUtil.isPlayerOwner(player, ownedBlock) || trustedPlayer != null && trustedPlayer.getAccessLevel().equals((Object)EnumAccessLevel.ADMIN);
    }

    @ParametersAreNonnullByDefault
    public static boolean canPlayerChangeSetting(EntityPlayer checkPlayer, IHasOwner machine) {
        Player player = new Player(checkPlayer);
        return PlayerUtil.canPlayerChangeSetting(player, machine);
    }

    @ParametersAreNonnullByDefault
    public static boolean canPlayerChangeSetting(Player player, IHasOwner ownedBlock) {
        TrustedPlayer trustedPlayer = PlayerUtil.getTrustedPlayer(player, ownedBlock);
        return PlayerUtil.isPlayerAdmin(player, ownedBlock) || trustedPlayer != null && trustedPlayer.getAccessLevel().equals((Object)EnumAccessLevel.CHANGE_SETTINGS);
    }

    @ParametersAreNonnullByDefault
    public static boolean canPlayerAccessBlock(EntityPlayer entityPlayer, IHasOwner ownedBlock) {
        Player player = new Player(entityPlayer);
        return PlayerUtil.canPlayerAccessBlock(player, ownedBlock);
    }

    @ParametersAreNonnullByDefault
    public static boolean canPlayerAccessBlock(Player player, IHasOwner ownedBlock) {
        if (OMConfig.GENERAL.canOPAccessOwnedBlocks && PlayerUtil.isPlayerOP(player)) {
            return true;
        }
        TrustedPlayer trustedPlayer = PlayerUtil.getTrustedPlayer(player, ownedBlock);
        return PlayerUtil.canPlayerChangeSetting(player, ownedBlock) || trustedPlayer != null && trustedPlayer.getAccessLevel().equals((Object)EnumAccessLevel.OPEN_GUI);
    }

    @ParametersAreNonnullByDefault
    public static void addChatMessage(ICommandSender sender, ITextComponent component) {
        if (sender instanceof EntityPlayer) {
            ((EntityPlayer)sender).func_146105_b(component, false);
        } else {
            sender.func_145747_a(component);
        }
    }

    @ParametersAreNonnullByDefault
    public static EnumAccessLevel getPlayerAccessLevel(EntityPlayer player, IHasOwner ownedBlock) {
        if (PlayerUtil.isPlayerOwner(player, ownedBlock)) {
            return EnumAccessLevel.ADMIN;
        }
        if (PlayerUtil.isPlayerAdmin(player, ownedBlock)) {
            return EnumAccessLevel.ADMIN;
        }
        if (PlayerUtil.canPlayerChangeSetting(player, ownedBlock)) {
            return EnumAccessLevel.CHANGE_SETTINGS;
        }
        if (PlayerUtil.canPlayerAccessBlock(player, ownedBlock)) {
            return EnumAccessLevel.OPEN_GUI;
        }
        return EnumAccessLevel.NONE;
    }

    @Nullable
    public static Player getPlayerFromUsernameCache(String name) {
        Player player = null;
        for (Map.Entry serverName : UsernameCache.getMap().entrySet()) {
            if (!name.equals(serverName.getValue())) continue;
            player = new Player((UUID)serverName.getKey(), (String)serverName.getValue());
            break;
        }
        return player;
    }
}

