/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network.sync;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.util.INBTSerializable;
import sonar.core.api.energy.ISonarEnergyStorage;
import sonar.core.api.utils.ActionType;
import sonar.core.handlers.energy.InternalEnergyStorageWrapper;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.DirtyPart;
import sonar.core.network.sync.ISyncPart;

public class SyncEnergyStorage
extends DirtyPart
implements ISonarEnergyStorage,
INBTSerializable<NBTTagCompound>,
ISyncPart {
    private long energy;
    private long capacity;
    private long maxReceive;
    private long maxExtract;
    private InternalEnergyStorageWrapper[] wrappers = new InternalEnergyStorageWrapper[7];
    private String tagName = "energyStorage";

    public SyncEnergyStorage(int capacity) {
        this(capacity, capacity, capacity);
    }

    public SyncEnergyStorage(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer);
    }

    public SyncEnergyStorage(int capacity, int maxReceive, int maxExtract) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public InternalEnergyStorageWrapper getOrCreateWrapper(@Nullable EnumFacing face) {
        int id;
        int n = id = face == null ? 6 : face.func_176745_a();
        if (this.wrappers[id] != null) {
            return this.wrappers[id];
        }
        this.wrappers[id] = new InternalEnergyStorageWrapper(this, face);
        return this.wrappers[id];
    }

    public InternalEnergyStorageWrapper getInternalWrapper() {
        return this.getOrCreateWrapper(null);
    }

    public SyncEnergyStorage setCapacity(int capacity) {
        this.capacity = capacity;
        if (this.energy > (long)capacity) {
            this.energy = capacity;
        }
        this.markChanged();
        return this;
    }

    public SyncEnergyStorage setMaxTransfer(int maxTransfer) {
        this.setMaxReceive(maxTransfer);
        this.setMaxExtract(maxTransfer);
        return this;
    }

    public SyncEnergyStorage setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
        this.markChanged();
        return this;
    }

    public SyncEnergyStorage setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
        this.markChanged();
        return this;
    }

    public long getMaxReceive() {
        return this.maxReceive;
    }

    public long getMaxExtract() {
        return this.maxExtract;
    }

    public void setEnergyStored(long energy) {
        this.energy = energy;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0L) {
            this.energy = 0L;
        }
        this.markChanged();
    }

    public void modifyEnergyStored(long energy) {
        this.energy += energy;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0L) {
            this.energy = 0L;
        }
        this.markChanged();
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        if (this.energy < 0L) {
            this.energy = 0L;
        }
        buf.writeLong(this.energy);
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.energy = buf.readLong();
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        }
    }

    public SyncEnergyStorage readFromNBT(NBTTagCompound nbt) {
        this.energy = nbt.func_74763_f("Energy");
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        }
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.energy < 0L) {
            this.energy = 0L;
        }
        nbt.func_74772_a("Energy", this.energy);
        return nbt;
    }

    @Override
    public final NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound energyTag = new NBTTagCompound();
        this.writeToNBT(energyTag);
        nbt.func_74782_a(this.getTagName(), (NBTBase)energyTag);
        return nbt;
    }

    @Override
    public final void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (nbt.func_74764_b(this.getTagName())) {
            this.readFromNBT(nbt.func_74775_l(this.getTagName()));
        }
    }

    @Override
    public String getTagName() {
        return this.tagName;
    }

    public SyncEnergyStorage setTagName(String tagName) {
        this.tagName = tagName;
        return this;
    }

    @Override
    public boolean canSync(NBTHelper.SyncType sync) {
        return sync.isType(NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE);
    }

    @Override
    public long addEnergy(long maxReceive, EnumFacing face, ActionType action) {
        long add = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!action.shouldSimulate()) {
            this.energy += add;
            this.markChanged();
        }
        return add;
    }

    @Override
    public long removeEnergy(long maxExtract, EnumFacing face, ActionType action) {
        long energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (!action.shouldSimulate()) {
            this.energy -= energyExtracted;
            this.markChanged();
        }
        return energyExtracted;
    }

    public boolean canExtract(EnumFacing face) {
        return true;
    }

    public boolean canReceive(EnumFacing face) {
        return true;
    }

    @Override
    public long getEnergyLevel() {
        return this.energy;
    }

    @Override
    public long getFullCapacity() {
        return this.capacity;
    }

    public NBTTagCompound serializeNBT() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.readData(nbt, NBTHelper.SyncType.SAVE);
    }
}

