/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.IPostBlock;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.IWireCoil;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.blocks.BlockIETileProvider;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_Connector;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBreakerSwitch;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorHV;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorLV;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorMV;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorProbe;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorRedstone;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorStructural;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityEnergyMeter;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFeedthrough;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRedstoneBreaker;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRelayHV;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRelayLV;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRelayMV;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTransformer;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTransformerHV;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockConnector
extends BlockIETileProvider<BlockTypes_Connector> {
    public BlockConnector() {
        super("connector", Material.field_151573_f, PropertyEnum.func_177709_a((String)"type", BlockTypes_Connector.class), ItemBlockIEBase.class, new Object[]{IEProperties.FACING_ALL, IEProperties.BOOLEANS[0], IEProperties.BOOLEANS[1], IEProperties.MULTIBLOCKSLAVE, IOBJModelCallback.PROPERTY, IEProperties.TILEENTITY_PASSTHROUGH});
        this.func_149711_c(3.0f);
        this.func_149752_b(15.0f);
        this.field_149786_r = 0;
        this.setMetaBlockLayer(BlockTypes_Connector.RELAY_HV.getMeta(), BlockRenderLayer.SOLID, BlockRenderLayer.TRANSLUCENT);
        this.setMetaBlockLayer(BlockTypes_Connector.CONNECTOR_PROBE.getMeta(), BlockRenderLayer.SOLID, BlockRenderLayer.CUTOUT, BlockRenderLayer.TRANSLUCENT);
        this.setMetaBlockLayer(BlockTypes_Connector.FEEDTHROUGH.getMeta(), BlockRenderLayer.SOLID, BlockRenderLayer.CUTOUT, BlockRenderLayer.CUTOUT_MIPPED, BlockRenderLayer.TRANSLUCENT);
        this.setAllNotNormalBlock();
        this.setMetaMobilityFlag(BlockTypes_Connector.TRANSFORMER.getMeta(), EnumPushReaction.BLOCK);
        this.setMetaMobilityFlag(BlockTypes_Connector.TRANSFORMER_HV.getMeta(), EnumPushReaction.BLOCK);
        this.setMetaMobilityFlag(BlockTypes_Connector.ENERGY_METER.getMeta(), EnumPushReaction.BLOCK);
        this.setMetaMobilityFlag(BlockTypes_Connector.FEEDTHROUGH.getMeta(), EnumPushReaction.BLOCK);
    }

    @Override
    public boolean useCustomStateMapper() {
        return true;
    }

    @Override
    public String getCustomStateMapping(int meta, boolean itemBlock) {
        if (meta == BlockTypes_Connector.TRANSFORMER.getMeta()) {
            return "transformer";
        }
        if (meta == BlockTypes_Connector.TRANSFORMER_HV.getMeta()) {
            return "transformer_hv";
        }
        if (meta == BlockTypes_Connector.BREAKERSWITCH.getMeta()) {
            return "breaker_switch";
        }
        if (meta == BlockTypes_Connector.REDSTONE_BREAKER.getMeta()) {
            return "redstone_breaker";
        }
        if (meta == BlockTypes_Connector.ENERGY_METER.getMeta()) {
            return "energy_meter";
        }
        return null;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        BlockStateContainer base = super.func_180661_e();
        IUnlistedProperty[] unlisted = base instanceof ExtendedBlockState ? ((ExtendedBlockState)base).getUnlistedProperties().toArray(new IUnlistedProperty[0]) : new IUnlistedProperty[]{};
        unlisted = Arrays.copyOf(unlisted, unlisted.length + 1);
        unlisted[unlisted.length - 1] = IEProperties.CONNECTIONS;
        return new ExtendedBlockState((Block)this, base.func_177623_d().toArray(new IProperty[0]), unlisted);
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if ((state = super.getExtendedState(state, world, pos)) instanceof IExtendedBlockState) {
            IExtendedBlockState ext = (IExtendedBlockState)state;
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof TileEntityImmersiveConnectable)) {
                return state;
            }
            state = ext.withProperty((IUnlistedProperty)IEProperties.CONNECTIONS, ((TileEntityImmersiveConnectable)te).genConnBlockstate());
        }
        return state;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState s = world.func_180495_p(pos);
        return s.func_177229_b((IProperty)this.property) == BlockTypes_Connector.ENERGY_METER;
    }

    @Override
    public boolean canIEBlockBePlaced(World world, BlockPos pos, IBlockState newState, EnumFacing side, float hitX, float hitY, float hitZ, EntityPlayer player, ItemStack stack) {
        switch (BlockTypes_Connector.values()[stack.func_77952_i()]) {
            case TRANSFORMER: 
            case TRANSFORMER_HV: {
                for (int hh = 1; hh <= 2; ++hh) {
                    BlockPos pos2 = pos.func_177981_b(hh);
                    if (!world.func_189509_E(pos2) && world.func_180495_p(pos2).func_177230_c().func_176200_f((IBlockAccess)world, pos2)) continue;
                    return false;
                }
                break;
            }
            case ENERGY_METER: {
                BlockPos pos2 = pos.func_177984_a();
                return !world.func_189509_E(pos2) && world.func_180495_p(pos2).func_177230_c().func_176200_f((IBlockAccess)world, pos2);
            }
            case FEEDTHROUGH: {
                EnumFacing f = new TileEntityFeedthrough().getFacingForPlacement((EntityLivingBase)player, pos, side, hitX, hitY, hitZ);
                BlockPos forward = pos.func_177967_a(f, 1);
                BlockPos backward = pos.func_177967_a(f, -1);
                return world.func_180495_p(forward).func_177230_c().func_176200_f((IBlockAccess)world, forward) && world.func_180495_p(backward).func_177230_c().func_176200_f((IBlockAccess)world, backward);
            }
        }
        return true;
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntityImmersiveConnectable connector;
        super.func_189540_a(state, world, pos, blockIn, fromPos);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityConnectorLV) {
            connector = (TileEntityConnectorLV)te;
            if (world.func_175623_d(pos.func_177972_a(((TileEntityConnectorLV)connector).facing))) {
                this.func_176226_b(connector.func_145831_w(), pos, world.func_180495_p(pos), 0);
                connector.func_145831_w().func_175698_g(pos);
                return;
            }
        }
        if (te instanceof TileEntityConnectorRedstone) {
            connector = (TileEntityConnectorRedstone)te;
            if (world.func_175623_d(pos.func_177972_a(((TileEntityConnectorRedstone)connector).facing))) {
                this.func_176226_b(connector.func_145831_w(), pos, world.func_180495_p(pos), 0);
                connector.func_145831_w().func_175698_g(pos);
                return;
            }
            if (((TileEntityConnectorRedstone)connector).isRSInput()) {
                ((TileEntityConnectorRedstone)connector).rsDirty = true;
            }
        }
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity te;
        if (player != null && player.func_70093_af() && (te = world.func_175625_s(pos)) instanceof IImmersiveConnectable) {
            TargetingInfo subTarget = null;
            subTarget = target.field_72307_f != null ? new TargetingInfo(target.field_178784_b, (float)target.field_72307_f.field_72450_a - (float)pos.func_177958_n(), (float)target.field_72307_f.field_72448_b - (float)pos.func_177956_o(), (float)target.field_72307_f.field_72449_c - (float)pos.func_177952_p()) : new TargetingInfo(target.field_178784_b, 0.0f, 0.0f, 0.0f);
            BlockPos masterPos = ((IImmersiveConnectable)te).getConnectionMaster(null, subTarget);
            if (masterPos != pos) {
                te = world.func_175625_s(masterPos);
            }
            if (te instanceof IImmersiveConnectable) {
                IImmersiveConnectable connectable = (IImmersiveConnectable)te;
                WireType wire = connectable.getCableLimiter(subTarget);
                if (wire != null) {
                    return wire.getWireCoil();
                }
                ArrayList<ItemStack> applicableWires = new ArrayList<ItemStack>();
                NonNullList pInventory = player.field_71071_by.field_70462_a;
                for (int i = 0; i < pInventory.size(); ++i) {
                    IWireCoil coilItem;
                    ItemStack s = (ItemStack)pInventory.get(i);
                    if (!(s.func_77973_b() instanceof IWireCoil) || !connectable.canConnectCable(wire = (coilItem = (IWireCoil)s.func_77973_b()).getWireType(s), subTarget, (Vec3i)pos.func_177973_b((Vec3i)masterPos)) || !coilItem.canConnectCable(s, te)) continue;
                    ItemStack coil = wire.getWireCoil();
                    boolean unique = true;
                    int insertIndex = applicableWires.size();
                    for (int j = 0; j < applicableWires.size(); ++j) {
                        int priorID;
                        ItemStack priorWire = (ItemStack)applicableWires.get(j);
                        if (coil.func_77973_b() == priorWire.func_77973_b()) {
                            if (coil.func_77960_j() == priorWire.func_77960_j()) {
                                unique = false;
                                break;
                            }
                            if (coil.func_77960_j() >= priorWire.func_77960_j()) continue;
                            insertIndex = j;
                            break;
                        }
                        int coilID = Item.field_150901_e.func_148757_b((Object)coil.func_77973_b());
                        if (coilID >= (priorID = Item.field_150901_e.func_148757_b((Object)priorWire.func_77973_b()))) continue;
                        insertIndex = j;
                        break;
                    }
                    if (!unique) continue;
                    applicableWires.add(insertIndex, coil);
                }
                if (applicableWires.size() > 0) {
                    ItemStack heldItem = (ItemStack)pInventory.get(player.field_71071_by.field_70461_c);
                    if (heldItem.func_77973_b() instanceof IWireCoil) {
                        for (int i = 0; i < applicableWires.size(); ++i) {
                            if (!heldItem.func_77969_a((ItemStack)applicableWires.get(i))) continue;
                            return (ItemStack)applicableWires.get((i + 1) % applicableWires.size());
                        }
                    }
                    return (ItemStack)applicableWires.get(0);
                }
            }
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    @Override
    public TileEntity createBasicTE(World world, BlockTypes_Connector type) {
        switch (type) {
            case CONNECTOR_LV: {
                return new TileEntityConnectorLV();
            }
            case RELAY_LV: {
                return new TileEntityRelayLV();
            }
            case CONNECTOR_MV: {
                return new TileEntityConnectorMV();
            }
            case RELAY_MV: {
                return new TileEntityRelayMV();
            }
            case CONNECTOR_HV: {
                return new TileEntityConnectorHV();
            }
            case RELAY_HV: {
                return new TileEntityRelayHV();
            }
            case CONNECTOR_STRUCTURAL: {
                return new TileEntityConnectorStructural();
            }
            case TRANSFORMER: {
                return new TileEntityTransformer();
            }
            case TRANSFORMER_HV: {
                return new TileEntityTransformerHV();
            }
            case BREAKERSWITCH: {
                return new TileEntityBreakerSwitch();
            }
            case REDSTONE_BREAKER: {
                return new TileEntityRedstoneBreaker();
            }
            case ENERGY_METER: {
                return new TileEntityEnergyMeter();
            }
            case CONNECTOR_REDSTONE: {
                return new TileEntityConnectorRedstone();
            }
            case CONNECTOR_PROBE: {
                return new TileEntityConnectorProbe();
            }
            case FEEDTHROUGH: {
                return new TileEntityFeedthrough();
            }
        }
        return null;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState ret = super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer);
        if (meta == BlockTypes_Connector.TRANSFORMER.getMeta()) {
            TileEntity tile;
            BlockPos pos2 = pos.func_177967_a(facing, -1);
            IBlockState placedAgainst = world.func_180495_p(pos2);
            Block block = placedAgainst.func_177230_c();
            if (block instanceof IPostBlock && ((IPostBlock)block).canConnectTransformer((IBlockAccess)world, pos2)) {
                ret = ret.func_177226_a((IProperty)IEProperties.BOOLEANS[1], (Comparable)Boolean.valueOf(true));
            }
            if ((tile = world.func_175625_s(pos2)) instanceof IPostBlock && ((IPostBlock)tile).canConnectTransformer((IBlockAccess)world, pos2)) {
                ret = ret.func_177226_a((IProperty)IEProperties.BOOLEANS[1], (Comparable)Boolean.valueOf(true));
            }
        }
        return ret;
    }

    @Override
    public boolean allowHammerHarvest(IBlockState state) {
        return true;
    }

    @Override
    public int getLightOpacity(IBlockState state, IBlockAccess w, BlockPos pos) {
        TileEntity te;
        if (state.func_177229_b((IProperty)this.property) == BlockTypes_Connector.FEEDTHROUGH && (te = w.func_175625_s(pos)) instanceof TileEntityFeedthrough && ((TileEntityFeedthrough)te).offset == 0) {
            return 255;
        }
        return super.getLightOpacity(state, w, pos);
    }
}

