/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.init;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CorePotions {
    public static final CorePotions INSTANCE = new CorePotions();
    public static boolean disableAll = false;
    private static boolean registered = false;
    public static PotionType haste;
    public static PotionType hasteLong;
    public static PotionType hasteStrong;
    public static PotionType resistance;
    public static PotionType resistanceLong;
    public static PotionType resistanceStrong;
    public static PotionType levitation;
    public static PotionType levitationLong;
    public static PotionType absorption;
    public static PotionType absorptionLong;
    public static PotionType absorptionStrong;
    public static PotionType luck;
    public static PotionType luckLong;
    public static PotionType luckStrong;
    public static PotionType unluck;
    public static PotionType unluckLong;
    public static PotionType unluckStrong;
    public static PotionType wither;
    public static PotionType witherLong;
    public static PotionType witherStrong;

    private CorePotions() {
    }

    public static void preInit() {
        int duration = 3600;
        int durationLong = 9600;
        int durationStrong = 1800;
        haste = new PotionType("haste", new PotionEffect[]{new PotionEffect(MobEffects.field_76422_e, duration)});
        hasteLong = new PotionType("haste", new PotionEffect[]{new PotionEffect(MobEffects.field_76422_e, durationLong)});
        hasteStrong = new PotionType("haste", new PotionEffect[]{new PotionEffect(MobEffects.field_76422_e, durationStrong, 1)});
        resistance = new PotionType("resistance", new PotionEffect[]{new PotionEffect(MobEffects.field_76429_m, duration)});
        resistanceLong = new PotionType("resistance", new PotionEffect[]{new PotionEffect(MobEffects.field_76429_m, durationLong)});
        resistanceStrong = new PotionType("resistance", new PotionEffect[]{new PotionEffect(MobEffects.field_76429_m, durationStrong, 1)});
        levitation = new PotionType("levitation", new PotionEffect[]{new PotionEffect(MobEffects.field_188424_y, duration)});
        levitationLong = new PotionType("levitation", new PotionEffect[]{new PotionEffect(MobEffects.field_188424_y, durationLong)});
        absorption = new PotionType("absorption", new PotionEffect[]{new PotionEffect(MobEffects.field_76444_x, duration)});
        absorptionLong = new PotionType("absorption", new PotionEffect[]{new PotionEffect(MobEffects.field_76444_x, durationLong)});
        absorptionStrong = new PotionType("absorption", new PotionEffect[]{new PotionEffect(MobEffects.field_76444_x, durationStrong, 1)});
        luck = new PotionType("luck", new PotionEffect[]{new PotionEffect(MobEffects.field_188425_z, duration)});
        luckLong = new PotionType("luck", new PotionEffect[]{new PotionEffect(MobEffects.field_188425_z, durationLong)});
        luckStrong = new PotionType("luck", new PotionEffect[]{new PotionEffect(MobEffects.field_188425_z, durationStrong, 1)});
        unluck = new PotionType("unluck", new PotionEffect[]{new PotionEffect(MobEffects.field_189112_A, duration / 2)});
        unluckLong = new PotionType("unluck", new PotionEffect[]{new PotionEffect(MobEffects.field_189112_A, durationLong / 2)});
        unluckStrong = new PotionType("unluck", new PotionEffect[]{new PotionEffect(MobEffects.field_189112_A, durationStrong / 2, 1)});
        wither = new PotionType("wither", new PotionEffect[]{new PotionEffect(MobEffects.field_82731_v, duration / 4)});
        witherLong = new PotionType("wither", new PotionEffect[]{new PotionEffect(MobEffects.field_82731_v, 2 * duration / 4)});
        witherStrong = new PotionType("wither", new PotionEffect[]{new PotionEffect(MobEffects.field_82731_v, durationStrong / 4, 1)});
        haste.setRegistryName("haste");
        hasteLong.setRegistryName("haste+");
        hasteStrong.setRegistryName("haste2");
        resistance.setRegistryName("resistance");
        resistanceLong.setRegistryName("resistance+");
        resistanceStrong.setRegistryName("resistance2");
        levitation.setRegistryName("levitation");
        levitationLong.setRegistryName("levitation+");
        absorption.setRegistryName("absorption");
        absorptionLong.setRegistryName("absorption+");
        absorptionStrong.setRegistryName("absorption2");
        luck.setRegistryName("luck");
        luckLong.setRegistryName("luck+");
        luckStrong.setRegistryName("luck2");
        unluck.setRegistryName("unluck");
        unluckLong.setRegistryName("unluck+");
        unluckStrong.setRegistryName("unluck2");
        wither.setRegistryName("wither");
        witherLong.setRegistryName("wither+");
        witherStrong.setRegistryName("wither2");
    }

    public static void register() {
        if (disableAll || registered) {
            return;
        }
        ModContainer callingContainer = Loader.instance().activeModContainer();
        ModContainer cofhContainer = FMLCommonHandler.instance().findContainerFor((Object)"cofhcore");
        Loader.instance().setActiveModContainer(cofhContainer);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        registered = true;
        Loader.instance().setActiveModContainer(callingContainer);
    }

    public static boolean registered() {
        return registered;
    }

    @SubscribeEvent
    public void registerPotionTypes(RegistryEvent.Register<PotionType> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)haste);
        registry.register((IForgeRegistryEntry)hasteLong);
        registry.register((IForgeRegistryEntry)hasteStrong);
        registry.register((IForgeRegistryEntry)resistance);
        registry.register((IForgeRegistryEntry)resistanceLong);
        registry.register((IForgeRegistryEntry)resistanceStrong);
        registry.register((IForgeRegistryEntry)levitation);
        registry.register((IForgeRegistryEntry)levitationLong);
        registry.register((IForgeRegistryEntry)absorption);
        registry.register((IForgeRegistryEntry)absorptionLong);
        registry.register((IForgeRegistryEntry)absorptionStrong);
        registry.register((IForgeRegistryEntry)luck);
        registry.register((IForgeRegistryEntry)luckLong);
        registry.register((IForgeRegistryEntry)luckStrong);
        registry.register((IForgeRegistryEntry)unluck);
        registry.register((IForgeRegistryEntry)unluckLong);
        registry.register((IForgeRegistryEntry)unluckStrong);
        registry.register((IForgeRegistryEntry)wither);
        registry.register((IForgeRegistryEntry)witherLong);
        registry.register((IForgeRegistryEntry)witherStrong);
        int min = 3;
        int max = 4;
        this.createStrongPotionTypes(event, PotionTypes.field_185238_j, min, max);
        this.createStrongPotionTypes(event, PotionTypes.field_185243_o, min, max);
        this.createStrongPotionTypes(event, PotionTypes.field_185250_v, min, max);
        this.createStrongPotionTypes(event, PotionTypes.field_185252_x, min, max);
        this.createStrongPotionTypes(event, PotionTypes.field_185254_z, min, max);
        this.createStrongPotionTypes(event, PotionTypes.field_185220_C, min, max);
        this.createStrongPotionTypes(event, PotionTypes.field_185223_F, min, max);
        this.createStrongPotionTypes(event, haste, min, max);
        this.createStrongPotionTypes(event, resistance, min, max);
        this.createStrongPotionTypes(event, absorption, min, max);
        this.createStrongPotionTypes(event, luck, min, max);
        this.createStrongPotionTypes(event, unluck, min, max);
        this.createStrongPotionTypes(event, wither, min, max);
        min = 2;
        max = 3;
        this.createStrongPotionTypes(event, PotionTypes.field_185239_k, min, max, "+");
        this.createStrongPotionTypes(event, PotionTypes.field_185244_p, min, max, "+");
        this.createStrongPotionTypes(event, PotionTypes.field_185218_A, min, max, "+");
        this.createStrongPotionTypes(event, PotionTypes.field_185221_D, min, max, "+");
        this.createStrongPotionTypes(event, PotionTypes.field_185224_G, min, max, "+");
        this.createStrongPotionTypes(event, hasteLong, min, max, "+");
        this.createStrongPotionTypes(event, resistanceLong, min, max, "+");
        this.createStrongPotionTypes(event, absorptionLong, min, max, "+");
        this.createStrongPotionTypes(event, luckLong, min, max, "+");
        this.createStrongPotionTypes(event, unluckLong, min, max, "+");
        this.createStrongPotionTypes(event, witherLong, min, max, "+");
    }

    public void createStrongPotionTypes(RegistryEvent.Register<PotionType> event, PotionType type, int minAmplifier, int maxAmplifier) {
        this.createStrongPotionTypes(event, type, minAmplifier, maxAmplifier, "");
    }

    public void createStrongPotionTypes(RegistryEvent.Register<PotionType> event, PotionType type, int minAmplifier, int maxAmplifier, String postfix) {
        List baseEffects = type.func_185170_a();
        String baseName = type.func_185174_b("");
        if (baseEffects.isEmpty()) {
            return;
        }
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (int i = minAmplifier; i <= maxAmplifier; ++i) {
            effects.clear();
            for (PotionEffect effect : baseEffects) {
                effects.add(new PotionEffect(effect.func_188419_a(), Math.max(1, effect.func_76459_b() / (1 + i)), i - 1));
            }
            PotionType potion = new PotionType(baseName, effects.toArray(new PotionEffect[effects.size()]));
            potion.setRegistryName(baseName + i + postfix);
            event.getRegistry().register((IForgeRegistryEntry)potion);
        }
    }
}

