/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.recipe.IThermopneumaticProcessingPlantRecipe;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.recipes.BasicThermopneumaticProcessingPlantRecipe;
import me.desht.pneumaticcraft.common.tileentity.IAutoFluidEjecting;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.ISmartFluidSync;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;

public class TileEntityThermopneumaticProcessingPlant
extends TileEntityPneumaticBase
implements IHeatExchanger,
IMinWorkingPressure,
IRedstoneControlled,
ISerializableTanks,
ISmartFluidSync,
IAutoFluidEjecting {
    private static final int INVENTORY_SIZE = 1;
    private static final int CRAFTING_TIME = 6000;
    private static final double MAX_SPEED_UP = 2.5;
    @GuiSynced
    @DescSynced
    @LazySynced
    private final ThermopneumaticFluidTankInput inputTank = new ThermopneumaticFluidTankInput(16000);
    @GuiSynced
    @DescSynced
    @LazySynced
    private final ThermopneumaticFluidTankOutput outputTank = new ThermopneumaticFluidTankOutput(16000);
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().getHeatExchangerLogic();
    @GuiSynced
    public int redstoneMode;
    @GuiSynced
    private int craftingProgress;
    @GuiSynced
    public boolean hasRecipe;
    @GuiSynced
    private float requiredPressure;
    @GuiSynced
    public double requiredTemperature;
    @DescSynced
    private int inputAmountScaled;
    @DescSynced
    private int outputAmountScaled;
    @DescSynced
    private boolean didWork;
    private IThermopneumaticProcessingPlantRecipe currentRecipe;
    private boolean searchForRecipe = true;
    private final ItemStackHandler handler = new BaseItemStackHandler(this, 1){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.func_190926_b() || BasicThermopneumaticProcessingPlantRecipe.recipes.stream().anyMatch(r -> r.isValidInput(itemStack));
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityThermopneumaticProcessingPlant.this.searchForRecipe = true;
        }
    };
    private final ThermopneumaticFluidHandler fluidHandler = new ThermopneumaticFluidHandler();

    public TileEntityThermopneumaticProcessingPlant() {
        super(5.0f, 7.0f, 3000, 4);
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.DISPENSER);
        this.heatExchanger.setThermalResistance(10.0);
    }

    @Override
    public boolean isConnectedTo(EnumFacing dir) {
        return this.getRotation().func_176734_d() != dir && dir != EnumFacing.UP;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            if (this.searchForRecipe || (this.func_145831_w().func_82737_E() & 0xFL) == 0L) {
                this.currentRecipe = this.getValidRecipe();
                this.searchForRecipe = false;
            }
            this.hasRecipe = this.currentRecipe != null;
            this.didWork = false;
            if (this.hasRecipe) {
                ItemStack stackInSlot = this.handler.getStackInSlot(0);
                this.requiredPressure = this.currentRecipe.getRequiredPressure(this.inputTank.getFluid(), stackInSlot);
                this.requiredTemperature = this.currentRecipe.getRequiredTemperature(this.inputTank.getFluid(), stackInSlot);
                if (this.redstoneAllows() && this.heatExchanger.getTemperature() >= this.requiredTemperature && this.getPressure() >= this.getMinWorkingPressure()) {
                    double inc = this.requiredTemperature > 0.0 ? Math.min(2.5, this.heatExchanger.getTemperature() / this.requiredTemperature) : 1.0;
                    this.craftingProgress = (int)((double)this.craftingProgress + inc * 100.0);
                    if (this.craftingProgress >= 6000) {
                        this.outputTank.fill(this.currentRecipe.getRecipeOutput(this.inputTank.getFluid(), stackInSlot).copy(), true);
                        this.currentRecipe.useResources((IFluidHandler)this.inputTank, (IItemHandler)this.handler);
                        this.addAir(-this.currentRecipe.airUsed(this.inputTank.getFluid(), stackInSlot));
                        this.heatExchanger.addHeat(-this.currentRecipe.heatUsed(this.inputTank.getFluid(), stackInSlot) * inc * 0.75);
                        this.craftingProgress -= 6000;
                    }
                    this.didWork = true;
                }
            } else {
                this.craftingProgress = 0;
                this.requiredTemperature = 0.0;
                this.requiredPressure = 0.0f;
            }
        } else if (this.didWork && this.func_145831_w().field_73012_v.nextBoolean()) {
            ClientUtils.emitParticles(this.func_145831_w(), this.func_174877_v(), EnumParticleTypes.SMOKE_NORMAL);
        }
    }

    private IThermopneumaticProcessingPlantRecipe getValidRecipe() {
        for (IThermopneumaticProcessingPlantRecipe recipe : BasicThermopneumaticProcessingPlantRecipe.recipes) {
            if (!recipe.isValidRecipe(this.inputTank.getFluid(), this.handler.getStackInSlot(0))) continue;
            if (this.outputTank.getFluid() == null) {
                return recipe;
            }
            FluidStack output = recipe.getRecipeOutput(this.inputTank.getFluid(), this.handler.getStackInSlot(0));
            if (output.getFluid() != this.outputTank.getFluid().getFluid() || output.amount > this.outputTank.getCapacity() - this.outputTank.getFluidAmount()) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public IItemHandlerModifiable getPrimaryInventory() {
        return this.handler;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidHandler);
        }
        return super.getCapability(capability, facing);
    }

    public FluidTank getInputTank() {
        return this.inputTank;
    }

    public FluidTank getOutputTank() {
        return this.outputTank;
    }

    @SideOnly(value=Side.CLIENT)
    public double getCraftingPercentage() {
        return (double)this.craftingProgress / 6000.0;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("Items", (NBTBase)this.handler.serializeNBT());
        tag.func_74774_a("redstoneMode", (byte)this.redstoneMode);
        tag.func_74768_a("craftingProgress", this.craftingProgress);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.inputTank.writeToNBT(tankTag);
        tag.func_74782_a("inputTank", (NBTBase)tankTag);
        tankTag = new NBTTagCompound();
        this.outputTank.writeToNBT(tankTag);
        tag.func_74782_a("outputTank", (NBTBase)tankTag);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.handler.deserializeNBT(tag.func_74775_l("Items"));
        this.redstoneMode = tag.func_74771_c("redstoneMode");
        this.craftingProgress = tag.func_74762_e("craftingProgress");
        this.inputTank.readFromNBT(tag.func_74775_l("inputTank"));
        this.inputAmountScaled = this.inputTank.getScaledFluidAmount();
        this.outputTank.readFromNBT(tag.func_74775_l("outputTank"));
        this.outputAmountScaled = this.outputTank.getScaledFluidAmount();
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic(EnumFacing side) {
        return this.heatExchanger;
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        } else if (buttonID == 1) {
            this.inputTank.drain(this.inputTank.getCapacity(), true);
        }
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public float getMinWorkingPressure() {
        return this.requiredPressure;
    }

    @Override
    public String getName() {
        return Blockss.THERMOPNEUMATIC_PROCESSING_PLANT.func_149739_a();
    }

    @Override
    @Nonnull
    public Map<String, FluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"InputTank", (Object)((Object)this.inputTank), (Object)"OutputTank", (Object)((Object)this.outputTank));
    }

    @Override
    public void updateScaledFluidAmount(int tankIndex, int amount) {
        if (tankIndex == 1) {
            this.inputAmountScaled = amount;
        } else if (tankIndex == 2) {
            this.outputAmountScaled = amount;
        }
    }

    private class ThermopneumaticFluidHandler
    implements IFluidHandler {
        private ThermopneumaticFluidHandler() {
        }

        public IFluidTankProperties[] getTankProperties() {
            return (IFluidTankProperties[])ArrayUtils.addAll((Object[])TileEntityThermopneumaticProcessingPlant.this.inputTank.getTankProperties(), (Object[])TileEntityThermopneumaticProcessingPlant.this.outputTank.getTankProperties());
        }

        public int fill(FluidStack resource, boolean doFill) {
            return TileEntityThermopneumaticProcessingPlant.this.inputTank.fill(resource, doFill);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return TileEntityThermopneumaticProcessingPlant.this.outputTank.getFluid() != null && TileEntityThermopneumaticProcessingPlant.this.outputTank.getFluid().isFluidEqual(resource) ? TileEntityThermopneumaticProcessingPlant.this.outputTank.drain(resource.amount, doDrain) : null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return TileEntityThermopneumaticProcessingPlant.this.outputTank.drain(maxDrain, doDrain);
        }
    }

    private class ThermopneumaticFluidTankOutput
    extends ISmartFluidSync.SmartSyncTank {
        ThermopneumaticFluidTankOutput(int capacity) {
            super(TileEntityThermopneumaticProcessingPlant.this, capacity, 2);
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            FluidStack res = super.drain(resource, doDrain);
            if (doDrain && res != null && res.amount > 0) {
                TileEntityThermopneumaticProcessingPlant.this.searchForRecipe = true;
            }
            return res;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            FluidStack res = super.drain(maxDrain, doDrain);
            if (doDrain && res != null && res.amount > 0) {
                TileEntityThermopneumaticProcessingPlant.this.searchForRecipe = true;
            }
            return res;
        }
    }

    private class ThermopneumaticFluidTankInput
    extends ISmartFluidSync.SmartSyncTank {
        private Fluid prevFluid;

        ThermopneumaticFluidTankInput(int capacity) {
            super(TileEntityThermopneumaticProcessingPlant.this, capacity, 1);
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid == null || BasicThermopneumaticProcessingPlantRecipe.recipes.stream().anyMatch(r -> r.isValidInput(fluid));
        }

        @Override
        protected void onContentsChanged() {
            Fluid newFluid;
            super.onContentsChanged();
            Fluid fluid = newFluid = this.getFluid() == null ? null : this.getFluid().getFluid();
            if (this.prevFluid != newFluid) {
                TileEntityThermopneumaticProcessingPlant.this.searchForRecipe = true;
                this.prevFluid = newFluid;
            }
        }
    }
}

