/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.modules;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import exnihilocreatio.ExNihiloCreatio;
import exnihilocreatio.blocks.BlockSieve;
import exnihilocreatio.config.ModConfig;
import exnihilocreatio.items.ore.Ore;
import exnihilocreatio.json.CustomBlockInfoJson;
import exnihilocreatio.json.CustomColorJson;
import exnihilocreatio.json.CustomItemInfoJson;
import exnihilocreatio.json.CustomOreJson;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.manager.ISieveDefaultRegistryProvider;
import exnihilocreatio.registries.registries.SieveRegistry;
import exnihilocreatio.texturing.Color;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.ItemInfo;
import exnihilocreatio.util.StackInfo;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import thelm.jaopca.api.EnumEntryType;
import thelm.jaopca.api.EnumOreType;
import thelm.jaopca.api.IOreEntry;
import thelm.jaopca.api.ItemEntry;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.ModuleBase;
import thelm.jaopca.api.utils.Utils;

public class ModuleExNihiloCreatio
extends ModuleBase {
    public static final ItemEntry PIECE_ENTRY = new ItemEntry(EnumEntryType.ITEM, "piece", new ModelResourceLocation("jaopca:ore_crushed#inventory"));
    public static final ItemEntry CHUNK_ENTRY = new ItemEntry(EnumEntryType.ITEM, "hunk", new ModelResourceLocation("jaopca:ore_broken#inventory"));
    public static final ArrayList<String> GEM_DUST_BLACKLIST = Lists.newArrayList((Object[])new String[]{"Coal", "Lapis", "Diamond", "Emerald", "Quartz", "QuartzBlack", "CertusQuartz", "Redstone", "Glowstone"});
    public static final HashMap<IOreEntry, ItemStack> ORE_SOURCES = Maps.newHashMap();
    public static final HashMap<IOreEntry, float[]> SIEVE_CHANCES = Maps.newHashMap();

    @Override
    public String getName() {
        return "exnihilocreatio";
    }

    @Override
    public EnumSet<EnumOreType> getOreTypes() {
        return EnumSet.of(EnumOreType.GEM, EnumOreType.DUST);
    }

    @Override
    public List<String> getOreBlacklist() {
        return GEM_DUST_BLACKLIST;
    }

    public List<ItemEntry> getItemRequests() {
        ArrayList existingOres;
        block7: {
            existingOres = Lists.newArrayList();
            ArrayList defaults = Lists.newArrayList((Object[])new String[]{"Iron", "Gold", "Copper", "Tin", "Aluminium", "Lead", "Silver", "Nickel", "Ardite", "Cobalt", "Yellorium", "Osmium"});
            if (ModConfig.misc.enableJSONLoading) {
                Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemInfo.class, (Object)CustomItemInfoJson.INSTANCE).registerTypeAdapter(BlockInfo.class, (Object)CustomBlockInfoJson.INSTANCE).registerTypeAdapter(Ore.class, (Object)CustomOreJson.INSTANCE).registerTypeAdapter(Color.class, (Object)CustomColorJson.INSTANCE).create();
                ParameterizedType TYPE = new ParameterizedType(){

                    @Override
                    public Type[] getActualTypeArguments() {
                        return new Type[]{Ore.class};
                    }

                    @Override
                    public Type getRawType() {
                        return List.class;
                    }

                    @Override
                    public Type getOwnerType() {
                        return null;
                    }
                };
                try {
                    File file = new File(ExNihiloCreatio.configDirectory, "OreRegistry.json");
                    if (file.exists()) {
                        FileReader e = new FileReader(file);
                        for (Ore ore : (List)gson.fromJson((Reader)e, (Type)TYPE)) {
                            existingOres.add(StringUtils.capitalize((String)ore.getName()));
                        }
                        break block7;
                    }
                    existingOres.addAll(defaults);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    existingOres.addAll(defaults);
                }
            } else {
                existingOres.addAll(defaults);
            }
        }
        ArrayList ret = Lists.newArrayList((Object[])new ItemEntry[]{PIECE_ENTRY, CHUNK_ENTRY});
        for (ItemEntry entry : ret) {
            entry.blacklist.addAll(existingOres);
        }
        return ret;
    }

    @Override
    public void registerConfigs(Configuration config) {
        float[] data;
        ItemStack stack;
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"piece")) {
            stack = Utils.parseItemStack(config.get(Utils.to_under_score(entry.getOreName()), "eNCSource", "minecraft:gravel", "Block to sift for this material. (Ex Nihilo Creatio)").setRequiresMcRestart(true).getString());
            data = new float[]{(float)config.get(Utils.to_under_score(entry.getOreName()), "eNCFlintChance", Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_150351_n ? ModuleExNihiloCreatio.getDropChance(entry, 0.2) : ModuleExNihiloCreatio.getDropChance(entry, 0.1), "Chance using flint mesh. (Ex Nihilo Creatio)").setRequiresMcRestart(true).getDouble(), (float)config.get(Utils.to_under_score(entry.getOreName()), "eNCIronChance", ModuleExNihiloCreatio.getDropChance(entry, 0.2), "Chance using iron mesh. (Ex Nihilo Creatio)").setRequiresMcRestart(true).getDouble(), (float)config.get(Utils.to_under_score(entry.getOreName()), "eNCDiamondChance", Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_150351_n ? ModuleExNihiloCreatio.getDropChance(entry, 0.1) : ModuleExNihiloCreatio.getDropChance(entry, 0.3), "Chance using diamond mesh. (Ex Nihilo Creatio)").setRequiresMcRestart(true).getDouble()};
            ORE_SOURCES.put(entry, stack);
            SIEVE_CHANCES.put(entry, data);
        }
        block4: for (IOreEntry entry : JAOPCAApi.MODULE_TO_ORES_MAP.get((Object)this)) {
            switch (entry.getOreType()) {
                case DUST: {
                    stack = Utils.parseItemStack(config.get(Utils.to_under_score(entry.getOreName()), "eNCSource", "exnihilocreatio:block_dust", "Block to sift for this material. (Ex Nihilo Creatio)").setRequiresMcRestart(true).getString());
                    data = new float[]{(float)config.get(Utils.to_under_score(entry.getOreName()), "eNCStringChance", 0.0, "Chance using string mesh. (Ex Nihilo Creatio)").setRequiresMcRestart(true).getDouble(), (float)config.get(Utils.to_under_score(entry.getOreName()), "eNCFlintChance", 0.0, "Chance using flint mesh. (Ex Nihilo Creatio)").setRequiresMcRestart(true).getDouble(), (float)config.get(Utils.to_under_score(entry.getOreName()), "eNCIronChance", ModuleExNihiloCreatio.getDropChance(entry, 0.0625), "Chance using iron mesh. (Ex Nihilo Creatio)").setRequiresMcRestart(true).getDouble(), (float)config.get(Utils.to_under_score(entry.getOreName()), "eNCDiamondChance", ModuleExNihiloCreatio.getDropChance(entry, 0.125), "Chance using diamond mesh. (Ex Nihilo Creatio)").setRequiresMcRestart(true).getDouble()};
                    ORE_SOURCES.put(entry, stack);
                    SIEVE_CHANCES.put(entry, data);
                    continue block4;
                }
            }
            stack = Utils.parseItemStack(config.get(Utils.to_under_score(entry.getOreName()), "eNCSource", "minecraft:gravel", "Block to sift for this material. (Ex Nihilo Creatio)").setRequiresMcRestart(true).getString());
            data = new float[]{(float)config.get(Utils.to_under_score(entry.getOreName()), "eNCStringChance", 0.0, "Chance using string mesh. (Ex Nihilo Creatio)").setRequiresMcRestart(true).getDouble(), (float)config.get(Utils.to_under_score(entry.getOreName()), "eNCFlintChance", 0.0, "Chance using flint mesh. (Ex Nihilo Creatio)").setRequiresMcRestart(true).getDouble(), (float)config.get(Utils.to_under_score(entry.getOreName()), "eNCIronChance", ModuleExNihiloCreatio.getDropChance(entry, 0.008), "Chance using iron mesh. (Ex Nihilo Creatio)").setRequiresMcRestart(true).getDouble(), (float)config.get(Utils.to_under_score(entry.getOreName()), "eNCDiamondChance", ModuleExNihiloCreatio.getDropChance(entry, 0.016), "Chance using diamond mesh. (Ex Nihilo Creatio)").setRequiresMcRestart(true).getDouble()};
            ORE_SOURCES.put(entry, stack);
            SIEVE_CHANCES.put(entry, data);
        }
    }

    @Override
    public void preInit() {
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"hunk")) {
            OreDictionary.registerOre((String)("ore" + entry.getOreName()), (ItemStack)Utils.getOreStack("hunk", entry, 1));
        }
        JAOPCADefaultRegistryProvider provider = new JAOPCADefaultRegistryProvider();
        ExNihiloRegistryManager.registerSieveDefaultRecipeHandler((ISieveDefaultRegistryProvider)provider);
    }

    @Override
    public void init() {
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"hunk")) {
            Utils.addShapelessOreRecipe(Utils.getOreStack("hunk", entry, 1), "piece" + entry.getOreName(), "piece" + entry.getOreName(), "piece" + entry.getOreName(), "piece" + entry.getOreName());
            Utils.addSmelting(Utils.getOreStack("hunk", entry, 1), Utils.getOreStack("ingot", entry, 1), 0.7f);
        }
    }

    @Override
    public List<Pair<String, String>> remaps() {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"orepiece", (Object)"piece"), Pair.of((Object)"orechunk", (Object)"hunk")});
    }

    public static double getDropChance(IOreEntry entry, double chance) {
        if (ModConfig.world.isSkyWorld) {
            return chance / entry.getRarity();
        }
        return chance / entry.getRarity() / 100.0 * (double)ModConfig.world.normalDropPercent;
    }

    public class JAOPCADefaultRegistryProvider
    implements ISieveDefaultRegistryProvider {
        public void registerRecipeDefaults(SieveRegistry registry) {
            for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"piece")) {
                ItemStack stack = ORE_SOURCES.get(entry);
                float[] data = SIEVE_CHANCES.get(entry);
                if (data[0] > 0.0f) {
                    registry.register(stack, (StackInfo)new ItemInfo(Utils.getOreStack("piece", entry, 1)), data[0], BlockSieve.MeshType.FLINT.getID());
                }
                if (data[1] > 0.0f) {
                    registry.register(stack, (StackInfo)new ItemInfo(Utils.getOreStack("piece", entry, 1)), data[1], BlockSieve.MeshType.IRON.getID());
                }
                if (!(data[2] > 0.0f)) continue;
                registry.register(stack, (StackInfo)new ItemInfo(Utils.getOreStack("piece", entry, 1)), data[2], BlockSieve.MeshType.DIAMOND.getID());
            }
            for (IOreEntry entry : JAOPCAApi.MODULE_TO_ORES_MAP.get((Object)ModuleExNihiloCreatio.this)) {
                String s = "gem";
                if (entry.getOreType() == EnumOreType.DUST) {
                    s = "dust";
                }
                ItemStack stack = ORE_SOURCES.get(entry);
                float[] data = SIEVE_CHANCES.get(entry);
                if (data[0] > 0.0f) {
                    registry.register(stack, (StackInfo)new ItemInfo(Utils.getOreStack(s, entry, 1)), data[0], BlockSieve.MeshType.STRING.getID());
                }
                if (data[1] > 0.0f) {
                    registry.register(stack, (StackInfo)new ItemInfo(Utils.getOreStack(s, entry, 1)), data[1], BlockSieve.MeshType.FLINT.getID());
                }
                if (data[2] > 0.0f) {
                    registry.register(stack, (StackInfo)new ItemInfo(Utils.getOreStack(s, entry, 1)), data[2], BlockSieve.MeshType.IRON.getID());
                }
                if (!(data[3] > 0.0f)) continue;
                registry.register(stack, (StackInfo)new ItemInfo(Utils.getOreStack(s, entry, 1)), data[3], BlockSieve.MeshType.DIAMOND.getID());
            }
        }
    }
}

