/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.squiddev.plethora.api.IAttachable;
import org.squiddev.plethora.api.method.IContextBuilder;
import org.squiddev.plethora.api.method.IContextFactory;
import org.squiddev.plethora.api.method.ICostHandler;
import org.squiddev.plethora.api.method.IResultExecutor;
import org.squiddev.plethora.api.module.BasicModuleContainer;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.api.reference.IReference;
import org.squiddev.plethora.core.Context;
import org.squiddev.plethora.core.ConverterRegistry;
import org.squiddev.plethora.core.UnbakedContext;
import org.squiddev.plethora.core.capabilities.DefaultCostHandler;
import org.squiddev.plethora.core.executor.NeverExecutor;

public final class ContextFactory<T>
implements IContextFactory<T>,
IContextBuilder {
    private final Object targetValue;
    private final Object targetReference;
    private final List<String> keys = new ArrayList<String>();
    private final List<Object> values = new ArrayList<Object>();
    private final List<Object> references = new ArrayList<Object>();
    private final List<IAttachable> attachments = Lists.newArrayList();
    private IResultExecutor executor = NeverExecutor.INSTANCE;
    private ICostHandler handler = DefaultCostHandler.EMPTY;
    private IModuleContainer modules = BasicModuleContainer.EMPTY;
    private IReference<IModuleContainer> moduleReference = BasicModuleContainer.EMPTY_REF;
    private String[] combinedKeys;
    private Object[] combinedValues;
    private Object[] combinedReferences;

    private ContextFactory(T target, IReference<T> targetReference) {
        this.targetValue = target;
        this.targetReference = targetReference;
    }

    public static <T> ContextFactory<T> of(T target, IReference<T> targetReference) {
        return new ContextFactory<T>(target, targetReference);
    }

    public static <T extends IReference<T>> ContextFactory<T> of(T target) {
        return new ContextFactory<T>(target, target);
    }

    private void dirty() {
        this.combinedKeys = null;
        this.combinedValues = null;
        this.combinedReferences = null;
    }

    @Override
    @Nonnull
    public <U> ContextFactory<T> addContext(@Nonnull String key, @Nonnull U baked, @Nonnull IReference<U> reference) {
        Objects.requireNonNull(key, "key cannot be null");
        Objects.requireNonNull(reference, "reference cannot be null");
        Objects.requireNonNull(baked, "baked cannot be null");
        this.keys.add(key);
        this.values.add(baked);
        this.references.add(reference);
        ConverterRegistry.instance.extendConverted(this.keys, this.values, this.references, this.values.size() - 1);
        this.dirty();
        return this;
    }

    @Override
    @Nonnull
    public <U extends IReference<U>> ContextFactory<T> addContext(@Nonnull String key, @Nonnull U object) {
        Objects.requireNonNull(key, "key cannot be null");
        Objects.requireNonNull(object, "object cannot be null");
        this.keys.add(key);
        this.values.add(object);
        this.references.add(object);
        ConverterRegistry.instance.extendConverted(this.keys, this.values, this.references, this.values.size() - 1);
        this.dirty();
        return this;
    }

    @Override
    @Nonnull
    public ContextFactory<T> withCostHandler(@Nonnull ICostHandler handler) {
        Objects.requireNonNull(handler, "cost handler cannot be null");
        this.handler = handler;
        this.dirty();
        return this;
    }

    @Override
    @Nonnull
    public ContextFactory<T> withExecutor(@Nonnull IResultExecutor executor) {
        Objects.requireNonNull(executor, "executor cannot be null");
        this.executor = executor;
        this.dirty();
        return this;
    }

    @Override
    @Nonnull
    public ContextFactory<T> withModules(@Nonnull IModuleContainer modules, @Nonnull IReference<IModuleContainer> reference) {
        Objects.requireNonNull(modules, "modules cannot be null");
        Objects.requireNonNull(reference, "reference cannot be null");
        this.modules = modules;
        this.moduleReference = reference;
        this.dirty();
        return this;
    }

    private void setup() {
        if (this.combinedKeys == null) {
            ArrayList combinedKeysList = Lists.newArrayListWithExpectedSize((int)(this.keys.size() + 1));
            ArrayList combinedValuesList = Lists.newArrayListWithExpectedSize((int)(this.keys.size() + 1));
            ArrayList combinedReferencesList = Lists.newArrayListWithExpectedSize((int)(this.keys.size() + 1));
            combinedKeysList.addAll(this.keys);
            combinedValuesList.addAll(this.values);
            combinedReferencesList.addAll(this.references);
            combinedKeysList.add("target");
            combinedValuesList.add(this.targetValue);
            combinedReferencesList.add(this.targetReference);
            ConverterRegistry.instance.extendConverted(combinedKeysList, combinedValuesList, combinedReferencesList, combinedKeysList.size() - 1);
            this.combinedKeys = combinedKeysList.toArray(new String[0]);
            this.combinedValues = combinedValuesList.toArray();
            this.combinedReferences = combinedReferencesList.toArray();
        }
    }

    @Override
    @Nonnull
    public Context<T> getBaked() {
        this.setup();
        return new Context(this.getUnbaked(), this.combinedValues, this.modules);
    }

    @Override
    @Nonnull
    public UnbakedContext<T> getUnbaked() {
        this.setup();
        return new UnbakedContext(this.keys.size(), this.combinedKeys, this.combinedReferences, this.handler, this.moduleReference, this.executor);
    }

    @Override
    @Nonnull
    public ContextFactory<T> addAttachable(@Nonnull IAttachable attachable) {
        this.attachments.add(attachable);
        return this;
    }

    public List<IAttachable> getAttachments() {
        return Collections.unmodifiableList(this.attachments);
    }
}

