/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core.wrapper;

import com.google.common.base.Strings;
import com.google.common.primitives.Primitives;
import dan200.computercraft.core.apis.ArgumentHelper;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.IMethod;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.api.method.IUnbakedContext;
import org.squiddev.plethora.api.method.MethodResult;
import org.squiddev.plethora.api.method.wrapper.ArgumentType;
import org.squiddev.plethora.api.method.wrapper.FromContext;
import org.squiddev.plethora.api.method.wrapper.FromSubtarget;
import org.squiddev.plethora.api.method.wrapper.FromTarget;
import org.squiddev.plethora.api.method.wrapper.Optional;
import org.squiddev.plethora.core.PlethoraCore;
import org.squiddev.plethora.core.wrapper.ArgumentTypeRegistry;
import org.squiddev.plethora.core.wrapper.BadWrapperException;
import org.squiddev.plethora.core.wrapper.ClassWriterHelpers;
import org.squiddev.plethora.core.wrapper.MethodInstance;

final class MethodClassLoader
extends ClassLoader {
    public static final MethodClassLoader INSTANCE = new MethodClassLoader();
    private static final String INTERNAL_OBJECT = Type.getInternalName(Object.class);
    private static final String INTERNAL_DELEGATE = Type.getInternalName(IMethod.Delegate.class);
    private static final String INTERNAL_ARGUMENT_HELPER = Type.getInternalName(ArgumentHelper.class);
    private static final String INTERNAL_ARGUMENT_HELPER_II = Type.getInternalName(org.squiddev.plethora.api.method.ArgumentHelper.class);
    private static final String INTERNAL_ARGUMENT_TYPE = Type.getInternalName(ArgumentType.class);
    private static final String INTERNAL_METHOD_RESULT = Type.getInternalName(MethodResult.class);
    private static final String INTERNAL_UNBAKED_CONTEXT = Type.getInternalName(IUnbakedContext.class);
    private static final String INTERNAL_BAKED_CONTEXT = Type.getInternalName(IContext.class);
    private static final Type ID_CALL_SIG = Type.getType((String)"()Ljava/lang/Object;");
    private static final Type ID_CALL_SPECIAL_SIG = Type.getType((String)"()Lorg/squiddev/plethora/api/method/MethodResult;");
    private static final Handle ID_HANDLE = new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false);
    private static final int IDX_CTX = 1;
    private static final int IDX_ARG = 2;
    private static final AtomicInteger METHOD_ID = new AtomicInteger();

    private MethodClassLoader() {
        super(MethodClassLoader.class.getClassLoader());
    }

    <T> IMethod.Delegate<T> build(MethodInstance method) {
        try {
            Class<?> klass = this.writeClass(method);
            if (klass == null) {
                throw BadWrapperException.INSTANCE;
            }
            return klass.asSubclass(IMethod.Delegate.class).newInstance();
        }
        catch (BadWrapperException e) {
            throw e;
        }
        catch (ClassFormatError | ReflectiveOperationException | RuntimeException e) {
            PlethoraCore.LOG.error("Error generating wrapper for {}.{}", (Object)method.method.getDeclaringClass().getName(), (Object)method.method.getName(), (Object)e);
            throw BadWrapperException.INSTANCE;
        }
    }

    @Nullable
    private Class<?> writeClass(MethodInstance<?, ?> methodInstance) {
        Method method = methodInstance.method;
        Parameter[] parameters = method.getParameters();
        String className = method.getDeclaringClass().getName() + "$" + method.getName() + METHOD_ID.getAndIncrement();
        String internalName = className.replace(".", "/");
        ClassWriter cw = new ClassWriter(3);
        cw.visit(52, 17, internalName, null, INTERNAL_OBJECT, new String[]{INTERNAL_DELEGATE});
        cw.visitSource("Plethora generated method", null);
        StringBuilder runDescBuilder = new StringBuilder();
        runDescBuilder.append("(L");
        runDescBuilder.append(INTERNAL_UNBAKED_CONTEXT);
        runDescBuilder.append(";");
        for (int i = methodInstance.totalContext; i < parameters.length; ++i) {
            runDescBuilder.append(Type.getDescriptor(parameters[i].getType()));
        }
        String runDescPre = runDescBuilder.append(")L").toString();
        MethodVisitor mw = cw.visitMethod(1, "<init>", "()V", null, null);
        mw.visitCode();
        mw.visitVarInsn(25, 0);
        mw.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mw.visitInsn(177);
        mw.visitMaxs(0, 0);
        mw.visitEnd();
        String runDesc = runDescPre + INTERNAL_METHOD_RESULT + ";";
        MethodVisitor mw2 = cw.visitMethod(1, "apply", "(Lorg/squiddev/plethora/api/method/IUnbakedContext;[Ljava/lang/Object;)Lorg/squiddev/plethora/api/method/MethodResult;", null, null);
        mw2.visitCode();
        mw2.visitVarInsn(25, 1);
        if (methodInstance.totalContext == parameters.length - 1 && parameters[parameters.length - 1].getType() == Object[].class) {
            mw2.visitVarInsn(25, 2);
        } else {
            boolean argsOk = true;
            int luaIndex = 0;
            int i = methodInstance.totalContext;
            while (i < parameters.length) {
                Parameter parameter = parameters[i];
                if (!MethodClassLoader.loadLuaArg(mw2, luaIndex, parameter)) {
                    argsOk = false;
                }
                ++i;
                ++luaIndex;
            }
            if (!argsOk) {
                return null;
            }
        }
        if (methodInstance.worldThread) {
            String runDescDynamic = runDescPre + "java/util/concurrent/Callable;";
            mw2.visitInvokeDynamicInsn("call", runDescDynamic, ID_HANDLE, new Object[]{ID_CALL_SIG, new Handle(6, internalName, "run", runDesc, false), ID_CALL_SPECIAL_SIG});
            mw2.visitMethodInsn(184, INTERNAL_METHOD_RESULT, "nextTick", "(Ljava/util/concurrent/Callable;)L" + INTERNAL_METHOD_RESULT + ";", false);
        } else {
            mw2.visitMethodInsn(184, internalName, "run", runDesc, false);
        }
        mw2.visitInsn(176);
        mw2.visitMaxs(0, 0);
        mw2.visitEnd();
        mw2 = cw.visitMethod(10, "run", runDesc, null, null);
        mw2.visitCode();
        mw2.visitVarInsn(25, 0);
        mw2.visitMethodInsn(185, INTERNAL_UNBAKED_CONTEXT, methodInstance.worldThread ? "bake" : "safeBake", "()L" + INTERNAL_BAKED_CONTEXT + ";", true);
        mw2.visitVarInsn(58, 0);
        for (int i = 0; i < methodInstance.totalContext; ++i) {
            MethodClassLoader.loadContextArg(mw2, methodInstance, parameters[i]);
        }
        int varIndex = 1;
        for (int i = methodInstance.totalContext; i < parameters.length; ++i) {
            varIndex += ClassWriterHelpers.loadVar(mw2, parameters[i].getType(), varIndex);
        }
        mw2.visitMethodInsn(184, Type.getInternalName(method.getDeclaringClass()), method.getName(), Type.getMethodDescriptor((Method)method), false);
        Class<?> ret = method.getReturnType();
        if (ret != MethodResult.class) {
            if (ret == Void.TYPE) {
                mw2.visitMethodInsn(184, INTERNAL_METHOD_RESULT, "empty", "()L" + INTERNAL_METHOD_RESULT + ";", false);
            } else if (ret.isPrimitive()) {
                Class boxed = Primitives.wrap(ret);
                mw2.visitMethodInsn(184, Type.getInternalName((Class)boxed), "valueOf", "(" + Type.getDescriptor(ret) + ")" + Type.getDescriptor((Class)boxed), false);
                mw2.visitMethodInsn(184, INTERNAL_METHOD_RESULT, "result", "(Ljava/lang/Object;)L" + INTERNAL_METHOD_RESULT + ";", false);
            } else if (ret == Object[].class) {
                mw2.visitMethodInsn(184, INTERNAL_METHOD_RESULT, "result", "([Ljava/lang/Object;)L" + INTERNAL_METHOD_RESULT + ";", false);
            } else {
                mw2.visitMethodInsn(184, INTERNAL_METHOD_RESULT, "result", "(Ljava/lang/Object;)L" + INTERNAL_METHOD_RESULT + ";", false);
            }
        }
        mw2.visitInsn(176);
        mw2.visitMaxs(0, 0);
        mw2.visitEnd();
        cw.visitEnd();
        byte[] result = cw.toByteArray();
        ClassWriterHelpers.validateClass(result, (ClassLoader)this);
        return this.defineClass(className, result, 0, result.length, method.getClass().getProtectionDomain());
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean loadLuaArg(MethodVisitor mw, int index, Parameter parameter) {
        Class<?> argument = parameter.getType();
        if (argument.isPrimitive()) {
            mw.visitVarInsn(25, 2);
            ClassWriterHelpers.loadInt(mw, index);
            Optional def = parameter.getAnnotation(Optional.class);
            if (argument == Integer.TYPE || argument == Short.TYPE || argument == Character.TYPE || argument == Byte.TYPE) {
                if (def == null) {
                    MethodClassLoader.visitGet(mw, "Int", "I");
                    return true;
                }
                ClassWriterHelpers.loadInt(mw, def.defInt());
                MethodClassLoader.visitOpt(mw, "Int", "I");
                return true;
            }
            if (argument == Boolean.TYPE) {
                if (def == null) {
                    MethodClassLoader.visitGet(mw, "Boolean", "Z");
                    return true;
                }
                ClassWriterHelpers.loadInt(mw, def.defBool() ? 1 : 0);
                MethodClassLoader.visitOpt(mw, "Boolean", "Z");
                return true;
            }
            if (argument == Long.TYPE) {
                if (def == null) {
                    MethodClassLoader.visitGet(mw, "Long", "J");
                    return true;
                }
                ClassWriterHelpers.loadLong(mw, def.defLong());
                MethodClassLoader.visitOpt(mw, "Long", "J");
                return true;
            }
            if (argument == Double.TYPE) {
                if (def == null) {
                    MethodClassLoader.visitGet(mw, "Real", "D");
                    return true;
                }
                ClassWriterHelpers.loadDouble(mw, def.defDoub());
                MethodClassLoader.visitOpt(mw, "Real", "D");
                return true;
            }
            if (argument != Float.TYPE) {
                Executable method = parameter.getDeclaringExecutable();
                PlethoraCore.LOG.error("Argument {} for @PlethoraMethod {}.{} has an unknown primitive type {}.", (Object)parameter.getName(), (Object)method.getDeclaringClass().getName(), (Object)method.getName(), argument);
                return false;
            }
            if (def == null) {
                mw.visitMethodInsn(184, INTERNAL_ARGUMENT_HELPER_II, "getFloat", "([Ljava/lang/Object;I)F", false);
                return true;
            }
            ClassWriterHelpers.loadFloat(mw, (float)def.defDoub());
            mw.visitMethodInsn(184, INTERNAL_ARGUMENT_HELPER_II, "optFloat", "([Ljava/lang/Object;IF)F", false);
            return true;
        }
        if (Enum.class.isAssignableFrom(argument) && argument != Enum.class) {
            mw.visitVarInsn(25, 2);
            ClassWriterHelpers.loadInt(mw, index);
            mw.visitLdcInsn((Object)Type.getType(argument));
            if (parameter.getAnnotation(Optional.class) == null) {
                mw.visitMethodInsn(184, INTERNAL_ARGUMENT_HELPER_II, "getEnum", "([Ljava/lang/Object;ILjava/lang/Class;)Ljava/lang/Enum;", false);
            } else {
                mw.visitInsn(1);
                mw.visitMethodInsn(184, INTERNAL_ARGUMENT_HELPER_II, "optEnum", "([Ljava/lang/Object;ILjava/lang/Class;Ljava/lang/Enum;)Ljava/lang/Enum;", false);
            }
            mw.visitTypeInsn(192, Type.getInternalName(argument));
            return true;
        }
        Field field = ArgumentTypeRegistry.getField(argument);
        if (field == null) {
            Executable method = parameter.getDeclaringExecutable();
            PlethoraCore.LOG.error("Argument {} for @PlethoraMethod {}.{} has no obvious converter for {}.", (Object)parameter.getName(), (Object)method.getDeclaringClass().getName(), (Object)method.getName(), argument);
            return false;
        }
        mw.visitFieldInsn(178, Type.getInternalName(field.getDeclaringClass()), field.getName(), Type.getDescriptor(field.getType()));
        mw.visitVarInsn(25, 2);
        ClassWriterHelpers.loadInt(mw, index);
        mw.visitMethodInsn(185, INTERNAL_ARGUMENT_TYPE, parameter.getAnnotation(Optional.class) == null ? "get" : "opt", "([Ljava/lang/Object;I)Ljava/lang/Object;", true);
        mw.visitTypeInsn(192, Type.getInternalName(argument));
        return true;
    }

    private static void loadContextArg(MethodVisitor mw, MethodInstance method, Parameter parameter) {
        if (parameter.getType() == IContext.class || parameter.getType() == IPartialContext.class) {
            mw.visitVarInsn(25, 0);
            return;
        }
        FromTarget target = parameter.getAnnotation(FromTarget.class);
        if (target != null) {
            mw.visitVarInsn(25, 0);
            mw.visitMethodInsn(185, INTERNAL_BAKED_CONTEXT, "getTarget", "()Ljava/lang/Object;", true);
            mw.visitTypeInsn(192, Type.getInternalName(parameter.getType()));
            return;
        }
        FromSubtarget subTarget = parameter.getAnnotation(FromSubtarget.class);
        if (subTarget != null) {
            String[] names = subTarget.value();
            if (names.length == 0) {
                Label success = new Label();
                MethodClassLoader.visitGetContext(mw, "origin", parameter.getType());
                for (ResourceLocation name : method.modules) {
                    mw.visitInsn(89);
                    mw.visitJumpInsn(199, success);
                    mw.visitInsn(87);
                    MethodClassLoader.visitGetContext(mw, name.toString(), parameter.getType());
                }
                mw.visitLabel(success);
            } else {
                MethodClassLoader.visitGetContext(mw, names, parameter.getType());
            }
            return;
        }
        FromContext context = parameter.getAnnotation(FromContext.class);
        if (context != null) {
            String[] names = context.value();
            if (names.length == 0 || names.length == 1 && Strings.isNullOrEmpty((String)names[0])) {
                mw.visitVarInsn(25, 0);
                mw.visitLdcInsn((Object)Type.getType(parameter.getType()));
                mw.visitMethodInsn(185, INTERNAL_BAKED_CONTEXT, "getContext", "(Ljava/lang/Class;)Ljava/lang/Object;", true);
                mw.visitTypeInsn(192, Type.getInternalName(parameter.getType()));
            } else {
                MethodClassLoader.visitGetContext(mw, names, parameter.getType());
            }
            return;
        }
        throw new IllegalStateException("Fallthrough in annotation checks.");
    }

    private static void visitGet(MethodVisitor visitor, String name, String type) {
        visitor.visitMethodInsn(184, INTERNAL_ARGUMENT_HELPER, "get" + name, "([Ljava/lang/Object;I)" + type, false);
    }

    private static void visitOpt(MethodVisitor visitor, String name, String type) {
        visitor.visitMethodInsn(184, INTERNAL_ARGUMENT_HELPER, "opt" + name, "([Ljava/lang/Object;I" + type + ")" + type, false);
    }

    private static void visitGetContext(MethodVisitor mw, String key, Class<?> type) {
        mw.visitVarInsn(25, 0);
        mw.visitLdcInsn((Object)key);
        mw.visitLdcInsn((Object)Type.getType(type));
        mw.visitMethodInsn(185, INTERNAL_BAKED_CONTEXT, "getContext", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", true);
        mw.visitTypeInsn(192, Type.getInternalName(type));
    }

    private static void visitGetContext(MethodVisitor mw, String[] keys, Class<?> type) {
        Label success = new Label();
        for (int i = 0; i < keys.length; ++i) {
            if (i > 0) {
                mw.visitInsn(89);
                mw.visitJumpInsn(199, success);
                mw.visitInsn(87);
            }
            MethodClassLoader.visitGetContext(mw, keys[i], type);
        }
    }
}

