/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.ArgumentHelper;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.squiddev.plethora.integration.vanilla.meta.MetaItemBasic;

public class ItemFingerprint {
    @Nonnull
    public final Item item;
    public final int damage;
    @Nullable
    public final String hash;

    public ItemFingerprint(@Nonnull Item item, int damage, @Nullable String hash) {
        this.item = item;
        this.damage = damage;
        this.hash = hash;
    }

    public boolean matches(ItemStack stack) {
        if (stack.func_77973_b() != this.item) {
            return false;
        }
        if (this.damage != Short.MAX_VALUE && this.damage != stack.func_77952_i()) {
            return false;
        }
        return this.hash == null || this.hash.equals(MetaItemBasic.getNBTHash(stack));
    }

    @Nonnull
    public static ItemFingerprint fromLua(@Nonnull Object[] args, int index) throws LuaException {
        String hash;
        Integer damage;
        String name;
        Object arg;
        Object object = arg = index >= args.length ? null : args[index];
        if (arg instanceof String) {
            String contents = (String)arg;
            int atIdx = contents.lastIndexOf(64);
            if (atIdx < 0) {
                name = contents;
                damage = null;
            } else {
                name = contents.substring(0, atIdx);
                try {
                    damage = Integer.parseInt(contents.substring(atIdx + 1));
                }
                catch (NumberFormatException e) {
                    throw new LuaException("Cannot convert damage to item: " + e.getMessage());
                }
            }
            hash = null;
        } else if (arg instanceof Map) {
            Object hashObj;
            Map data = (Map)arg;
            Object nameObj = data.get("name");
            if (!(nameObj instanceof String)) {
                throw org.squiddev.plethora.api.method.ArgumentHelper.badObjectType("name", "string", nameObj);
            }
            Object damageObj = data.get("damage");
            if (damageObj != null) {
                if (!(damageObj instanceof Number)) {
                    throw org.squiddev.plethora.api.method.ArgumentHelper.badObjectType("damage", "number", damageObj);
                }
                if (!Double.isFinite(((Number)damageObj).doubleValue())) {
                    throw org.squiddev.plethora.api.method.ArgumentHelper.badObject("damage", "number", org.squiddev.plethora.api.method.ArgumentHelper.numberType(((Number)damageObj).doubleValue()));
                }
            }
            if ((hashObj = data.get("nbthash")) != null && !(hashObj instanceof String)) {
                throw org.squiddev.plethora.api.method.ArgumentHelper.badObjectType("nbthash", "string", hashObj);
            }
            name = (String)nameObj;
            damage = damageObj == null ? null : Integer.valueOf(((Number)damageObj).intValue());
            hash = hashObj == null ? null : (String)hashObj;
        } else {
            throw ArgumentHelper.badArgument((int)index, (String)"string or table", (Object)arg);
        }
        ResourceLocation nameRes = new ResourceLocation(name);
        if (!ForgeRegistries.ITEMS.containsKey(nameRes)) {
            throw new LuaException("No such item '" + name + "'");
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(nameRes);
        return new ItemFingerprint(item, damage == null ? Short.MAX_VALUE : damage, hash);
    }
}

