/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.forestry;

import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import forestry.apiculture.genetics.BeeDefinition;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.BaseMetaProvider;
import org.squiddev.plethora.api.method.IPartialContext;

@Injects(value="forestry")
public final class MetaItemGenetic
extends BaseMetaProvider<ItemStack> {
    @Override
    @Nonnull
    public Map<String, ?> getMeta(@Nonnull IPartialContext<ItemStack> context) {
        ItemStack stack = context.getTarget();
        IIndividual individual = AlleleManager.alleleRegistry.getIndividual(stack);
        return individual != null ? Collections.singletonMap("individual", context.makePartialChild(individual).getMeta()) : Collections.emptyMap();
    }

    @Override
    @Nonnull
    public ItemStack getExample() {
        IBee individual = BeeDefinition.FOREST.getIndividual();
        individual.analyze();
        return BeeDefinition.FOREST.getGenome().getSpeciesRoot().getMemberStack((IIndividual)individual, (ISpeciesType)EnumBeeType.PRINCESS);
    }
}

