/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla.meta;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.BannerPattern;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.ItemStackMetaProvider;
import org.squiddev.plethora.api.method.LuaList;
import org.squiddev.plethora.utils.TypedField;

@Injects
public final class MetaItemBanner
extends ItemStackMetaProvider<ItemBanner> {
    private static final TypedField<BannerPattern, String> FIELD_NAME = TypedField.of(BannerPattern.class, "fileName", "field_191014_N");

    public MetaItemBanner() {
        super(ItemBanner.class);
    }

    @Override
    @Nonnull
    public Map<String, ?> getMeta(@Nonnull ItemStack stack, @Nonnull ItemBanner banner) {
        LuaList out = new LuaList();
        NBTTagCompound tag = stack.func_179543_a("BlockEntityTag");
        if (tag != null && tag.func_74764_b("Patterns")) {
            NBTTagList nbttaglist = tag.func_150295_c("Patterns", 10);
            for (int i = 0; i < nbttaglist.func_74745_c() && i < 6; ++i) {
                NBTTagCompound patternTag = nbttaglist.func_150305_b(i);
                EnumDyeColor color = EnumDyeColor.func_176766_a((int)patternTag.func_74762_e("Color"));
                BannerPattern pattern = MetaItemBanner.getPatternByID(patternTag.func_74779_i("Pattern"));
                if (pattern == null) continue;
                HashMap<String, String> entry = new HashMap<String, String>();
                entry.put("id", pattern.func_190993_b());
                entry.put("name", FIELD_NAME.get(pattern));
                entry.put("colour", color.toString());
                entry.put("color", color.toString());
                out.add(entry);
            }
        }
        return Collections.singletonMap("banner", out.asMap());
    }

    @Override
    @Nonnull
    public ItemStack getExample() {
        NBTTagList patterns = new NBTTagList();
        NBTTagCompound pattern1 = new NBTTagCompound();
        pattern1.func_74778_a("Pattern", BannerPattern.CREEPER.func_190993_b());
        pattern1.func_74768_a("Color", 5);
        patterns.func_74742_a((NBTBase)pattern1);
        return ItemBanner.func_190910_a((EnumDyeColor)EnumDyeColor.GREEN, (NBTTagList)patterns);
    }

    private static BannerPattern getPatternByID(String id) {
        for (BannerPattern pattern : BannerPattern.values()) {
            if (!pattern.func_190993_b().equals(id)) continue;
            return pattern;
        }
        return null;
    }
}

