/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour.upgrade;

import WayofTime.bloodmagic.livingArmour.ILivingArmour;
import WayofTime.bloodmagic.livingArmour.LivingArmourUpgrade;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class LivingArmourUpgradeRepairing
extends LivingArmourUpgrade {
    public static final int[] costs = new int[]{15};
    public static final int[] repairDelay = new int[]{200};
    int maxRepair = 1;
    int delay = 0;

    public LivingArmourUpgradeRepairing(int level) {
        super(level);
    }

    @Override
    public void onTick(World world, EntityPlayer player, ILivingArmour livingArmour) {
        if (this.delay <= 0) {
            int toRepair;
            this.delay = repairDelay[this.level];
            EntityEquipmentSlot randomSlot = EntityEquipmentSlot.values()[2 + world.field_73012_v.nextInt(4)];
            ItemStack repairStack = player.func_184582_a(randomSlot);
            if (!repairStack.func_190926_b() && repairStack.func_77984_f() && repairStack.func_77951_h() && (toRepair = Math.min(this.maxRepair, repairStack.func_77952_i())) > 0) {
                repairStack.func_77964_b(repairStack.func_77952_i() - toRepair);
            }
        } else {
            --this.delay;
        }
    }

    @Override
    public String getUniqueIdentifier() {
        return "bloodmagic.upgrade.repair";
    }

    @Override
    public int getMaxTier() {
        return 1;
    }

    @Override
    public int getCostOfUpgrade() {
        return costs[this.level];
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("repairingDelay", this.delay);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.delay = tag.func_74762_e("repairingDelay");
    }

    @Override
    public String getTranslationKey() {
        return tooltipBase + "repair";
    }
}

