/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.imperfect;

import WayofTime.bloodmagic.ritual.imperfect.IImperfectRitualStone;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;

public abstract class ImperfectRitual {
    private final String name;
    private final Predicate<IBlockState> blockRequirement;
    private final int activationCost;
    private final boolean lightShow;
    private final String unlocalizedName;

    public ImperfectRitual(String name, Predicate<IBlockState> blockRequirement, int activationCost, boolean lightShow, String unlocalizedName) {
        this.name = name;
        this.blockRequirement = blockRequirement;
        this.activationCost = activationCost;
        this.lightShow = lightShow;
        this.unlocalizedName = unlocalizedName;
    }

    public ImperfectRitual(String name, Predicate<IBlockState> blockRequirement, int activationCost, String unlocalizedName) {
        this(name, blockRequirement, activationCost, false, unlocalizedName);
    }

    public abstract boolean onActivate(IImperfectRitualStone var1, EntityPlayer var2);

    public String getName() {
        return this.name;
    }

    public Predicate<IBlockState> getBlockRequirement() {
        return this.blockRequirement;
    }

    public int getActivationCost() {
        return this.activationCost;
    }

    public boolean isLightShow() {
        return this.lightShow;
    }

    public String getTranslationKey() {
        return this.unlocalizedName;
    }

    public String toString() {
        return this.getName() + "@" + this.getActivationCost();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImperfectRitual)) {
            return false;
        }
        ImperfectRitual that = (ImperfectRitual)o;
        if (this.activationCost != that.activationCost) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.unlocalizedName != null ? this.unlocalizedName.equals(that.unlocalizedName) : that.unlocalizedName == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.activationCost;
        result = 31 * result + (this.unlocalizedName != null ? this.unlocalizedName.hashCode() : 0);
        return result;
    }
}

