/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.rebornstorage.tiles;

import javax.annotation.Nullable;
import me.modmuss50.rebornstorage.multiblocks.MultiBlockCrafter;
import me.modmuss50.rebornstorage.tiles.CraftingNode;
import me.modmuss50.rebornstorage.tiles.TileMultiCrafter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileIoPort
extends TileMultiCrafter
implements IItemHandler {
    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getVarient().equals("io");
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    private Slot getFirstAvailable() {
        MultiBlockCrafter multiBlock = this.getMultiBlock();
        if (multiBlock == null || !multiBlock.isAssembled()) {
            return null;
        }
        for (int i = 1; i <= multiBlock.pages; ++i) {
            CraftingNode.CachingItemHandler inv = multiBlock.getInvForPage(i);
            if (inv.isFull()) continue;
            return new Slot((IItemHandler)inv, inv.getFirstAvailable());
        }
        return null;
    }

    private Slot getLastUsed() {
        MultiBlockCrafter multiBlock = this.getMultiBlock();
        if (multiBlock == null || !multiBlock.isAssembled()) {
            return null;
        }
        for (int i = multiBlock.pages; i >= 1; --i) {
            CraftingNode.CachingItemHandler inv = multiBlock.getInvForPage(i);
            if (inv.isEmpty()) continue;
            return new Slot((IItemHandler)inv, inv.getLastUsed());
        }
        return null;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot != 1) {
            return ItemStack.field_190927_a;
        }
        Slot lastUsed = this.getLastUsed();
        return lastUsed == null ? ItemStack.field_190927_a : lastUsed.extractItem(amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public int getSlots() {
        return 2;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot != 1) {
            return ItemStack.field_190927_a;
        }
        Slot lastUsed = this.getLastUsed();
        return lastUsed == null ? ItemStack.field_190927_a : lastUsed.getStack();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot != 0) {
            return stack;
        }
        Slot firstAvailable = this.getFirstAvailable();
        return firstAvailable == null ? stack : firstAvailable.insertItem(stack, simulate);
    }

    private class Slot {
        private IItemHandler inv;
        private int slot;

        Slot(IItemHandler inv, int slot) {
            this.inv = inv;
            this.slot = slot;
        }

        public ItemStack extractItem(int amount, boolean simulate) {
            return this.inv.extractItem(this.slot, amount, simulate);
        }

        public ItemStack getStack() {
            return this.inv.getStackInSlot(this.slot);
        }

        public ItemStack insertItem(ItemStack stack, boolean simulate) {
            return this.inv.insertItem(this.slot, stack, simulate);
        }
    }
}

