/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.awt.Point;
import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.GuiButtonSpecial;
import me.desht.pneumaticcraft.client.gui.GuiInventorySearcher;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.GuiSearcher;
import me.desht.pneumaticcraft.client.gui.semiblock.GuiLogisticsLiquidFilter;
import me.desht.pneumaticcraft.client.gui.widget.IGuiWidget;
import me.desht.pneumaticcraft.client.gui.widget.WidgetFluidFilter;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.common.inventory.ContainerAmadronAddTrade;
import me.desht.pneumaticcraft.common.item.ItemAmadronTablet;
import me.desht.pneumaticcraft.common.item.ItemGPSTool;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeAddCustom;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeAddPeriodic;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeAddStatic;
import me.desht.pneumaticcraft.common.recipes.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.AmadronOfferCustom;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.apache.commons.lang3.text.WordUtils;

public class GuiAmadronAddTrade
extends GuiPneumaticContainerBase {
    private GuiSearcher searchGui;
    private GuiInventorySearcher invSearchGui;
    private GuiInventorySearcher gpsSearchGui;
    private GuiLogisticsLiquidFilter fluidGui;
    private boolean isSettingInput;
    private WidgetFluidFilter inputFluid;
    private WidgetFluidFilter outputFluid;
    private WidgetTextFieldNumber inputNumber;
    private WidgetTextFieldNumber outputNumber;
    private GuiButton addButton;
    private BlockPos inputPosition;
    private BlockPos outputPosition;
    private final AmadronOffer.TradeType tradeType;

    public GuiAmadronAddTrade(AmadronOffer.TradeType tradeType) {
        super(new ContainerAmadronAddTrade(), null, "pneumaticcraft:textures/gui/gui_widget_options.png");
        this.tradeType = tradeType;
        this.field_146999_f = 183;
        this.field_147000_g = 202;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        ContainerAmadronAddTrade container = (ContainerAmadronAddTrade)this.field_147002_h;
        this.addLabel(I18n.func_135052_a((String)"gui.amadron.addTrade.selling", (Object[])new Object[0]), this.field_147003_i + 4, this.field_147009_r + 5, -1);
        this.addLabel(I18n.func_135052_a((String)"gui.amadron.addTrade.buying", (Object[])new Object[0]), this.field_147003_i + 93, this.field_147009_r + 5, -1);
        this.field_146292_n.add(new GuiButton(0, this.field_147003_i + 4, this.field_147009_r + 20, 85, 20, "Search item..."));
        this.field_146292_n.add(new GuiButton(1, this.field_147003_i + 4, this.field_147009_r + 42, 85, 20, "Search inv..."));
        this.field_146292_n.add(new GuiButton(2, this.field_147003_i + 4, this.field_147009_r + 64, 85, 20, "Search fluid..."));
        this.field_146292_n.add(new GuiButton(3, this.field_147003_i + 93, this.field_147009_r + 20, 85, 20, "Search item..."));
        this.field_146292_n.add(new GuiButton(4, this.field_147003_i + 93, this.field_147009_r + 42, 85, 20, "Search inv..."));
        this.field_146292_n.add(new GuiButton(5, this.field_147003_i + 93, this.field_147009_r + 64, 85, 20, "Search fluid..."));
        this.addButton = new GuiButton(8, this.field_147003_i + 50, this.field_147009_r + 164, 85, 20, "Add Trade");
        this.field_146292_n.add(this.addButton);
        Fluid oldInputFluid = this.inputFluid != null ? this.inputFluid.getFluid() : null;
        Fluid oldOutputFluid = this.outputFluid != null ? this.outputFluid.getFluid() : null;
        this.inputFluid = new WidgetFluidFilter(-1, this.field_147003_i + 10, this.field_147009_r + 90);
        this.outputFluid = new WidgetFluidFilter(-1, this.field_147003_i + 99, this.field_147009_r + 90);
        this.inputFluid.setFluid(oldInputFluid);
        this.outputFluid.setFluid(oldOutputFluid);
        this.addWidget(this.inputFluid);
        this.addWidget(this.outputFluid);
        if (this.tradeType == AmadronOffer.TradeType.PLAYER) {
            GuiButtonSpecial gpsButton1 = new GuiButtonSpecial(6, this.field_147003_i + 10, this.field_147009_r + 115, 20, 20, "");
            GuiButtonSpecial gpsButton2 = new GuiButtonSpecial(7, this.field_147003_i + 99, this.field_147009_r + 115, 20, 20, "");
            gpsButton1.setTooltipText(Arrays.asList(WordUtils.wrap((String)I18n.func_135052_a((String)"gui.amadron.button.selectSellingBlock.tooltip", (Object[])new Object[0]), (int)40).split(System.getProperty("line.separator"))));
            gpsButton2.setTooltipText(Arrays.asList(WordUtils.wrap((String)I18n.func_135052_a((String)"gui.amadron.button.selectPaymentBlock.tooltip", (Object[])new Object[0]), (int)40).split(System.getProperty("line.separator"))));
            gpsButton1.setRenderStacks(new ItemStack(Itemss.GPS_TOOL));
            gpsButton2.setRenderStacks(new ItemStack(Itemss.GPS_TOOL));
            this.addWidget(gpsButton1);
            this.addWidget(gpsButton2);
        }
        this.inputNumber = new WidgetTextFieldNumber(this.field_146289_q, this.field_147003_i + 6, this.field_147009_r + 145, 40, this.field_146289_q.field_78288_b).setValue(this.inputNumber != null ? (double)this.inputNumber.getValue() : 0.0);
        this.outputNumber = new WidgetTextFieldNumber(this.field_146289_q, this.field_147003_i + 95, this.field_147009_r + 145, 40, this.field_146289_q.field_78288_b).setValue(this.outputNumber != null ? (double)this.outputNumber.getValue() : 0.0);
        this.inputNumber.setTooltip(I18n.func_135052_a((String)"gui.amadron.addTrade.itemFluidAmount", (Object[])new Object[0]));
        this.outputNumber.setTooltip(I18n.func_135052_a((String)"gui.amadron.addTrade.itemFluidAmount", (Object[])new Object[0]));
        this.addWidget(this.inputNumber);
        this.addWidget(this.outputNumber);
        if (this.searchGui != null) {
            if (this.isSettingInput) {
                this.inputFluid.setFluid(null);
                container.setStack(0, this.searchGui.getSearchStack());
            } else {
                this.outputFluid.setFluid(null);
                container.setStack(1, this.searchGui.getSearchStack());
            }
        }
        if (this.invSearchGui != null) {
            if (this.isSettingInput) {
                this.inputFluid.setFluid(null);
                container.setStack(0, this.invSearchGui.getSearchStack());
            } else {
                this.outputFluid.setFluid(null);
                container.setStack(1, this.invSearchGui.getSearchStack());
            }
        }
        if (this.fluidGui != null) {
            if (this.isSettingInput) {
                container.setStack(0, ItemStack.field_190927_a);
                this.inputFluid.setFluid(this.fluidGui.getFilter());
            } else {
                container.setStack(1, ItemStack.field_190927_a);
                this.outputFluid.setFluid(this.fluidGui.getFilter());
            }
        }
        if (this.gpsSearchGui != null) {
            if (this.isSettingInput) {
                this.inputPosition = this.gpsSearchGui.getSearchStack().func_190926_b() ? null : ItemGPSTool.getGPSLocation(this.gpsSearchGui.getSearchStack());
            } else {
                this.outputPosition = this.gpsSearchGui.getSearchStack().func_190926_b() ? null : ItemGPSTool.getGPSLocation(this.gpsSearchGui.getSearchStack());
            }
        }
        this.searchGui = null;
        this.fluidGui = null;
        this.invSearchGui = null;
        this.gpsSearchGui = null;
        WidgetLabel inputNumberLabel = new WidgetLabel(this.field_147003_i + 52, this.field_147009_r + 145, container.getInputStack().func_190926_b() ? (this.inputFluid.getFluid() != null ? "mB" : "") : "x", -1);
        WidgetLabel outputNumberLabel = new WidgetLabel(this.field_147003_i + 149, this.field_147009_r + 145, container.getOutputStack().func_190926_b() ? (this.outputFluid.getFluid() != null ? "mB" : "") : "x", -1);
        this.addWidget(inputNumberLabel);
        this.addWidget(outputNumberLabel);
    }

    @Override
    protected int getBackgroundTint() {
        return 429612;
    }

    @Override
    public void func_146284_a(GuiButton button) {
        EntityPlayerSP player = FMLClientHandler.instance().getClient().field_71439_g;
        ContainerAmadronAddTrade container = (ContainerAmadronAddTrade)this.field_147002_h;
        if (button.field_146127_k < 6 && button.field_146127_k >= 0) {
            boolean bl = this.isSettingInput = button.field_146127_k < 3;
            if (button.field_146127_k % 3 == 0) {
                this.searchGui = new GuiSearcher((EntityPlayer)player);
                this.searchGui.setSearchStack(this.isSettingInput ? container.getInputStack() : container.getOutputStack());
                FMLClientHandler.instance().showGuiScreen((Object)this.searchGui);
            } else if (button.field_146127_k % 3 == 1) {
                this.invSearchGui = new GuiInventorySearcher((EntityPlayer)player);
                this.invSearchGui.setSearchStack(this.isSettingInput ? container.getInputStack() : container.getOutputStack());
                FMLClientHandler.instance().showGuiScreen((Object)this.invSearchGui);
            } else if (button.field_146127_k % 3 == 2) {
                this.fluidGui = new GuiLogisticsLiquidFilter((GuiScreen)this);
                this.fluidGui.setFilter(this.isSettingInput ? this.inputFluid.getFluid() : this.outputFluid.getFluid());
                FMLClientHandler.instance().showGuiScreen((Object)this.fluidGui);
            }
        } else if (button.field_146127_k == 8) {
            ItemStack output;
            ItemStack input;
            if (!container.getInputStack().func_190926_b()) {
                input = container.getInputStack().func_77946_l();
                input.func_190920_e(this.inputNumber.getValue());
            } else {
                input = new FluidStack(this.inputFluid.getFluid(), this.inputNumber.getValue());
            }
            if (!container.getOutputStack().func_190926_b()) {
                output = container.getOutputStack().func_77946_l();
                output.func_190920_e(this.outputNumber.getValue());
            } else {
                output = new FluidStack(this.outputFluid.getFluid(), this.outputNumber.getValue());
            }
            if (this.tradeType == AmadronOffer.TradeType.PLAYER) {
                AmadronOfferCustom trade = new AmadronOfferCustom((Object)input, (Object)output, (EntityPlayer)player);
                BlockPos pos = this.getPosition(0);
                int dimensionId = this.getDimension(0);
                trade.setProvidingPosition(pos, dimensionId);
                pos = this.getPosition(1);
                dimensionId = this.getDimension(1);
                trade.setReturningPosition(pos, dimensionId);
                NetworkHandler.sendToServer(new PacketAmadronTradeAddCustom(trade.invert()));
            } else if (this.tradeType == AmadronOffer.TradeType.PERIODIC) {
                AmadronOffer trade = new AmadronOffer(input, output);
                NetworkHandler.sendToServer(new PacketAmadronTradeAddPeriodic(trade));
            } else if (this.tradeType == AmadronOffer.TradeType.STATIC) {
                AmadronOffer trade = new AmadronOffer(input, output);
                NetworkHandler.sendToServer(new PacketAmadronTradeAddStatic(trade));
            }
            player.func_71053_j();
        }
        super.func_146284_a(button);
    }

    @Override
    public void actionPerformed(IGuiWidget widget) {
        if (widget.getID() == 6 || widget.getID() == 7) {
            this.gpsSearchGui = new GuiInventorySearcher((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
            this.gpsSearchGui.setStackPredicate(itemStack -> itemStack.func_77973_b() instanceof IPositionProvider);
            this.isSettingInput = widget.getID() == 6;
            ItemStack gps = new ItemStack(Itemss.GPS_TOOL);
            BlockPos pos = widget.getID() == 6 ? this.getPosition(0) : this.getPosition(1);
            if (pos != null) {
                ItemGPSTool.setGPSLocation(gps, pos);
            }
            this.gpsSearchGui.setSearchStack(ItemGPSTool.getGPSLocation(gps) != null ? gps : ItemStack.field_190927_a);
            FMLClientHandler.instance().showGuiScreen((Object)this.gpsSearchGui);
        }
        super.actionPerformed(widget);
    }

    private BlockPos getPosition(int slot) {
        if (slot == 0) {
            if (this.inputPosition != null) {
                return this.inputPosition;
            }
        } else if (slot == 1 && this.outputPosition != null) {
            return this.outputPosition;
        }
        EntityPlayerSP player = FMLClientHandler.instance().getClient().field_71439_g;
        if (((ContainerAmadronAddTrade)this.field_147002_h).getStack(slot).func_190926_b()) {
            return ItemAmadronTablet.getLiquidProvidingLocation(player.func_184614_ca());
        }
        return ItemAmadronTablet.getItemProvidingLocation(player.func_184614_ca());
    }

    private int getDimension(int slot) {
        EntityPlayerSP player = FMLClientHandler.instance().getClient().field_71439_g;
        if (slot == 0 ? this.inputPosition != null : slot == 1 && this.outputPosition != null) {
            return player.field_70170_p.field_73011_w.getDimension();
        }
        if (((ContainerAmadronAddTrade)this.field_147002_h).getStack(slot).func_190926_b()) {
            return ItemAmadronTablet.getLiquidProvidingDimension(player.func_184614_ca());
        }
        return ItemAmadronTablet.getItemProvidingDimension(player.func_184614_ca());
    }

    @Override
    protected Point getInvTextOffset() {
        return null;
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        ContainerAmadronAddTrade container = (ContainerAmadronAddTrade)this.field_147002_h;
        boolean posOK = this.tradeType != AmadronOffer.TradeType.PLAYER || this.getPosition(0) != null && this.getPosition(1) != null;
        this.addButton.field_146124_l = !(this.inputNumber.getValue() <= 0 || this.outputNumber.getValue() <= 0 || this.inputFluid.getFluid() == null && container.getInputStack().func_190926_b() || this.outputFluid.getFluid() == null && container.getOutputStack().func_190926_b() || !posOK);
    }

    protected void addProblems(List curInfo) {
        if (this.tradeType == AmadronOffer.TradeType.PLAYER && (this.getPosition(0) == null || this.getPosition(1) == null)) {
            curInfo.add("gui.amadron.addTrade.problems.noSellingOrPayingBlock");
        }
        super.addProblems(curInfo);
    }
}

