/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import me.desht.pneumaticcraft.common.ai.DroneAIImExBase;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.ICountWidget;
import me.desht.pneumaticcraft.common.progwidgets.ILiquidFiltered;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.util.FluidUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DroneAILiquidImport
extends DroneAIImExBase {
    public DroneAILiquidImport(IDroneBase drone, ProgWidgetAreaItemBase widget) {
        super(drone, widget);
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        return this.emptyTank(pos, true);
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double distToBlock) {
        return this.emptyTank(pos, false) && super.doBlockInteraction(pos, distToBlock);
    }

    private boolean emptyTank(BlockPos pos, boolean simulate) {
        FluidStack fluidStack;
        if (this.drone.getTank().getFluidAmount() == this.drone.getTank().getCapacity()) {
            this.drone.addDebugEntry("gui.progWidget.liquidImport.debug.fullDroneTank");
            this.abort();
            return false;
        }
        TileEntity te = this.drone.world().func_175625_s(pos);
        if (te != null) {
            for (int i = 0; i < 6; ++i) {
                int filledAmount;
                IFluidHandler handler;
                FluidStack importedFluid;
                if (!((ISidedWidget)((Object)this.widget)).getSides()[i] || !te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.func_82600_a((int)i)) || (importedFluid = (handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.func_82600_a((int)i))).drain(Integer.MAX_VALUE, false)) == null || !((ILiquidFiltered)((Object)this.widget)).isFluidValid(importedFluid.getFluid()) || (filledAmount = this.drone.getTank().fill(importedFluid, false)) <= 0) continue;
                if (((ICountWidget)((Object)this.widget)).useCount()) {
                    filledAmount = Math.min(filledAmount, this.getRemainingCount());
                }
                if (!simulate) {
                    this.decreaseCount(this.drone.getTank().fill(handler.drain(filledAmount, true), true));
                }
                return true;
            }
            this.drone.addDebugEntry("gui.progWidget.liquidImport.debug.emptiedToMax", pos);
        }
        if ((!((ICountWidget)((Object)this.widget)).useCount() || this.getRemainingCount() >= 1000) && (fluidStack = FluidUtils.getFluidAt(this.drone.world(), pos, false)) != null && fluidStack.amount == 1000 && ((ILiquidFiltered)((Object)this.widget)).isFluidValid(fluidStack.getFluid()) && this.drone.getTank().fill(fluidStack, false) == 1000) {
            if (!simulate) {
                this.decreaseCount(1000);
                FluidStack fluidStack1 = FluidUtils.getFluidAt(this.drone.world(), pos, true);
                this.drone.getTank().fill(fluidStack1, true);
            }
            return true;
        }
        return false;
    }
}

