/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.common.network.AbstractPacket;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class PacketPlayMovingSound
extends AbstractPacket<PacketPlayMovingSound> {
    private MovingSounds.Sound sound;
    private int entityId;
    private SourceType sourceType;
    private BlockPos pos;

    public PacketPlayMovingSound() {
    }

    public PacketPlayMovingSound(MovingSounds.Sound sound, Object soundSource) {
        this.sound = sound;
        if (soundSource instanceof Entity) {
            this.sourceType = SourceType.ENTITY;
            this.entityId = ((Entity)soundSource).func_145782_y();
        } else if (soundSource instanceof TileEntity) {
            this.sourceType = SourceType.STATIC_POS;
            this.pos = ((TileEntity)soundSource).func_174877_v();
        } else if (soundSource instanceof BlockPos) {
            this.sourceType = SourceType.STATIC_POS;
            this.pos = new BlockPos((Vec3i)((BlockPos)soundSource));
        } else {
            throw new IllegalArgumentException("invalid sound source: " + soundSource);
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeByte(this.sound.ordinal());
        buffer.writeByte(this.sourceType.ordinal());
        if (this.sourceType == SourceType.ENTITY) {
            buffer.writeInt(this.entityId);
        } else if (this.sourceType == SourceType.STATIC_POS) {
            buffer.writeInt(this.pos.func_177958_n());
            buffer.writeInt(this.pos.func_177956_o());
            buffer.writeInt(this.pos.func_177952_p());
        }
    }

    public void fromBytes(ByteBuf buffer) {
        this.sound = MovingSounds.Sound.values()[buffer.readByte()];
        this.sourceType = SourceType.values()[buffer.readByte()];
        if (this.sourceType == SourceType.ENTITY) {
            this.entityId = buffer.readInt();
        } else if (this.sourceType == SourceType.STATIC_POS) {
            this.pos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
        }
    }

    @Override
    public void handleClientSide(PacketPlayMovingSound message, EntityPlayer player) {
        if (this.sourceType == SourceType.ENTITY) {
            Entity e = player.field_70170_p.func_73045_a(this.entityId);
            if (e != null) {
                MovingSounds.playMovingSound(this.sound, e);
            }
        } else if (this.sourceType == SourceType.STATIC_POS) {
            MovingSounds.playMovingSound(this.sound, this.pos);
        }
    }

    @Override
    public void handleServerSide(PacketPlayMovingSound message, EntityPlayer player) {
    }

    static enum SourceType {
        ENTITY,
        STATIC_POS;

    }
}

