/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import java.util.Comparator;
import java.util.List;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.network.AbstractPacket;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketSetEntityMotion;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.lib.Sounds;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class PacketPneumaticKick
extends AbstractPacket<PacketPneumaticKick> {
    @Override
    public void handleClientSide(PacketPneumaticKick message, EntityPlayer player) {
    }

    @Override
    public void handleServerSide(PacketPneumaticKick message, EntityPlayer player) {
        int upgrades;
        CommonArmorHandler handler;
        if (ItemPneumaticArmor.isPneumaticArmorPiece(player, EntityEquipmentSlot.FEET) && (handler = CommonArmorHandler.getHandlerForPlayer(player)).isArmorEnabled() && handler.isArmorReady(EntityEquipmentSlot.FEET) && handler.getArmorPressure(EntityEquipmentSlot.FEET) > 0.1f && (upgrades = handler.getUpgradeCount(EntityEquipmentSlot.FEET, IItemRegistry.EnumUpgrade.DISPENSER)) > 0) {
            this.handleKick(player, Math.min(4, upgrades));
        }
    }

    private void handleKick(EntityPlayer player, int upgrades) {
        Vec3d lookVec = player.func_70040_Z().func_72432_b();
        double playerFootY = player.field_70163_u - (double)(player.field_70131_O / 4.0f);
        AxisAlignedBB box = new AxisAlignedBB(player.field_70165_t, playerFootY, player.field_70161_v, player.field_70165_t, playerFootY, player.field_70161_v).func_72314_b(1.0, 1.0, 1.0).func_191194_a(lookVec);
        List entities = player.field_70170_p.func_72839_b((Entity)player, box);
        if (entities.isEmpty()) {
            return;
        }
        entities.sort(Comparator.comparingDouble(o -> o.func_70068_e((Entity)player)));
        Entity target = (Entity)entities.get(0);
        if (target instanceof EntityLiving) {
            target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 3.0f + (float)upgrades * 0.5f);
        }
        lookVec = lookVec.func_186678_a(1.0 + (double)((float)upgrades * 0.5f));
        target.field_70159_w += lookVec.field_72450_a;
        target.field_70181_x += lookVec.field_72448_b;
        target.field_70179_y += lookVec.field_72449_c;
        NetworkHandler.sendToAllAround(new PacketPlaySound(Sounds.PUNCH, SoundCategory.PLAYERS, target.field_70165_t, target.field_70163_u, target.field_70161_v, 1.0f, 1.0f, false), player.field_70170_p);
        NetworkHandler.sendToAllAround(new PacketSetEntityMotion(target, target.field_70159_w, target.field_70181_x, target.field_70179_y), player.field_70170_p);
        NetworkHandler.sendToAllAround(new PacketSpawnParticle(EnumParticleTypes.EXPLOSION_LARGE, target.field_70165_t, target.field_70163_u, target.field_70161_v, 1.0, 0.0, 0.0), player.field_70170_p);
        CommonArmorHandler.getHandlerForPlayer(player).addAir(EntityEquipmentSlot.FEET, -100 * (2 << upgrades));
    }

    public void fromBytes(ByteBuf buf) {
    }

    public void toBytes(ByteBuf buf) {
    }
}

