/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiProgrammer;
import me.desht.pneumaticcraft.client.gui.programmer.GuiProgWidgetHarvest;
import me.desht.pneumaticcraft.common.ai.DroneAIHarvest;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.IBlockOrdered;
import me.desht.pneumaticcraft.common.progwidgets.IMaxActions;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.IToolUser;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetDigAndPlace;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProgWidgetHarvest
extends ProgWidgetDigAndPlace
implements IToolUser {
    private boolean requireHoe;

    public ProgWidgetHarvest() {
        super(IBlockOrdered.EnumOrder.CLOSEST);
    }

    @Override
    public String getWidgetString() {
        return "harvest";
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_HARVEST;
    }

    @Override
    public EntityAIBase getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return this.setupMaxActions(new DroneAIHarvest(drone, (ProgWidgetAreaItemBase)widget), (IMaxActions)((Object)widget));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetHarvest(this, guiProgrammer);
    }

    @Override
    public int getCraftingColorIndex() {
        return 3;
    }

    @Override
    public boolean requiresTool() {
        return this.requireHoe;
    }

    @Override
    public void setRequiresTool(boolean requireHoe) {
        this.requireHoe = requireHoe;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getTooltip(List<String> curTooltip) {
        super.getTooltip(curTooltip);
        if (this.requiresTool()) {
            curTooltip.add(I18n.func_135052_a((String)"gui.progWidget.harvest.requiresHoe", (Object[])new Object[0]));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("requireHoe", this.requireHoe);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.requireHoe = tag.func_74767_n("requireHoe");
    }
}

