/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.factories;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemHandlerHelper;

public class FluidIngredientFactory
implements IIngredientFactory {
    @Nonnull
    public Ingredient parse(JsonContext context, JsonObject json) {
        String fluidName = JsonUtils.func_151200_h((JsonObject)json, (String)"fluid");
        return new FluidIngredient(fluidName);
    }

    public static class FluidIngredient
    extends Ingredient {
        private final FluidStack fluid;

        FluidIngredient(String fluidName) {
            super(new ItemStack[]{FluidUtil.getFilledBucket((FluidStack)new FluidStack(FluidRegistry.getFluid((String)fluidName), 1000))});
            this.fluid = FluidRegistry.getFluidStack((String)fluidName, (int)1000);
        }

        public boolean apply(ItemStack input) {
            IFluidHandlerItem handler;
            if (input == null || input.func_190926_b()) {
                return false;
            }
            IFluidHandlerItem iFluidHandlerItem = handler = input.func_190916_E() > 1 ? FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)input, (int)1)) : FluidUtil.getFluidHandler((ItemStack)input);
            if (handler == null) {
                return false;
            }
            return this.fluid.isFluidStackIdentical(handler.drain(1000, false));
        }

        public boolean isSimple() {
            return false;
        }
    }
}

