/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.block.BlockElevatorCaller;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityElevatorCaller
extends TileEntityTickableBase
implements ICamouflageableTE {
    private ElevatorButton[] floors = new ElevatorButton[0];
    private int thisFloor;
    private boolean emittingRedstone;
    private boolean shouldUpdateNeighbors;
    @DescSynced
    @Nonnull
    private ItemStack camoStack = ItemStack.field_190927_a;
    private IBlockState camoState;

    public void setEmittingRedstone(boolean emittingRedstone) {
        if (emittingRedstone != this.emittingRedstone) {
            this.emittingRedstone = emittingRedstone;
            this.shouldUpdateNeighbors = true;
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.shouldUpdateNeighbors) {
            this.updateNeighbours();
            this.shouldUpdateNeighbors = false;
        }
    }

    @Override
    public void onDescUpdate() {
        this.camoState = ICamouflageableTE.getStateForStack(this.camoStack);
        super.onDescUpdate();
    }

    public boolean getEmittingRedstone() {
        return this.emittingRedstone;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.emittingRedstone = tag.func_74767_n("emittingRedstone");
        this.thisFloor = tag.func_74762_e("thisFloor");
        this.camoStack = ICamouflageableTE.readCamoStackFromNBT(tag);
        this.camoState = ICamouflageableTE.getStateForStack(this.camoStack);
        this.shouldUpdateNeighbors = tag.func_74767_n("shouldUpdateNeighbors");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("emittingRedstone", this.emittingRedstone);
        tag.func_74768_a("thisFloor", this.thisFloor);
        ICamouflageableTE.writeCamoStackToNBT(this.camoStack, tag);
        tag.func_74757_a("shouldUpdateNeighbors", this.shouldUpdateNeighbors);
        return tag;
    }

    @Override
    public void readFromPacket(NBTTagCompound tag) {
        super.readFromPacket(tag);
        int floorAmount = tag.func_74762_e("floors");
        this.floors = new ElevatorButton[floorAmount];
        for (int i = 0; i < floorAmount; ++i) {
            NBTTagCompound buttonTag = tag.func_74775_l("floor" + i);
            this.floors[i] = new ElevatorButton();
            this.floors[i].readFromNBT(buttonTag);
        }
    }

    @Override
    public void writeToPacket(NBTTagCompound tag) {
        super.writeToPacket(tag);
        tag.func_74768_a("floors", this.floors.length);
        for (ElevatorButton floor : this.floors) {
            NBTTagCompound buttonTag = new NBTTagCompound();
            floor.writeToNBT(buttonTag);
            tag.func_74782_a("floor" + floor.floorNumber, (NBTBase)buttonTag);
        }
    }

    @Override
    public void onNeighborBlockUpdate() {
        boolean wasPowered = this.poweredRedstone > 0;
        super.onNeighborBlockUpdate();
        if (this.poweredRedstone > 0 && !wasPowered) {
            BlockElevatorCaller.setSurroundingElevators(this.func_145831_w(), this.func_174877_v(), this.thisFloor);
        }
    }

    void setFloors(ElevatorButton[] floors, int thisFloorLevel) {
        this.floors = floors;
        this.thisFloor = thisFloorLevel;
        this.sendDescriptionPacket();
    }

    public ElevatorButton[] getFloors() {
        return this.floors;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
    }

    @Override
    public IBlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(IBlockState state) {
        this.camoState = state;
        this.camoStack = ICamouflageableTE.getStackForState(state);
        this.sendDescriptionPacket();
        this.func_70296_d();
    }

    public static class ElevatorButton {
        public double posX;
        public double posY;
        public double width;
        public double height;
        public float red;
        public float green;
        public float blue;
        public String buttonText = "";
        public int floorNumber;
        public int floorHeight;

        public ElevatorButton(double posX, double posY, double width, double height, int floorNumber, int floorHeight) {
            this.posX = posX;
            this.posY = posY;
            this.width = width;
            this.height = height;
            this.floorNumber = floorNumber;
            this.floorHeight = floorHeight;
            this.buttonText = floorNumber + 1 + "";
        }

        public ElevatorButton() {
        }

        public void setColor(float red, float green, float blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74780_a("posX", this.posX);
            tag.func_74780_a("posY", this.posY);
            tag.func_74780_a("width", this.width);
            tag.func_74780_a("height", this.height);
            tag.func_74778_a("buttonText", this.buttonText);
            tag.func_74768_a("floorNumber", this.floorNumber);
            tag.func_74768_a("floorHeight", this.floorHeight);
            tag.func_74776_a("red", this.red);
            tag.func_74776_a("green", this.green);
            tag.func_74776_a("blue", this.blue);
        }

        public void readFromNBT(NBTTagCompound tag) {
            this.posX = tag.func_74769_h("posX");
            this.posY = tag.func_74769_h("posY");
            this.width = tag.func_74769_h("width");
            this.height = tag.func_74769_h("height");
            this.buttonText = tag.func_74779_i("buttonText");
            this.floorNumber = tag.func_74762_e("floorNumber");
            this.floorHeight = tag.func_74762_e("floorHeight");
            this.red = tag.func_74760_g("red");
            this.green = tag.func_74760_g("green");
            this.blue = tag.func_74760_g("blue");
        }
    }
}

