/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import com.google.common.collect.Lists;
import nc.recipe.ProcessorRecipeHandler;

public class ChemicalReactorRecipes
extends ProcessorRecipeHandler {
    public ChemicalReactorRecipes() {
        super("chemical_reactor", 0, 2, 0, 2);
    }

    @Override
    public void addRecipes() {
        this.addRecipe(ChemicalReactorRecipes.fluidStackList(Lists.newArrayList((Object[])new String[]{"boron", "boron10", "boron11"}), 144), ChemicalReactorRecipes.fluidStack("hydrogen", 3000), ChemicalReactorRecipes.fluidStack("diborane", 1000), ChemicalReactorRecipes.emptyFluidStack(), 1.0, 1.0);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("diborane", 500), ChemicalReactorRecipes.fluidStack("water", 3000), ChemicalReactorRecipes.fluidStack("boric_acid", 1000), ChemicalReactorRecipes.fluidStack("hydrogen", 3000), 0.5, 0.5);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("nitrogen", 1000), ChemicalReactorRecipes.fluidStack("hydrogen", 3000), ChemicalReactorRecipes.fluidStack("ammonia", 2000), ChemicalReactorRecipes.emptyFluidStack(), 1.0, 0.5);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("boric_acid", 1000), ChemicalReactorRecipes.fluidStack("ammonia", 1000), ChemicalReactorRecipes.fluidStack("boron_nitride_solution", 666), ChemicalReactorRecipes.fluidStack("water", 2000), 1.0, 0.5);
        this.addRecipe(ChemicalReactorRecipes.fluidStackList(Lists.newArrayList((Object[])new String[]{"lithium", "lithium6", "lithium7"}), 144), ChemicalReactorRecipes.fluidStack("fluorine", 500), ChemicalReactorRecipes.fluidStack("lif", 144), ChemicalReactorRecipes.emptyFluidStack(), 1.0, 0.5);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("beryllium", 144), ChemicalReactorRecipes.fluidStack("fluorine", 1000), ChemicalReactorRecipes.fluidStack("bef2", 144), ChemicalReactorRecipes.emptyFluidStack(), 1.0, 0.5);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("sulfur", 666), ChemicalReactorRecipes.fluidStack("oxygen", 1000), ChemicalReactorRecipes.fluidStack("sulfur_dioxide", 1000), ChemicalReactorRecipes.emptyFluidStack(), 1.0, 0.5);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("sulfur_dioxide", 1000), ChemicalReactorRecipes.fluidStack("oxygen", 500), ChemicalReactorRecipes.fluidStack("sulfur_trioxide", 1000), ChemicalReactorRecipes.emptyFluidStack(), 0.5, 0.5);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("sulfur_trioxide", 1000), ChemicalReactorRecipes.fluidStack("water", 1000), ChemicalReactorRecipes.fluidStack("sulfuric_acid", 1000), ChemicalReactorRecipes.emptyFluidStack(), 1.0, 0.5);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("fluorite_water", 666), ChemicalReactorRecipes.fluidStack("sulfuric_acid", 1000), ChemicalReactorRecipes.fluidStack("hydrofluoric_acid", 2000), ChemicalReactorRecipes.fluidStack("calcium_sulfate_solution", 666), 1.5, 0.5);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("sodium_fluoride_solution", 666), ChemicalReactorRecipes.fluidStack("water", 1000), ChemicalReactorRecipes.fluidStack("sodium_hydroxide_solution", 666), ChemicalReactorRecipes.fluidStack("hydrofluoric_acid", 1000), 1.0, 1.0);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("potassium_fluoride_solution", 666), ChemicalReactorRecipes.fluidStack("water", 1000), ChemicalReactorRecipes.fluidStack("potassium_hydroxide_solution", 666), ChemicalReactorRecipes.fluidStack("hydrofluoric_acid", 1000), 1.0, 1.0);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("sodium_fluoride_solution", 666), ChemicalReactorRecipes.fluidStack("boric_acid", 2000), ChemicalReactorRecipes.fluidStack("borax_solution", 333), ChemicalReactorRecipes.fluidStack("hydrofluoric_acid", 1000), 1.5, 1.0);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("oxygen_difluoride", 1000), ChemicalReactorRecipes.fluidStack("water", 1000), ChemicalReactorRecipes.fluidStack("oxygen", 1000), ChemicalReactorRecipes.fluidStack("hydrofluoric_acid", 2000), 1.0, 1.0);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("oxygen_difluoride", 1000), ChemicalReactorRecipes.fluidStack("sulfur_dioxide", 1000), ChemicalReactorRecipes.fluidStack("sulfur_trioxide", 1000), ChemicalReactorRecipes.fluidStack("fluorine", 1000), 1.0, 1.0);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("oxygen", 1000), ChemicalReactorRecipes.fluidStack("fluorine", 2000), ChemicalReactorRecipes.fluidStack("oxygen_difluoride", 2000), ChemicalReactorRecipes.emptyFluidStack(), 1.5, 0.5);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("manganese_dioxide", 144), ChemicalReactorRecipes.fluidStack("carbon", 200), ChemicalReactorRecipes.fluidStack("manganese", 144), ChemicalReactorRecipes.fluidStack("carbon_monoxide", 2000), 1.0, 1.0);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("sugar", 144), ChemicalReactorRecipes.fluidStack("water", 1000), ChemicalReactorRecipes.fluidStack("ethanol", 4000), ChemicalReactorRecipes.fluidStack("carbon_dioxide", 4000), 1.5, 0.5);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("carbon_dioxide", 1000), ChemicalReactorRecipes.fluidStack("hydrogen", 1000), ChemicalReactorRecipes.fluidStack("carbon_monoxide", 1000), ChemicalReactorRecipes.fluidStack("water", 1000), 1.0, 0.5);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("carbon_monoxide", 1000), ChemicalReactorRecipes.fluidStack("hydrogen", 2000), ChemicalReactorRecipes.fluidStack("methanol", 1000), ChemicalReactorRecipes.emptyFluidStack(), 1.0, 0.5);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("methanol", 1000), ChemicalReactorRecipes.fluidStack("hydrofluoric_acid", 1000), ChemicalReactorRecipes.fluidStack("fluoromethane", 1000), ChemicalReactorRecipes.fluidStack("water", 1000), 1.0, 1.0);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("fluoromethane", 1000), ChemicalReactorRecipes.fluidStack("naoh", 666), ChemicalReactorRecipes.fluidStack("ethene", 500), ChemicalReactorRecipes.fluidStack("sodium_fluoride_solution", 666), 1.0, 1.0);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("fluoromethane", 1000), ChemicalReactorRecipes.fluidStack("koh", 666), ChemicalReactorRecipes.fluidStack("ethene", 500), ChemicalReactorRecipes.fluidStack("potassium_fluoride_solution", 666), 1.0, 1.0);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("ethene", 1000), ChemicalReactorRecipes.fluidStack("sulfuric_acid", 1000), ChemicalReactorRecipes.fluidStack("ethanol", 1000), ChemicalReactorRecipes.fluidStack("sulfur_trioxide", 1000), 1.0, 1.0);
        this.addRecipe(ChemicalReactorRecipes.fluidStackList(Lists.newArrayList((Object[])new String[]{"boron", "boron10", "boron11"}), 144), ChemicalReactorRecipes.fluidStack("arsenic", 666), ChemicalReactorRecipes.fluidStack("bas", 666), ChemicalReactorRecipes.emptyFluidStack(), 1.0, 1.0);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("alugentum", 72), ChemicalReactorRecipes.fluidStack("oxygen", 3000), ChemicalReactorRecipes.fluidStack("alumina", 144), ChemicalReactorRecipes.fluidStack("silver", 72), 1.0, 0.5);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("hydrogen", 1000), ChemicalReactorRecipes.fluidStack("chlorine", 1000), ChemicalReactorRecipes.fluidStack("hydrogen_chloride", 1000), ChemicalReactorRecipes.emptyFluidStack(), 1.0, 0.5);
        this.addElementFluorideRecipes("thorium", "uranium", "plutonium");
        this.addIsotopeFluorideRecipes("thorium", 230);
        this.addIsotopeFluorideRecipes("uranium", 233, 235, 238);
        this.addIsotopeFluorideRecipes("neptunium", 236, 237);
        this.addIsotopeFluorideRecipes("plutonium", 238, 239, 241, 242);
        this.addIsotopeFluorideRecipes("americium", 241, 242, 243);
        this.addIsotopeFluorideRecipes("curium", 243, 245, 246, 247);
        this.addIsotopeFluorideRecipes("berkelium", 247, 248);
        this.addIsotopeFluorideRecipes("californium", 249, 250, 251, 252);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("fuel_tbu", 144), ChemicalReactorRecipes.fluidStack("fluorine", 1000), ChemicalReactorRecipes.fluidStack("fuel_tbu_fluoride", 144), ChemicalReactorRecipes.emptyFluidStack(), 1.0, 0.5);
        this.addRecipe(ChemicalReactorRecipes.fluidStack("depleted_fuel_tbu", 144), ChemicalReactorRecipes.fluidStack("fluorine", 1000), ChemicalReactorRecipes.fluidStack("depleted_fuel_tbu_fluoride", 144), ChemicalReactorRecipes.emptyFluidStack(), 1.0, 0.5);
        this.addFissionFuelFluorideRecipes("eu", 233, 235);
        this.addFissionFuelFluorideRecipes("en", 236);
        this.addFissionFuelFluorideRecipes("ep", 239, 241);
        this.addFissionFuelFluorideRecipes("ea", 242);
        this.addFissionFuelFluorideRecipes("ecm", 243, 245, 247);
        this.addFissionFuelFluorideRecipes("eb", 248);
        this.addFissionFuelFluorideRecipes("ecf", 249, 251);
    }

    public void addElementFluorideRecipes(String ... elements) {
        for (String element : elements) {
            this.addRecipe(ChemicalReactorRecipes.fluidStack(element, 144), ChemicalReactorRecipes.fluidStack("fluorine", 1000), ChemicalReactorRecipes.fluidStack(element + "_fluoride", 144), ChemicalReactorRecipes.emptyFluidStack(), 1.0, 0.5);
        }
    }

    public void addIsotopeFluorideRecipes(String element, int ... types) {
        for (int type : types) {
            this.addRecipe(ChemicalReactorRecipes.fluidStack(element + "_" + type, 144), ChemicalReactorRecipes.fluidStack("fluorine", 1000), ChemicalReactorRecipes.fluidStack(element + "_" + type + "_fluoride", 144), ChemicalReactorRecipes.emptyFluidStack(), 1.0, 0.5);
        }
    }

    public void addFissionFuelFluorideRecipes(String suffix, int ... types) {
        for (int type : types) {
            for (String form : new String[]{"fuel_l", "fuel_h", "depleted_fuel_l", "depleted_fuel_h"}) {
                this.addRecipe(ChemicalReactorRecipes.fluidStack(form + suffix + "_" + type, 144), ChemicalReactorRecipes.fluidStack("fluorine", 1000), ChemicalReactorRecipes.fluidStack(form + suffix + "_" + type + "_fluoride", 144), ChemicalReactorRecipes.emptyFluidStack(), 1.0, 0.5);
            }
        }
    }
}

