/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.dummy;

import java.util.List;
import javax.annotation.Nonnull;
import nc.tile.dummy.IDummyMaster;
import nc.tile.energy.ITileEnergy;
import nc.tile.energyFluid.TileEnergyFluidSidedInventory;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.energy.EnergyStorage;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.FluidTileWrapper;
import nc.tile.internal.fluid.GasTileWrapper;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankOutputSetting;
import nc.tile.internal.fluid.TankSorption;
import nc.tile.internal.inventory.InventoryConnection;
import nc.tile.internal.inventory.InventoryTileWrapper;
import nc.tile.internal.inventory.ItemOutputSetting;
import nc.tile.internal.inventory.ItemSorption;
import nc.tile.inventory.ITileInventory;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileDummy<T extends IDummyMaster>
extends TileEnergyFluidSidedInventory {
    public BlockPos masterPosition = null;
    protected final int updateRate;
    protected int checkCount;
    protected final Class<T> tClass;

    public TileDummy(Class<T> tClass, String name, int updateRate, List<String> allowedFluids) {
        this(tClass, name, ITileInventory.inventoryConnectionAll(ItemSorption.NON), ITileEnergy.energyConnectionAll(EnergyConnection.NON), updateRate, allowedFluids, ITileFluid.fluidConnectionAll(TankSorption.NON));
    }

    public TileDummy(Class<T> tClass, String name, @Nonnull EnergyConnection[] energyConnections, int updateRate, List<String> allowedFluids) {
        this(tClass, name, ITileInventory.inventoryConnectionAll(ItemSorption.NON), energyConnections, updateRate, allowedFluids, ITileFluid.fluidConnectionAll(TankSorption.NON));
    }

    public TileDummy(Class<T> tClass, String name, int updateRate, List<String> allowedFluids, @Nonnull FluidConnection[] fluidConnections) {
        this(tClass, name, ITileInventory.inventoryConnectionAll(ItemSorption.NON), ITileEnergy.energyConnectionAll(EnergyConnection.NON), updateRate, allowedFluids, fluidConnections);
    }

    public TileDummy(Class<T> tClass, String name, @Nonnull EnergyConnection[] energyConnections, int updateRate, List<String> allowedFluids, @Nonnull FluidConnection[] fluidConnections) {
        this(tClass, name, ITileInventory.inventoryConnectionAll(ItemSorption.NON), energyConnections, updateRate, allowedFluids, fluidConnections);
    }

    public TileDummy(Class<T> tClass, String name, @Nonnull InventoryConnection[] inventoryConnections, int updateRate, List<String> allowedFluids) {
        this(tClass, name, inventoryConnections, ITileEnergy.energyConnectionAll(EnergyConnection.NON), updateRate, allowedFluids, ITileFluid.fluidConnectionAll(TankSorption.NON));
    }

    public TileDummy(Class<T> tClass, String name, @Nonnull InventoryConnection[] inventoryConnections, @Nonnull EnergyConnection[] energyConnections, int updateRate, List<String> allowedFluids) {
        this(tClass, name, inventoryConnections, energyConnections, updateRate, allowedFluids, ITileFluid.fluidConnectionAll(TankSorption.NON));
    }

    public TileDummy(Class<T> tClass, String name, @Nonnull InventoryConnection[] inventoryConnections, int updateRate, List<String> allowedFluids, @Nonnull FluidConnection[] fluidConnections) {
        this(tClass, name, inventoryConnections, ITileEnergy.energyConnectionAll(EnergyConnection.NON), updateRate, allowedFluids, fluidConnections);
    }

    public TileDummy(Class<T> tClass, String name, @Nonnull InventoryConnection[] inventoryConnections, @Nonnull EnergyConnection[] energyConnections, int updateRate, List<String> allowedFluids, @Nonnull FluidConnection[] fluidConnections) {
        super(name, 1, inventoryConnections, 1, energyConnections, 1, allowedFluids, fluidConnections);
        this.updateRate = updateRate;
        this.tClass = tClass;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (!this.field_145850_b.field_72995_K) {
            this.findMaster();
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.checkCount == 0) {
                this.findMaster();
            }
            this.tickDummy();
        }
    }

    public void tickDummy() {
        ++this.checkCount;
        this.checkCount %= this.updateRate;
    }

    @Override
    public void onBlockNeighborChanged(IBlockState state, World world, BlockPos pos, BlockPos fromPos) {
        super.onBlockNeighborChanged(state, world, pos, fromPos);
        if (this.hasMaster()) {
            this.getMaster().onDummyNeighborChanged(state, world, pos, fromPos);
        }
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getInventoryStacks() {
        if (this.getMaster() instanceof ITileInventory) {
            return ((ITileInventory)this.getMaster()).getInventoryStacks();
        }
        return super.getInventoryStacks();
    }

    @Override
    public int getInventoryStackLimit() {
        if (this.getMaster() instanceof ITileInventory) {
            return ((ITileInventory)this.getMaster()).getInventoryStackLimit();
        }
        return 1;
    }

    @Override
    public boolean isUsableByPlayer(EntityPlayer player) {
        return false;
    }

    @Override
    @Nonnull
    public InventoryConnection[] getInventoryConnections() {
        if (this.getMaster() instanceof ITileInventory) {
            return ((ITileInventory)this.getMaster()).getInventoryConnections();
        }
        return super.getInventoryConnections();
    }

    @Override
    public void setInventoryConnections(@Nonnull InventoryConnection[] connections) {
        if (this.getMaster() instanceof ITileInventory) {
            ((ITileInventory)this.getMaster()).setInventoryConnections(connections);
        }
        super.setInventoryConnections(connections);
    }

    @Override
    @Nonnull
    public InventoryTileWrapper getInventory() {
        if (this.getMaster() instanceof ITileInventory) {
            return ((ITileInventory)this.getMaster()).getInventory();
        }
        return super.getInventory();
    }

    @Override
    public ItemOutputSetting getItemOutputSetting(int tankNumber) {
        if (this.getMaster() instanceof ITileInventory) {
            return ((ITileInventory)this.getMaster()).getItemOutputSetting(tankNumber);
        }
        return super.getItemOutputSetting(tankNumber);
    }

    @Override
    public void setItemOutputSetting(int tankNumber, ItemOutputSetting setting) {
        if (this.getMaster() instanceof ITileInventory) {
            ((ITileInventory)this.getMaster()).setItemOutputSetting(tankNumber, setting);
        } else {
            super.setItemOutputSetting(tankNumber, setting);
        }
    }

    @Override
    public EnergyStorage getEnergyStorage() {
        if (this.getMaster() instanceof ITileEnergy) {
            return ((ITileEnergy)this.getMaster()).getEnergyStorage();
        }
        return super.getEnergyStorage();
    }

    @Override
    public EnergyConnection getEnergyConnection(@Nonnull EnumFacing side) {
        if (this.getMaster() instanceof ITileEnergy) {
            return ((ITileEnergy)this.getMaster()).getEnergyConnection(side);
        }
        return super.getEnergyConnection(side);
    }

    @Override
    public int getEnergyStored() {
        if (this.getMaster() instanceof ITileEnergy) {
            return ((ITileEnergy)this.getMaster()).getEnergyStored();
        }
        return super.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored() {
        if (this.getMaster() instanceof ITileEnergy) {
            return ((ITileEnergy)this.getMaster()).getMaxEnergyStored();
        }
        return super.getMaxEnergyStored();
    }

    @Override
    public boolean canReceiveEnergy(EnumFacing side) {
        if (this.getMaster() instanceof ITileEnergy) {
            return ((ITileEnergy)this.getMaster()).canReceiveEnergy(side);
        }
        return false;
    }

    @Override
    public boolean canExtractEnergy(EnumFacing side) {
        if (this.getMaster() instanceof ITileEnergy) {
            return ((ITileEnergy)this.getMaster()).canExtractEnergy(side);
        }
        return false;
    }

    @Override
    public int receiveEnergy(int maxReceive, EnumFacing side, boolean simulate) {
        if (this.getMaster() instanceof ITileEnergy) {
            return ((ITileEnergy)this.getMaster()).receiveEnergy(maxReceive, side, simulate);
        }
        return 0;
    }

    @Override
    public int extractEnergy(int maxExtract, EnumFacing side, boolean simulate) {
        if (this.getMaster() instanceof ITileEnergy) {
            return ((ITileEnergy)this.getMaster()).extractEnergy(maxExtract, side, simulate);
        }
        return 0;
    }

    @Override
    public int getEUSourceTier() {
        if (this.getMaster() instanceof ITileEnergy) {
            return ((ITileEnergy)this.getMaster()).getEUSourceTier();
        }
        return 1;
    }

    @Override
    public int getEUSinkTier() {
        if (this.getMaster() instanceof ITileEnergy) {
            return ((ITileEnergy)this.getMaster()).getEUSinkTier();
        }
        return 10;
    }

    @Override
    public void pushEnergy() {
        if (this.getMaster() == null) {
            return;
        }
        super.pushEnergy();
    }

    @Override
    public void spreadEnergy() {
        if (this.getMaster() == null) {
            return;
        }
        super.spreadEnergy();
    }

    @Override
    @Nonnull
    public List<Tank> getTanks() {
        if (this.getMaster() instanceof ITileFluid) {
            return ((ITileFluid)this.getMaster()).getTanks();
        }
        return super.getTanks();
    }

    @Override
    @Nonnull
    public FluidConnection[] getFluidConnections() {
        if (this.getMaster() instanceof ITileFluid) {
            return ((ITileFluid)this.getMaster()).getFluidConnections();
        }
        return super.getFluidConnections();
    }

    @Override
    @Nonnull
    public FluidTileWrapper[] getFluidSides() {
        if (this.getMaster() instanceof ITileFluid) {
            return ((ITileFluid)this.getMaster()).getFluidSides();
        }
        return super.getFluidSides();
    }

    @Override
    @Nonnull
    public GasTileWrapper getGasWrapper() {
        if (this.getMaster() instanceof ITileFluid) {
            return ((ITileFluid)this.getMaster()).getGasWrapper();
        }
        return super.getGasWrapper();
    }

    @Override
    public boolean getInputTanksSeparated() {
        if (this.getMaster() instanceof ITileFluid) {
            return ((ITileFluid)this.getMaster()).getInputTanksSeparated();
        }
        return super.getInputTanksSeparated();
    }

    @Override
    public void setInputTanksSeparated(boolean shared) {
        if (this.getMaster() instanceof ITileFluid) {
            ((ITileFluid)this.getMaster()).setInputTanksSeparated(shared);
        } else {
            super.setInputTanksSeparated(shared);
        }
    }

    @Override
    public boolean getVoidUnusableFluidInput(int tankNumber) {
        if (this.getMaster() instanceof ITileFluid) {
            return ((ITileFluid)this.getMaster()).getVoidUnusableFluidInput(tankNumber);
        }
        return super.getVoidUnusableFluidInput(tankNumber);
    }

    @Override
    public void setVoidUnusableFluidInput(int tankNumber, boolean voidUnusableFluidInput) {
        if (this.getMaster() instanceof ITileFluid) {
            ((ITileFluid)this.getMaster()).setVoidUnusableFluidInput(tankNumber, voidUnusableFluidInput);
        } else {
            super.setVoidUnusableFluidInput(tankNumber, voidUnusableFluidInput);
        }
    }

    @Override
    public TankOutputSetting getTankOutputSetting(int tankNumber) {
        if (this.getMaster() instanceof ITileFluid) {
            return ((ITileFluid)this.getMaster()).getTankOutputSetting(tankNumber);
        }
        return super.getTankOutputSetting(tankNumber);
    }

    @Override
    public void setTankOutputSetting(int tankNumber, TankOutputSetting setting) {
        if (this.getMaster() instanceof ITileFluid) {
            ((ITileFluid)this.getMaster()).setTankOutputSetting(tankNumber, setting);
        } else {
            super.setTankOutputSetting(tankNumber, setting);
        }
    }

    @Override
    public void pushFluid() {
        if (this.getMaster() == null) {
            return;
        }
        super.pushFluid();
    }

    @Override
    public void spreadFluid() {
        if (this.getMaster() == null) {
            return;
        }
        super.spreadFluid();
    }

    public abstract void findMaster();

    public boolean hasMaster() {
        if (this.masterPosition == null) {
            return false;
        }
        return this.isMaster(this.masterPosition);
    }

    public boolean isMaster(BlockPos pos) {
        return this.tClass.isInstance(this.field_145850_b.func_175625_s(pos));
    }

    public T getMaster() {
        if (this.hasMaster()) {
            return (T)((IDummyMaster)this.field_145850_b.func_175625_s(this.masterPosition));
        }
        return null;
    }
}

