/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.fluid;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import nc.config.NCConfig;
import nc.enumm.MetaEnums;
import nc.tile.dummy.IInterfaceable;
import nc.tile.energyFluid.IBufferable;
import nc.tile.fluid.IFluidSpread;
import nc.tile.fluid.ITileFluid;
import nc.tile.fluid.TileFluid;
import nc.tile.internal.fluid.TankSorption;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TileActiveCooler
extends TileFluid
implements IInterfaceable,
IBufferable,
IFluidSpread {
    protected int drainCount;
    public boolean isActive = false;
    private static final int DRAIN_MULT = Math.max(1, NCConfig.machine_update_rate * NCConfig.active_cooler_max_rate / 20);

    private static List<String> validFluids() {
        ArrayList<String> validFluids = new ArrayList<String>();
        for (int i = 1; i < MetaEnums.CoolerType.values().length; ++i) {
            validFluids.add(MetaEnums.CoolerType.values()[i].getFluidName());
        }
        return validFluids;
    }

    public TileActiveCooler() {
        super(100 * DRAIN_MULT, TileActiveCooler.validFluids(), ITileFluid.fluidConnectionAll(TankSorption.IN));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.drainCount == 0) {
                this.spreadFluid();
                if (this.isActive) {
                    this.getTanks().get(0).drain(DRAIN_MULT, true);
                }
            }
            this.tickDrain();
        }
    }

    public void tickDrain() {
        ++this.drainCount;
        this.drainCount %= NCConfig.machine_update_rate;
    }

    @Override
    public void spreadFluidToSide(@Nonnull EnumFacing side) {
        TileEntity tile = this.getTileWorld().func_175625_s(this.getTilePos().func_177972_a(side));
        if (tile instanceof TileActiveCooler) {
            TileActiveCooler other = (TileActiveCooler)tile;
            int diff = this.getTanks().get(0).getFluidAmount() - other.getTanks().get(0).getFluidAmount();
            if (diff > 1) {
                this.getTanks().get(0).drain(other.getTanks().get(0).fillInternal(this.getTanks().get(0).drain(diff / 2, false), true), true);
            }
        }
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74757_a("isActive", this.isActive);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.isActive = nbt.func_74767_n("isActive");
    }
}

