/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.lib.capabilities;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ArmorAbilityHandler {
    @CapabilityInject(value=IArmorAbilities.class)
    public static final Capability<IArmorAbilities> ARMOR_AB_CAP = null;

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
        if (evt.getObject() instanceof EntityPlayer) {
            evt.addCapability(new ResourceLocation("conarm", "armor_abilities"), (ICapabilityProvider)new Provider());
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone evt) {
        IArmorAbilities old = ArmorAbilityHandler.getArmorAbilitiesData(evt.getOriginal());
        IArmorAbilities clone = ArmorAbilityHandler.getArmorAbilitiesData(evt.getEntityPlayer());
        if (old != null && clone != null) {
            clone.setAbilityMap(old.getAbilityMap());
        }
    }

    public static IArmorAbilities getArmorAbilitiesData(EntityPlayer player) {
        return player != null && player.hasCapability(ARMOR_AB_CAP, null) ? (IArmorAbilities)player.getCapability(ARMOR_AB_CAP, null) : null;
    }

    public static class Storage
    implements Capability.IStorage<IArmorAbilities> {
        public NBTBase writeNBT(Capability<IArmorAbilities> capability, IArmorAbilities instance, EnumFacing side) {
            NBTTagCompound compound = new NBTTagCompound();
            NBTTagCompound tagcompound = new NBTTagCompound();
            Map<String, Integer> abilityMap = instance.getAbilityMap();
            for (String identifier : abilityMap.keySet()) {
                tagcompound.func_74768_a(identifier, abilityMap.get(identifier).intValue());
            }
            compound.func_74782_a("ArmorAbilities", (NBTBase)tagcompound);
            return compound;
        }

        public void readNBT(Capability<IArmorAbilities> capability, IArmorAbilities instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound compound = (NBTTagCompound)nbt;
            NBTTagCompound tagcompound = compound.func_74775_l("ArmorAbilities");
            HashMap abilityMap = Maps.newHashMap();
            for (String identifier : tagcompound.func_150296_c()) {
                abilityMap.putIfAbsent(identifier, tagcompound.func_74762_e(identifier));
            }
            instance.setAbilityMap(abilityMap);
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTBase> {
        private IArmorAbilities instance = (IArmorAbilities)ARMOR_AB_CAP.getDefaultInstance();

        public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
            return capability == ARMOR_AB_CAP;
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
            return (T)(capability == ARMOR_AB_CAP ? ARMOR_AB_CAP.cast((Object)this.instance) : null);
        }

        public NBTBase serializeNBT() {
            return ARMOR_AB_CAP.getStorage().writeNBT(ARMOR_AB_CAP, (Object)this.instance, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            ARMOR_AB_CAP.getStorage().readNBT(ARMOR_AB_CAP, (Object)this.instance, null, nbt);
        }
    }

    public static interface IArmorAbilities {
        public Map<String, Integer> getAbilityMap();

        public void clearAllAbilities();

        public void setAbilityMap(Map<String, Integer> var1);

        public void addAbility(String var1, int var2);

        public void removeAbility(String var1, int var2);

        public int getAbilityLevel(String var1);
    }

    public static class ArmorAbilities
    implements IArmorAbilities {
        private Map<String, Integer> abilityMap = Maps.newHashMap();

        @Override
        public void clearAllAbilities() {
            this.abilityMap.clear();
        }

        @Override
        public Map<String, Integer> getAbilityMap() {
            return this.abilityMap;
        }

        @Override
        public void setAbilityMap(Map<String, Integer> abilityMap) {
            this.abilityMap = abilityMap;
        }

        @Override
        public void addAbility(String identifier, int amount) {
            this.abilityMap.merge(identifier, amount, (a, b) -> a + b);
        }

        @Override
        public void removeAbility(String identifier, int amount) {
            if (this.abilityMap.get(identifier) != null) {
                int level = this.abilityMap.get(identifier) - amount;
                if (level <= 0) {
                    this.abilityMap.remove(identifier);
                } else {
                    this.abilityMap.replace(identifier, level);
                }
            }
        }

        @Override
        public int getAbilityLevel(String identifier) {
            if (this.abilityMap.get(identifier) != null) {
                return this.abilityMap.get(identifier);
            }
            return 0;
        }
    }
}

