/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.keyboard;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.squiddev.plethora.gameplay.Plethora;
import org.squiddev.plethora.gameplay.keyboard.KeyMessage;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="plethora")
public final class ClientKeyListener {
    static boolean listening;
    private static final ArrayList<KeyDown> keysDown;
    private static final List<KeyMessage.KeyPress> keyPresses;
    private static final List<Integer> keysUp;

    private ClientKeyListener() {
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onInputEvent(InputEvent.KeyInputEvent event) {
        if (!listening) {
            keysDown.clear();
            return;
        }
        if (Keyboard.getEventKeyState()) {
            char ch = Keyboard.getEventCharacter();
            int key = Keyboard.getEventKey();
            boolean repeat = Keyboard.isRepeatEvent();
            char c = ch = ch >= ' ' && ch <= '~' || ch >= '\u00a0' && ch <= '\u00ff' ? ch : (char)'\u0000';
            if (key > 0 || ch != '\u0000') {
                keyPresses.add(new KeyMessage.KeyPress(key, repeat, ch));
                boolean found = false;
                for (KeyDown down : keysDown) {
                    if (down.key != key) continue;
                    down.lastTime = Minecraft.func_71386_F();
                    found = true;
                    break;
                }
                if (!found) {
                    keysDown.add(new KeyDown(key, ch));
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (int i = keysDown.size() - 1; i >= 0; --i) {
            KeyDown down = keysDown.get(i);
            if (Keyboard.isKeyDown((int)down.key)) {
                long time = Minecraft.func_71386_F();
                if (down.lastTime > time - 100L) continue;
                down.lastTime = time;
                keyPresses.add(new KeyMessage.KeyPress(down.key, true, down.character));
                continue;
            }
            keysDown.remove(i);
            keysUp.add(down.key);
        }
        if (!keyPresses.isEmpty() || !keysUp.isEmpty()) {
            Plethora.network.sendToServer((IMessage)new KeyMessage(keyPresses, keysUp));
            keyPresses.clear();
            keysUp.clear();
        }
    }

    static {
        keysDown = Lists.newArrayList();
        keyPresses = Lists.newArrayList();
        keysUp = Lists.newArrayList();
    }

    private static final class KeyDown {
        public final int key;
        public final char character;
        public long lastTime;

        @SideOnly(value=Side.CLIENT)
        private KeyDown(int key, char character) {
            this.key = key;
            this.character = character;
            this.lastTime = Minecraft.func_71386_F();
        }
    }
}

