/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.glasses.objects.object3d;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.gameplay.modules.glasses.BaseObject;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasClient;
import org.squiddev.plethora.gameplay.modules.glasses.objects.ItemObject;
import org.squiddev.plethora.gameplay.modules.glasses.objects.Scalable;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object3d.DepthTestable;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object3d.Positionable3D;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object3d.Rotatable3D;
import org.squiddev.plethora.utils.ByteBufUtils;

public class Item3D
extends BaseObject
implements Scalable,
Positionable3D,
DepthTestable,
ItemObject,
Rotatable3D {
    private float scale;
    private Vec3d position = Vec3d.field_186680_a;
    private Vec3d rotation = Vec3d.field_186680_a;
    private boolean depthTest = true;
    private int damage;
    private Item item;
    private ItemStack stack;

    public Item3D(int id, int parent) {
        super(id, parent, (byte)12);
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setScale(float scale) {
        if (this.scale != scale) {
            this.scale = scale;
            this.setDirty();
        }
    }

    @Override
    @Nonnull
    public Vec3d getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(@Nonnull Vec3d position) {
        if (!this.position.equals((Object)position)) {
            this.position = position;
            this.setDirty();
        }
    }

    @Override
    public boolean hasDepthTest() {
        return this.depthTest;
    }

    @Override
    public void setDepthTest(boolean depthTest) {
        if (this.depthTest != depthTest) {
            this.depthTest = depthTest;
            this.setDirty();
        }
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public void setDamage(int damage) {
        if (this.damage != damage) {
            this.damage = damage;
            this.stack = null;
            this.setDirty();
        }
    }

    @Override
    @Nonnull
    public Item getItem() {
        return this.item;
    }

    @Override
    public void setItem(@Nonnull Item item) {
        if (this.item != item) {
            this.item = item;
            this.stack = null;
            this.setDirty();
        }
    }

    @Override
    @Nullable
    public Vec3d getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(@Nullable Vec3d rotation) {
        if (!Objects.equals(this.rotation, rotation)) {
            this.rotation = rotation;
            this.setDirty();
        }
    }

    @Override
    public void writeInitial(ByteBuf buf) {
        ByteBufUtils.writeVec3d(buf, this.position);
        ByteBufUtils.writeOptVec3d(buf, this.rotation);
        buf.writeFloat(this.scale);
        buf.writeBoolean(this.depthTest);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.item.getRegistryName().toString());
        buf.writeInt(this.damage);
    }

    @Override
    public void readInitial(ByteBuf buf) {
        this.position = ByteBufUtils.readVec3d(buf);
        this.rotation = ByteBufUtils.readOptVec3d(buf);
        this.scale = buf.readFloat();
        this.depthTest = buf.readBoolean();
        ResourceLocation name = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.item = (Item)Item.field_150901_e.func_82594_a((Object)name);
        this.damage = buf.readInt();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(CanvasClient canvas) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)this.position.field_72450_a, (double)this.position.field_72448_b, (double)this.position.field_72449_c);
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)this.scale);
        if (this.rotation == null) {
            RenderManager renderManager = mc.func_175598_ae();
            GlStateManager.func_179114_b((float)(180.0f - renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        } else {
            GlStateManager.func_179114_b((float)((float)this.rotation.field_72450_a), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)this.rotation.field_72448_b), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)this.rotation.field_72449_c), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179091_B();
        if (this.depthTest) {
            GlStateManager.func_179126_j();
        } else {
            GlStateManager.func_179097_i();
        }
        if (this.stack == null) {
            this.stack = new ItemStack(this.item, 1, this.damage);
        }
        mc.func_175599_af().func_184392_a(this.stack, (EntityLivingBase)mc.field_71439_g, ItemCameraTransforms.TransformType.NONE, false);
        GlStateManager.func_179121_F();
    }
}

