/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.appliedenergistics;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.me.helpers.MachineSource;
import dan200.computercraft.api.lua.LuaException;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.squiddev.plethora.api.method.ArgumentHelper;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.ITransferMethod;
import org.squiddev.plethora.api.method.MarkerInterfaces;
import org.squiddev.plethora.api.method.wrapper.FromContext;
import org.squiddev.plethora.api.method.wrapper.Optional;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.integration.vanilla.method.MethodsInventoryTransfer;

public final class MethodExportItem {
    private MethodExportItem() {
    }

    @PlethoraMethod(modId="appliedenergistics2", doc="-- Export this item from the AE network to an inventory. Returns the amount transferred.")
    @MarkerInterfaces(value={ITransferMethod.class})
    public static long export(IContext<IAEItemStack> baked, @FromContext IGrid grid, @FromContext IActionHost host, String toName, @Optional(defInt=0x7FFFFFFF) int limit, @Optional int toSlot) throws LuaException {
        ItemStack remainder;
        Object location = baked.getTransferLocation(toName);
        if (location == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IItemHandler to = MethodsInventoryTransfer.extractHandler(location);
        if (to == null) {
            throw new LuaException("Target '" + toName + "' is not an inventory");
        }
        if (toSlot != -1) {
            ArgumentHelper.assertBetween(toSlot, 1, to.getSlots(), "To slot out of range (%s)");
        }
        if (limit <= 0) {
            throw new LuaException("Limit must be > 0");
        }
        IItemStorageChannel channel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        IStorageGrid storageGrid = (IStorageGrid)grid.getCache(IStorageGrid.class);
        MachineSource source = new MachineSource(host);
        IAEItemStack toExtract = ((IAEItemStack)baked.getTarget()).copy();
        toExtract.setStackSize((long)Math.min(limit, toExtract.getDefinition().func_77976_d()));
        toExtract = (IAEItemStack)storageGrid.getInventory((IStorageChannel)channel).extractItems((IAEStack)toExtract, Actionable.MODULATE, (IActionSource)source);
        ItemStack toInsert = toExtract.createItemStack();
        ItemStack itemStack = remainder = toSlot <= 0 ? ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)toInsert, (boolean)false) : to.insertItem(toSlot - 1, toInsert, false);
        if (!remainder.func_190926_b()) {
            storageGrid.getInventory((IStorageChannel)channel).injectItems(channel.createStack((Object)remainder), Actionable.MODULATE, (IActionSource)source);
        }
        return toExtract.getStackSize() - (long)remainder.func_190916_E();
    }
}

