/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla.meta;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.BaseMetaProvider;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.api.reference.BlockReference;
import org.squiddev.plethora.integration.vanilla.IntegrationVanilla;

@Injects
public final class MetaDaylightSensor
extends BaseMetaProvider<BlockReference> {
    public MetaDaylightSensor() {
        super("Provides metadata about block light levels, when the daylight sensor module is attached.");
    }

    @Override
    @Nonnull
    public Map<String, ?> getMeta(@Nonnull IPartialContext<BlockReference> context) {
        if (!context.getModules().hasModule(IntegrationVanilla.daylightSensorMod)) {
            return Collections.emptyMap();
        }
        IWorldLocation location = context.getTarget().getLocation();
        World world = location.getWorld();
        BlockPos pos = location.getPos();
        HashMap<String, Integer> out = new HashMap<String, Integer>(2);
        if (!world.field_73011_w.func_191066_m()) {
            out.put("sky", world.func_175642_b(EnumSkyBlock.SKY, pos) - world.func_175657_ab());
        }
        out.put("block", world.func_175642_b(EnumSkyBlock.BLOCK, pos));
        return Collections.singletonMap("light", out);
    }
}

