/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.gui.advertselection;

import com.google.common.base.Function;
import com.google.common.eventbus.Subscribe;
import net.malisis.advert.advert.Advert;
import net.malisis.advert.advert.AdvertSelection;
import net.malisis.advert.advert.ClientAdvert;
import net.malisis.advert.gui.AdvertView;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.malisis.core.client.gui.component.interaction.UISelect;
import net.malisis.core.client.gui.component.interaction.UITextField;
import net.malisis.core.client.gui.event.component.StateChangeEvent;
import org.lwjgl.opengl.GL11;

public class AdvertSelectionComponent
extends UIContainer<AdvertSelectionComponent> {
    private AdvertSelection advertSelection;
    private AdvertView advertView;
    private int index;
    private UISelect<ClientAdvert> selAdvert;
    private UITextField fromX;
    private UITextField fromY;
    private UITextField toX;
    private UITextField toY;

    public AdvertSelectionComponent(MalisisGui gui, int index, AdvertView view) {
        super(gui);
        this.setSize(0, 60);
        this.setPadding(2, 2);
        this.advertView = view;
        this.index = index;
        this.createSelect(gui);
        this.createClipping(gui);
    }

    private void createSelect(MalisisGui gui) {
        UILabel labelAdvert = new UILabel(gui, "{malisisadvert.gui.advert} " + this.index + " :");
        Function<ClientAdvert, String> labelFunc = new Function<ClientAdvert, String>(){

            public String apply(ClientAdvert advert) {
                return advert.getName();
            }
        };
        this.selAdvert = (UISelect)((UISelect)new UISelect(gui, 150, ClientAdvert.listAdverts()).setPosition(0, 12)).register((Object)this);
        this.selAdvert.setLabelFunction((Function)labelFunc);
        this.add(new UIComponent[]{labelAdvert});
        this.add(new UIComponent[]{this.selAdvert});
    }

    private void createClipping(MalisisGui gui) {
        int y = 27;
        int w = 30;
        UILabel labelSelection = (UILabel)new UILabel(gui, "malisisadvert.gui.clip").setPosition(0, y);
        int x = 0;
        UILabel from = (UILabel)new UILabel(gui, "malisisadvert.gui.from").setPosition(x, (y += 12) + 3);
        this.fromX = ((UITextField)new UITextField(gui, false).setPosition(x += from.getWidth() + 2, y)).setSize(w, 0);
        UILabel commaFrom = (UILabel)new UILabel(gui, ", ").setPosition(x += w + 2, y + 3);
        this.fromY = ((UITextField)new UITextField(gui, false).setPosition(x += commaFrom.getWidth(), y)).setSize(w, 0);
        UILabel to = (UILabel)new UILabel(gui, "malisisadvert.gui.to").setPosition(x += w + 2, y + 3);
        this.toX = ((UITextField)new UITextField(gui, false).setPosition(x += to.getWidth() + 2, y)).setSize(w, 0);
        UILabel commaTo = (UILabel)new UILabel(gui, ", ").setPosition(x += w + 2, y + 3);
        this.toY = ((UITextField)new UITextField(gui, false).setPosition(x += commaTo.getWidth(), y)).setSize(w, 0);
        x += w + 2;
        this.add(new UIComponent[]{labelSelection});
        this.add(new UIComponent[]{from, this.fromX, commaFrom, this.fromY});
        this.add(new UIComponent[]{to, this.toX, commaTo, this.toY});
    }

    public AdvertSelection getAdvertSelection() {
        return this.advertSelection;
    }

    public void setAdvertSelection(AdvertSelection advertSelection) {
        this.advertSelection = advertSelection;
        this.updateComponents();
    }

    public void updateComponents() {
        if (this.advertSelection == null) {
            this.selAdvert.setSelectedOption((Object)null);
            this.fromX.setText("");
            this.fromY.setText("");
            this.toX.setText("");
            this.toY.setText("");
        } else {
            AdvertSelection as = this.advertSelection;
            this.selAdvert.setSelectedOption((Object)as.getAdvert());
            this.fromX.setText("" + as.getX(as.u));
            this.fromY.setText("" + as.getY(as.v));
            this.toX.setText("" + as.getX(as.U));
            this.toY.setText("" + as.getY(as.V));
        }
    }

    public void saveUVs() {
        if (this.advertSelection == null) {
            return;
        }
        int x = 0;
        int y = 0;
        int X = 0;
        int Y = 0;
        try {
            x = Integer.decode(this.fromX.getText());
            y = Integer.decode(this.fromY.getText());
            X = Integer.decode(this.toX.getText());
            Y = Integer.decode(this.toY.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.advertSelection.setPixels(x, y, X, Y);
    }

    private boolean isSelected() {
        if (this.isFocused()) {
            return true;
        }
        for (UIComponent c : this.components) {
            if (!c.isFocused()) continue;
            return true;
        }
        return false;
    }

    public boolean onClick(int x, int y) {
        this.advertView.setAdvertSelection(this, this.advertSelection);
        return super.onClick(x, y);
    }

    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (!this.isSelected()) {
            return;
        }
        renderer.drawRectangle(0, 0, 0, this.getWidth(), this.getHeight(), 0xBBBBEE, 255);
        renderer.next(2);
        GL11.glLineWidth((float)2.0f);
        renderer.drawRectangle(0, 0, 0, this.getWidth(), this.getHeight(), 0, 255);
        renderer.next(7);
    }

    @Subscribe
    public void onSelect(UISelect.SelectEvent<Advert> event) {
        this.setAdvertSelection(new AdvertSelection(((Advert)event.getNewValue()).getId()));
        this.advertView.setAdvertSelection(this, this.advertSelection);
    }

    @Subscribe
    public void onFocus(StateChangeEvent.FocusStateChange<?> event) {
        if (event.getState()) {
            this.advertView.setAdvertSelection(this, this.advertSelection);
        }
    }
}

