/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.blocks;

import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.tiles.TileEntityCamouflage;
import vswe.superfactory.tiles.TileEntityCluster;

public abstract class BlockCamouflageBase
extends BlockContainer {
    public static final AxisAlignedBB NO_BLOCK_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    protected BlockCamouflageBase(Material material) {
        super(material);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        TileEntityCamouflage camouflage = (TileEntityCamouflage)TileEntityCluster.getTileEntity(TileEntityCamouflage.class, world, pos);
        return camouflage == null || camouflage.isNormalBlock();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        TileEntityCamouflage camouflage = (TileEntityCamouflage)TileEntityCluster.getTileEntity(TileEntityCamouflage.class, (IBlockAccess)world, pos);
        if (camouflage != null && camouflage.getCamouflageType().useSpecialShape() && !camouflage.isUseCollision()) {
            return 600000.0f;
        }
        return super.func_176195_g(state, world, pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.getBlockBoundsBasedOnState(state, source, pos);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (!this.setBlockCollisionBoundsBasedOnState(state, world, pos)) {
            return NO_BLOCK_AABB;
        }
        return super.func_180646_a(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        if (!this.setBlockCollisionBoundsBasedOnState(state, (IBlockAccess)world, pos)) {
            return NO_BLOCK_AABB;
        }
        return super.func_180640_a(state, world, pos);
    }

    private boolean setBlockCollisionBoundsBasedOnState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityCamouflage camouflage = (TileEntityCamouflage)TileEntityCluster.getTileEntity(TileEntityCamouflage.class, world, pos);
        if (camouflage != null && camouflage.getCamouflageType().useSpecialShape()) {
            return camouflage.isUseCollision();
        }
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        if (!this.setBlockCollisionBoundsBasedOnState(state, (IBlockAccess)world, pos)) {
            return this.func_185503_a(pos, start, end, NO_BLOCK_AABB);
        }
        return super.func_180636_a(state, world, pos, start, end);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public AxisAlignedBB getBlockBoundsBasedOnState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityCamouflage camouflage = (TileEntityCamouflage)TileEntityCluster.getTileEntity(TileEntityCamouflage.class, world, pos);
        if (camouflage != null && camouflage.getCamouflageType().useSpecialShape()) {
            return camouflage.getBlockBounds();
        }
        return this.getBlockBoundsForItemRender();
    }

    public AxisAlignedBB getBlockBoundsForItemRender() {
        return field_185505_j;
    }
}

