/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.blocks;

import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import vswe.superfactory.Localization;
import vswe.superfactory.blocks.IRedstoneNode;
import vswe.superfactory.tiles.TileEntityBUD;
import vswe.superfactory.tiles.TileEntityCamouflage;
import vswe.superfactory.tiles.TileEntityInput;
import vswe.superfactory.tiles.TileEntityOutput;
import vswe.superfactory.tiles.TileEntitySignUpdater;

public enum ConnectionBlockType {
    INVENTORY(Localization.TYPE_INVENTORY, null, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, false),
    TANK(Localization.TYPE_TANK, null, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, false),
    EMITTER(Localization.TYPE_EMITTER, TileEntityOutput.class, null, false),
    RECEIVER(Localization.TYPE_RECEIVER, TileEntityInput.class, null, false),
    NODE(Localization.TYPE_NODE, IRedstoneNode.class, null, true),
    BUD(Localization.TYPE_BUD, TileEntityBUD.class, null, false),
    CAMOUFLAGE(Localization.TYPE_CAMOUFLAGE, TileEntityCamouflage.class, null, false),
    SIGN(Localization.TYPE_SIGN, TileEntitySignUpdater.class, null, false);

    private Capability capability;
    private Class clazz;
    private boolean group;
    private Localization name;

    private ConnectionBlockType(@Nullable Localization name, Class clazz, Capability capability, boolean group) {
        this.name = name;
        this.clazz = clazz;
        this.capability = capability;
        this.group = group;
    }

    public boolean isInstance(TileEntity tileEntity) {
        if (this.clazz != null && this.clazz.isInstance(tileEntity)) {
            return true;
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (this.capability == null || tileEntity == null || !tileEntity.hasCapability(this.capability, facing)) continue;
            return true;
        }
        return false;
    }

    public <T> T getObject(TileEntity tileEntity) {
        return (T)tileEntity;
    }

    public boolean isGroup() {
        return this.group;
    }

    public Localization getName() {
        return this.name;
    }

    public String toString() {
        return this.name.toString();
    }
}

