/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.CollisionHelper;
import vswe.superfactory.Localization;
import vswe.superfactory.components.ComponentMenuItem;
import vswe.superfactory.components.ComponentMenuStuff;
import vswe.superfactory.components.CraftingDummy;
import vswe.superfactory.components.FlowComponent;
import vswe.superfactory.components.internal.CraftingSetting;
import vswe.superfactory.components.internal.Setting;
import vswe.superfactory.interfaces.GuiManager;

public class ComponentMenuCrafting
extends ComponentMenuItem {
    private CraftingDummy dummy;
    private CraftingSetting resultItem = new CraftingSetting(9){

        @Override
        public boolean canChangeMetaData() {
            return false;
        }

        @Override
        public void delete() {
            for (Setting setting : ComponentMenuCrafting.this.settings) {
                setting.clear();
                ComponentMenuCrafting.this.writeServerData(ComponentMenuStuff.DataTypeHeader.CLEAR, setting);
            }
        }
    };

    public ComponentMenuCrafting(FlowComponent parent) {
        super(parent, CraftingSetting.class);
        this.settings.add(this.resultItem);
        this.dummy = new CraftingDummy(this);
        this.scrollControllerSelected.setItemsPerRow(3);
        this.scrollControllerSelected.setVisibleRows(3);
        this.scrollControllerSelected.setItemUpperLimit(2);
        this.scrollControllerSelected.setDisabledScroll(true);
    }

    @Override
    public String getName() {
        return Localization.CRAFTING_MENU.toString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClick(int mX, int mY, int button) {
        super.onClick(mX, mY, button);
        if (!this.isEditing() && !this.isSearching() && !this.resultItem.getItem().func_190926_b() && button == 1 && CollisionHelper.inBounds(this.getResultX(), this.getResultY(), 16, 16, mX, mY)) {
            this.scrollControllerSelected.onClick(this.resultItem, mX, mY, 1);
        }
    }

    @Override
    protected void initRadioButtons() {
    }

    @Override
    protected int getSettingCount() {
        return 9;
    }

    @Override
    protected void onSettingContentChange() {
        this.resultItem.setItem(this.dummy.getResult());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        super.draw(gui, mX, mY);
        if (!(this.isEditing() || this.isSearching() || this.resultItem.getItem().func_190926_b())) {
            this.drawResultObject(gui, this.resultItem.getItem(), this.getResultX(), this.getResultY());
            gui.drawItemAmount(this.resultItem.getItem(), this.getResultX(), this.getResultY());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
        super.drawMouseOver(gui, mX, mY);
        if (!this.isEditing() && !this.isSearching() && !this.resultItem.getItem().func_190926_b() && CollisionHelper.inBounds(this.getResultX(), this.getResultY(), 16, 16, mX, mY)) {
            gui.drawMouseOver(this.getResultObjectMouseOver(this.resultItem.getItem()), mX, mY);
        }
    }

    private int getResultX() {
        return 65;
    }

    private int getResultY() {
        return this.scrollControllerSelected.getScrollingStartY() + 20;
    }

    public CraftingDummy getDummy() {
        return this.dummy;
    }

    public CraftingSetting getResultItem() {
        return this.resultItem;
    }
}

