/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components;

import java.util.Comparator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.Localization;
import vswe.superfactory.components.CheckBox;
import vswe.superfactory.components.CheckBoxList;
import vswe.superfactory.components.ComponentMenu;
import vswe.superfactory.components.FlowComponent;
import vswe.superfactory.components.RadioButton;
import vswe.superfactory.components.RadioButtonList;
import vswe.superfactory.components.TextBoxNumber;
import vswe.superfactory.components.TextBoxNumberList;
import vswe.superfactory.interfaces.ContainerManager;
import vswe.superfactory.interfaces.GuiManager;
import vswe.superfactory.network.packets.DataBitHelper;
import vswe.superfactory.network.packets.DataReader;
import vswe.superfactory.network.packets.DataWriter;
import vswe.superfactory.network.packets.PacketHandler;

public class ComponentMenuListOrder
extends ComponentMenu {
    private static final int CHECK_BOX_AMOUNT_Y = 5;
    private static final int CHECK_BOX_REVERSE_Y = 58;
    private static final int CHECK_BOX_X = 5;
    private static final String NBT_ALL = "All";
    private static final String NBT_AMOUNT = "Amount";
    private static final String NBT_ORDER = "Order";
    private static final String NBT_REVERSED = "Reversed";
    private static final int RADIO_BUTTON_X = 5;
    private static final int RADIO_BUTTON_Y = 20;
    private static final int RADIO_SPACING_Y = 12;
    private static final int TEXT_BOX_X = 60;
    private static final int TEXT_BOX_Y = 3;
    private boolean all;
    private CheckBoxList checkBoxes;
    private RadioButtonList radioButtons = new RadioButtonList(){

        @Override
        public void updateSelectedOption(int selectedOption) {
            this.setSelectedOption(selectedOption);
            ComponentMenuListOrder.this.sendServerData(UpdateType.TYPE);
        }
    };
    private boolean reversed;
    private TextBoxNumber textBox;
    private TextBoxNumberList textBoxes;

    public ComponentMenuListOrder(FlowComponent parent) {
        super(parent);
        for (int i = 0; i < LoopOrder.values().length; ++i) {
            int x = 5;
            int y = 20 + i * 12;
            this.radioButtons.add(new RadioButton(x, y, LoopOrder.values()[i].getName()));
        }
        this.checkBoxes = new CheckBoxList();
        this.checkBoxes.addCheckBox(new CheckBox(Localization.USE_ALL, 5, 5){

            @Override
            public boolean getValue() {
                return ComponentMenuListOrder.this.all;
            }

            @Override
            public void setValue(boolean val) {
                ComponentMenuListOrder.this.all = val;
            }

            @Override
            public void onUpdate() {
                ComponentMenuListOrder.this.sendServerData(UpdateType.USE_ALL);
            }
        });
        this.checkBoxes.addCheckBox(new CheckBox(Localization.REVERSED, 5, 58){

            @Override
            public void setValue(boolean val) {
                ComponentMenuListOrder.this.reversed = val;
            }

            @Override
            public boolean getValue() {
                return ComponentMenuListOrder.this.reversed;
            }

            @Override
            public void onUpdate() {
                ComponentMenuListOrder.this.sendServerData(UpdateType.REVERSED);
            }

            @Override
            public boolean isVisible() {
                return ComponentMenuListOrder.this.canReverse();
            }
        });
        this.all = true;
        this.textBoxes = new TextBoxNumberList();
        this.textBox = new TextBoxNumber(60, 3, 2, false){

            @Override
            public boolean isVisible() {
                return !ComponentMenuListOrder.this.all;
            }

            @Override
            public void onNumberChanged() {
                ComponentMenuListOrder.this.sendServerData(UpdateType.AMOUNT);
            }
        };
        this.textBoxes.addTextBox(this.textBox);
        this.textBox.setNumber(1);
    }

    private void sendServerData(UpdateType type) {
        DataWriter dw = this.getWriterForServerComponentPacket();
        this.writeData(dw, type);
        PacketHandler.sendDataToServer(dw);
    }

    private void writeData(DataWriter dw, UpdateType type) {
        dw.writeData(type.ordinal(), DataBitHelper.ORDER_TYPES);
        switch (type) {
            case USE_ALL: {
                dw.writeBoolean(this.all);
                break;
            }
            case AMOUNT: {
                dw.writeData(this.textBox.getNumber(), DataBitHelper.ORDER_AMOUNT);
                break;
            }
            case TYPE: {
                dw.writeData(this.radioButtons.getSelectedOption(), DataBitHelper.ORDER_TYPES);
                break;
            }
            case REVERSED: {
                dw.writeBoolean(this.reversed);
            }
        }
    }

    private boolean canReverse() {
        return this.getOrder() != LoopOrder.RANDOM;
    }

    public LoopOrder getOrder() {
        return LoopOrder.values()[this.radioButtons.getSelectedOption()];
    }

    @Override
    public String getName() {
        return Localization.LOOP_ORDER_MENU.toString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        this.radioButtons.draw(gui, mX, mY);
        this.checkBoxes.draw(gui, mX, mY);
        this.textBoxes.draw(gui, mX, mY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        this.radioButtons.onClick(mX, mY, button);
        this.checkBoxes.onClick(mX, mY);
        this.textBoxes.onClick(mX, mY, button);
    }

    @Override
    public void onDrag(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void onRelease(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onKeyStroke(GuiManager gui, char c, int k) {
        return this.textBoxes.onKeyStroke(gui, c, k);
    }

    @Override
    public void writeData(DataWriter dw) {
        dw.writeBoolean(this.all);
        dw.writeData(this.textBox.getNumber(), DataBitHelper.ORDER_AMOUNT);
        dw.writeBoolean(this.reversed);
        dw.writeData(this.radioButtons.getSelectedOption(), DataBitHelper.ORDER_TYPES);
    }

    @Override
    public void readData(DataReader dr) {
        this.all = dr.readBoolean();
        this.textBox.setNumber(dr.readData(DataBitHelper.ORDER_AMOUNT));
        this.reversed = dr.readBoolean();
        this.radioButtons.setSelectedOption(dr.readData(DataBitHelper.ORDER_TYPES));
    }

    @Override
    public void copyFrom(ComponentMenu menu) {
        ComponentMenuListOrder menuOrder = (ComponentMenuListOrder)menu;
        this.all = menuOrder.all;
        this.textBox.setNumber(menuOrder.textBox.getNumber());
        this.reversed = menuOrder.reversed;
        this.radioButtons.setSelectedOption(menuOrder.radioButtons.getSelectedOption());
    }

    @Override
    public void refreshData(ContainerManager container, ComponentMenu newData) {
        ComponentMenuListOrder newDataOrder = (ComponentMenuListOrder)newData;
        if (this.all != newDataOrder.all) {
            this.all = newDataOrder.all;
            this.sendClientData(container, UpdateType.USE_ALL);
        }
        if (this.textBox.getNumber() != newDataOrder.textBox.getNumber()) {
            this.textBox.setNumber(newDataOrder.textBox.getNumber());
        }
        if (this.reversed != newDataOrder.reversed) {
            this.reversed = newDataOrder.reversed;
            this.sendClientData(container, UpdateType.REVERSED);
        }
        if (this.radioButtons.getSelectedOption() != newDataOrder.radioButtons.getSelectedOption()) {
            this.radioButtons.setSelectedOption(newDataOrder.radioButtons.getSelectedOption());
            this.sendClientData(container, UpdateType.TYPE);
        }
    }

    private void sendClientData(ContainerManager container, UpdateType type) {
        DataWriter dw = this.getWriterForClientComponentPacket(container);
        this.writeData(dw, type);
        PacketHandler.sendDataToListeningClients(container, dw);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound, int version, boolean pickup) {
        this.all = nbtTagCompound.func_74767_n(NBT_ALL);
        this.textBox.setNumber(nbtTagCompound.func_74771_c(NBT_AMOUNT));
        this.reversed = nbtTagCompound.func_74767_n(NBT_REVERSED);
        this.radioButtons.setSelectedOption(nbtTagCompound.func_74771_c(NBT_ORDER));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        nbtTagCompound.func_74757_a(NBT_ALL, this.all);
        nbtTagCompound.func_74774_a(NBT_AMOUNT, (byte)this.textBox.getNumber());
        nbtTagCompound.func_74757_a(NBT_REVERSED, this.reversed);
        nbtTagCompound.func_74774_a(NBT_ORDER, (byte)this.radioButtons.getSelectedOption());
    }

    @Override
    public void readNetworkComponent(DataReader dr) {
        UpdateType type = UpdateType.values()[dr.readData(DataBitHelper.ORDER_TYPES)];
        switch (type) {
            case USE_ALL: {
                this.all = dr.readBoolean();
                break;
            }
            case AMOUNT: {
                this.textBox.setNumber(dr.readData(DataBitHelper.ORDER_AMOUNT));
                break;
            }
            case REVERSED: {
                this.reversed = dr.readBoolean();
                break;
            }
            case TYPE: {
                this.radioButtons.setSelectedOption(dr.readData(DataBitHelper.ORDER_TYPES));
            }
        }
    }

    public Comparator<? super Integer> getComparator() {
        return this.reversed ? this.getOrder().reversedComparator : this.getOrder().comparator;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public int getAmount() {
        return this.textBox.getNumber();
    }

    public boolean useAll() {
        return this.all;
    }

    private static enum UpdateType {
        USE_ALL,
        AMOUNT,
        TYPE,
        REVERSED;

    }

    public static enum LoopOrder {
        NORMAL(Localization.ORDER_STANDARD, null),
        CABLE(Localization.ORDER_CABLE, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1 < o2 ? -1 : 1;
            }
        }),
        RANDOM(Localization.ORDER_RANDOM, null);

        private Comparator<Integer> comparator;
        private Localization name;
        private Comparator<Integer> reversedComparator;

        private LoopOrder(Localization name, final Comparator<Integer> comparator) {
            this.name = name;
            this.comparator = comparator;
            if (comparator != null) {
                this.reversedComparator = new Comparator<Integer>(){

                    @Override
                    public int compare(Integer o1, Integer o2) {
                        return comparator.compare(o2, o1);
                    }
                };
            }
        }

        public String toString() {
            return this.name.toString();
        }

        public Localization getName() {
            return this.name;
        }
    }
}

