/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import vswe.superfactory.components.FlowComponent;
import vswe.superfactory.components.internal.IItemBufferElement;
import vswe.superfactory.components.internal.IItemBufferSubElement;
import vswe.superfactory.components.internal.ItemSetting;
import vswe.superfactory.components.internal.Setting;
import vswe.superfactory.components.internal.SlotInventoryHolder;
import vswe.superfactory.components.internal.SlotStackInventoryHolder;

public class ItemBufferElement
implements IItemBufferElement {
    private FlowComponent component;
    private int currentStackSize;
    private boolean fairShare;
    private List<SlotStackInventoryHolder> holders;
    private SlotInventoryHolder inventoryHolder;
    private Iterator<SlotStackInventoryHolder> iterator;
    private ItemSetting setting;
    private int shareId;
    private int sharedBy;
    private int totalStackSize;
    private boolean useWhiteList;

    public ItemBufferElement(FlowComponent owner, Setting setting, SlotInventoryHolder inventoryHolder, boolean useWhiteList, SlotStackInventoryHolder target) {
        this(owner, setting, inventoryHolder, useWhiteList);
        this.addTarget(target);
        this.sharedBy = 1;
    }

    private ItemBufferElement(FlowComponent owner, Setting setting, SlotInventoryHolder inventoryHolder, boolean useWhiteList) {
        this.component = owner;
        this.setting = (ItemSetting)setting;
        this.inventoryHolder = inventoryHolder;
        this.useWhiteList = useWhiteList;
        this.holders = new ArrayList<SlotStackInventoryHolder>();
    }

    private void addTarget(SlotStackInventoryHolder target) {
        this.holders.add(target);
        this.totalStackSize += target.getSizeRemaining();
        this.currentStackSize = this.totalStackSize;
    }

    public boolean addTarget(FlowComponent owner, Setting setting, SlotInventoryHolder inventoryHolder, SlotStackInventoryHolder target) {
        if (this.component.getId() == owner.getId() && (this.setting == null || setting != null && this.setting.getId() == setting.getId()) && (this.inventoryHolder.isShared() || this.inventoryHolder.equals(inventoryHolder))) {
            this.addTarget(target);
            return true;
        }
        return false;
    }

    public Setting getSetting() {
        return this.setting;
    }

    public List<SlotStackInventoryHolder> getSubElements() {
        return this.holders;
    }

    @Override
    public void prepareSubElements() {
        this.iterator = this.holders.iterator();
    }

    @Override
    public IItemBufferSubElement getSubElement() {
        if (this.iterator.hasNext()) {
            return this.iterator.next();
        }
        return null;
    }

    @Override
    public void removeSubElement() {
        this.iterator.remove();
    }

    @Override
    public int retrieveItemCount(int desiredItemCount) {
        int itemsAllowedToBeMoved;
        if (this.setting == null || !this.setting.isLimitedByAmount()) {
            return desiredItemCount;
        }
        if (this.useWhiteList) {
            int movedItems = this.totalStackSize - this.currentStackSize;
            itemsAllowedToBeMoved = this.setting.getAmount() - movedItems;
            int amountLeft = itemsAllowedToBeMoved % this.sharedBy;
            itemsAllowedToBeMoved /= this.sharedBy;
            if (!this.fairShare && this.shareId < amountLeft) {
                ++itemsAllowedToBeMoved;
            }
        } else {
            itemsAllowedToBeMoved = this.currentStackSize - this.setting.getItem().func_190916_E();
        }
        return Math.min(itemsAllowedToBeMoved, desiredItemCount);
    }

    @Override
    public void decreaseStackSize(int itemsToMove) {
        this.currentStackSize -= itemsToMove * (this.useWhiteList ? this.sharedBy : 1);
    }

    @Override
    public void releaseSubElements() {
        this.iterator = null;
    }

    public ItemStack getItemStack() {
        if (this.setting != null && !this.setting.getItem().func_190926_b()) {
            return this.setting.getItem();
        }
        return this.holders.get(0).getItemStack();
    }

    public int getBufferSize(Setting outputSetting) {
        int bufferSize = 0;
        if (this.setting != null) {
            for (SlotStackInventoryHolder holder : this.holders) {
                ItemStack item = holder.getItemStack();
                if (!this.setting.isEqualForCommandExecutor(item)) continue;
                bufferSize += item.func_190916_E();
            }
            if (this.setting.isLimitedByAmount()) {
                int maxSize = this.useWhiteList ? this.setting.getItem().func_190916_E() : this.totalStackSize - this.setting.getItem().func_190916_E();
                bufferSize = Math.min(bufferSize, maxSize);
            }
        }
        return bufferSize;
    }

    public ItemBufferElement getSplitElement(int elementAmount, int id, boolean fair) {
        ItemBufferElement element = new ItemBufferElement(this.component, this.setting, this.inventoryHolder, this.useWhiteList);
        element.holders = new ArrayList<SlotStackInventoryHolder>();
        for (SlotStackInventoryHolder holder : this.holders) {
            element.addTarget(holder.getSplitElement(elementAmount, id, fair));
        }
        if (this.useWhiteList) {
            element.sharedBy = this.sharedBy * elementAmount;
            element.fairShare = fair;
            element.shareId = elementAmount * this.shareId + id;
            element.currentStackSize -= this.totalStackSize - this.currentStackSize;
            if (element.currentStackSize < 0) {
                element.currentStackSize = 0;
            }
        } else {
            element.currentStackSize = Math.min(this.currentStackSize, element.totalStackSize);
        }
        return element;
    }
}

