/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.util;

import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class CapabilityUtils {
    @CapabilityInject(value=IFluidHandler.class)
    public static final Capability<IFluidHandler> FLUID_HANDLER = null;
    @CapabilityInject(value=IItemHandler.class)
    public static final Capability<IItemHandler> ITEM_HANDLER = null;

    public static boolean hasFluidHandler(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return CapabilityUtils.hasFluidHandler(world.func_175625_s(pos), face);
    }

    public static boolean hasFluidHandler(TileEntity tile, EnumFacing face) {
        return tile != null && tile.hasCapability(FLUID_HANDLER, face);
    }

    public static boolean hasFluidHandler(IBlockAccess world, BlockPos pos, int face) {
        return CapabilityUtils.hasFluidHandler(world.func_175625_s(pos), face);
    }

    public static boolean hasFluidHandler(TileEntity tile, int face) {
        return CapabilityUtils.hasFluidHandler(tile, EnumFacing.field_82609_l[face]);
    }

    public static IFluidHandler getFluidHandler_Raw(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return CapabilityUtils.getFluidHandler_Raw(world.func_175625_s(pos), face);
    }

    public static IFluidHandler getFluidHandler_Raw(TileEntity tile, EnumFacing face) {
        return (IFluidHandler)tile.getCapability(FLUID_HANDLER, face);
    }

    public static IFluidHandler getFluidHandler_Raw(IBlockAccess world, BlockPos pos, int face) {
        return CapabilityUtils.getFluidHandler_Raw(world.func_175625_s(pos), face);
    }

    public static IFluidHandler getFluidHandler_Raw(TileEntity tile, int face) {
        return CapabilityUtils.getFluidHandler_Raw(tile, EnumFacing.field_82609_l[face]);
    }

    public static IFluidHandler getFluidHandler(TileEntity tile, EnumFacing face) {
        return CapabilityUtils.getFluidHandlerOr(tile, face, null);
    }

    public static IFluidHandler getFluidHandlerOr(TileEntity tile, EnumFacing face, IFluidHandler _default) {
        return CapabilityUtils.hasFluidHandler(tile, face) ? CapabilityUtils.getFluidHandler_Raw(tile, face) : _default;
    }

    public static IFluidHandler getFluidHandler(TileEntity tile, int face) {
        return CapabilityUtils.getFluidHandlerOr(tile, face, null);
    }

    public static IFluidHandler getFluidHandlerOr(TileEntity tile, int face, IFluidHandler _default) {
        return CapabilityUtils.hasFluidHandler(tile, face) ? CapabilityUtils.getFluidHandler_Raw(tile, face) : _default;
    }

    public static IFluidHandler getFluidHandler(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return CapabilityUtils.getFluidHandlerOr(world, pos, face, null);
    }

    public static IFluidHandler getFluidHandlerOr(IBlockAccess world, BlockPos pos, EnumFacing face, IFluidHandler _default) {
        return CapabilityUtils.getFluidHandlerOr(world.func_175625_s(pos), face, _default);
    }

    public static IFluidHandler getFluidHandler(IBlockAccess world, BlockPos pos, int face) {
        return CapabilityUtils.getFluidHandlerOr(world, pos, face, null);
    }

    public static IFluidHandler getFluidHandlerOr(IBlockAccess world, BlockPos pos, int face, IFluidHandler _default) {
        return CapabilityUtils.getFluidHandlerOr(world.func_175625_s(pos), face, _default);
    }

    public static IFluidHandler getFluidHandlerOrEmpty(TileEntity tile, EnumFacing face) {
        return CapabilityUtils.getFluidHandlerOr(tile, face, (IFluidHandler)EmptyFluidHandler.INSTANCE);
    }

    public static IFluidHandler getFluidHandlerOrEmpty(TileEntity tile, int face) {
        return CapabilityUtils.getFluidHandlerOr(tile, face, (IFluidHandler)EmptyFluidHandler.INSTANCE);
    }

    public static IFluidHandler getFluidHandlerOrEmpty(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return CapabilityUtils.getFluidHandlerOr(world.func_175625_s(pos), face, (IFluidHandler)EmptyFluidHandler.INSTANCE);
    }

    public static IFluidHandler getFluidHandlerOrEmpty(IBlockAccess world, BlockPos pos, int face) {
        return CapabilityUtils.getFluidHandlerOr(world.func_175625_s(pos), face, (IFluidHandler)EmptyFluidHandler.INSTANCE);
    }

    public static boolean hasItemHandler_Raw(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return CapabilityUtils.hasItemHandler_Raw(world.func_175625_s(pos), face);
    }

    public static boolean hasItemHandler_Raw(TileEntity tile, EnumFacing face) {
        return tile != null && tile.hasCapability(ITEM_HANDLER, face);
    }

    public static boolean hasItemHandler_Raw(IBlockAccess world, BlockPos pos, int face) {
        return CapabilityUtils.hasItemHandler_Raw(world.func_175625_s(pos), face);
    }

    public static boolean hasItemHandler_Raw(TileEntity tile, int face) {
        return CapabilityUtils.hasItemHandler_Raw(tile, EnumFacing.field_82609_l[face]);
    }

    public static boolean hasItemHandler(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return CapabilityUtils.hasItemHandler(world.func_175625_s(pos), face);
    }

    public static boolean hasItemHandler(TileEntity tile, EnumFacing face) {
        return CapabilityUtils.hasItemHandler_Raw(tile, face) || tile instanceof IInventory || tile instanceof ISidedInventory;
    }

    public static boolean hasItemHandler(IBlockAccess world, BlockPos pos, int face) {
        return CapabilityUtils.hasItemHandler(world.func_175625_s(pos), face);
    }

    public static boolean hasItemHandler(TileEntity tile, int face) {
        return CapabilityUtils.hasItemHandler(tile, EnumFacing.field_82609_l[face]);
    }

    public static IItemHandler getItemHandler_Raw(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return CapabilityUtils.getItemHandler_Raw(world.func_175625_s(pos), face);
    }

    public static IItemHandler getItemHandler_Raw(TileEntity tile, EnumFacing face) {
        if (CapabilityUtils.hasItemHandler(tile, face)) {
            if (CapabilityUtils.hasItemHandler_Raw(tile, face)) {
                return (IItemHandler)tile.getCapability(ITEM_HANDLER, face);
            }
            if (tile instanceof ISidedInventory && face != null) {
                return new SidedInvWrapper((ISidedInventory)tile, face);
            }
            return new InvWrapper((IInventory)tile);
        }
        return null;
    }

    public static IItemHandler getItemHandler_Raw(IBlockAccess world, BlockPos pos, int face) {
        return CapabilityUtils.getItemHandler_Raw(world.func_175625_s(pos), face);
    }

    public static IItemHandler getItemHandler_Raw(TileEntity tile, int face) {
        return CapabilityUtils.getItemHandler_Raw(tile, EnumFacing.field_82609_l[face]);
    }

    public static IItemHandler getItemHandlerOr(TileEntity tile, int face, IItemHandler _default) {
        return CapabilityUtils.hasItemHandler(tile, face) ? CapabilityUtils.getItemHandler_Raw(tile, face) : _default;
    }

    public static IItemHandler getItemHandlerOr(IBlockAccess world, BlockPos pos, int face, IItemHandler _default) {
        return CapabilityUtils.getItemHandlerOr(world.func_175625_s(pos), face, _default);
    }

    public static IItemHandler getItemHandler(TileEntity tile, EnumFacing face) {
        return CapabilityUtils.getItemHandlerOr(tile, face, null);
    }

    public static IItemHandler getItemHandlerOr(TileEntity tile, EnumFacing face, IItemHandler _default) {
        return CapabilityUtils.hasItemHandler(tile, face) ? CapabilityUtils.getItemHandler_Raw(tile, face) : _default;
    }

    public static IItemHandler getItemHandler(TileEntity tile, int face) {
        return CapabilityUtils.getItemHandlerOr(tile, face, null);
    }

    public static IItemHandler getItemHandler(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return CapabilityUtils.getItemHandlerOr(world, pos, face, null);
    }

    public static IItemHandler getItemHandlerOr(IBlockAccess world, BlockPos pos, EnumFacing face, IItemHandler _default) {
        return CapabilityUtils.getItemHandlerOr(world.func_175625_s(pos), face, _default);
    }

    public static IItemHandler getItemHandler(IBlockAccess world, BlockPos pos, int face) {
        return CapabilityUtils.getItemHandlerOr(world, pos, face, null);
    }

    public static IItemHandler getItemHandlerOrEmpty(TileEntity tile, EnumFacing face) {
        return CapabilityUtils.getItemHandlerOr(tile, face, EmptyHandler.INSTANCE);
    }

    public static IItemHandler getItemHandlerOrEmpty(TileEntity tile, int face) {
        return CapabilityUtils.getItemHandlerOr(tile, face, EmptyHandler.INSTANCE);
    }

    public static IItemHandler getItemHandlerOrEmpty(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return CapabilityUtils.getItemHandlerOr(world.func_175625_s(pos), face, EmptyHandler.INSTANCE);
    }

    public static IItemHandler getItemHandlerOrEmpty(IBlockAccess world, BlockPos pos, int face) {
        return CapabilityUtils.getItemHandlerOr(world.func_175625_s(pos), face, EmptyHandler.INSTANCE);
    }
}

